/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener.states;

import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.contract.HttpResponseFuture;
import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.config.ChunkConfig;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.contractimpl.HttpOutboundRespListener;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.StateUtil;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ListenerReqRespStateManager;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ListenerState;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.SendingEntityBody;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingHeaders
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(SendingHeaders.class);
    private final HttpOutboundRespListener outboundResponseListener;
    boolean keepAlive;
    private final ListenerReqRespStateManager listenerReqRespStateManager;
    ChunkConfig chunkConfig;
    HttpResponseFuture outboundRespStatusFuture;

    public SendingHeaders(ListenerReqRespStateManager listenerReqRespStateManager, HttpOutboundRespListener outboundResponseListener) {
        this.listenerReqRespStateManager = listenerReqRespStateManager;
        this.outboundResponseListener = outboundResponseListener;
        this.chunkConfig = outboundResponseListener.getChunkConfig();
        this.keepAlive = outboundResponseListener.isKeepAlive();
    }

    @Override
    public void readInboundRequestHeaders(HttpCarbonMessage inboundRequestMsg, HttpRequest inboundRequestHeaders) {
        LOG.warn("readInboundRequestHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void readInboundRequestBody(Object inboundRequestEntityBody) throws ServerConnectorException {
        LOG.warn("readInboundRequestBody {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void writeOutboundResponseBody(HttpOutboundRespListener outboundResponseListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        LOG.warn("writeOutboundResponseBody {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture) {
        LOG.error("Remote client closed the connection while writing outbound response headers");
    }

    @Override
    public ChannelFuture handleIdleTimeoutConnectionClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx) {
        LOG.error("Idle timeout triggered while writing outbound response headers");
        return null;
    }

    @Override
    public void writeOutboundResponseHeaders(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        ChunkConfig responseChunkConfig;
        ChunkConfig chunkConfig = responseChunkConfig = outboundResponseMsg.getProperty("chunking_config") != null ? (ChunkConfig)((Object)outboundResponseMsg.getProperty("chunking_config")) : null;
        if (responseChunkConfig != null) {
            this.setChunkConfig(responseChunkConfig);
        }
        this.outboundRespStatusFuture = this.outboundResponseListener.getInboundRequestMsg().getHttpOutboundRespStatusFuture();
        String httpVersion = this.outboundResponseListener.getRequestDataHolder().getHttpVersion();
        boolean bl = this.keepAlive = HttpUtil.hasEventStreamContentType(outboundResponseMsg) || this.keepAlive;
        if (Util.isLastHttpContent(httpContent)) {
            if (this.chunkConfig == ChunkConfig.ALWAYS && StateUtil.checkChunkingCompatibility(httpVersion, this.chunkConfig)) {
                this.writeHeaders(outboundResponseMsg, this.keepAlive, this.outboundRespStatusFuture);
                this.writeResponse(outboundResponseMsg, httpContent, true);
                return;
            }
        } else if ((this.chunkConfig == ChunkConfig.ALWAYS || this.chunkConfig == ChunkConfig.AUTO) && StateUtil.checkChunkingCompatibility(httpVersion, this.chunkConfig)) {
            this.writeHeaders(outboundResponseMsg, this.keepAlive, this.outboundRespStatusFuture);
            this.writeResponse(outboundResponseMsg, httpContent, true);
            return;
        }
        this.writeResponse(outboundResponseMsg, httpContent, false);
    }

    private void writeResponse(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, boolean headersWritten) {
        this.listenerReqRespStateManager.state = new SendingEntityBody(this.outboundResponseListener, this.listenerReqRespStateManager, this.outboundRespStatusFuture, headersWritten);
        this.listenerReqRespStateManager.writeOutboundResponseBody(this.outboundResponseListener, outboundResponseMsg, httpContent);
    }

    private void writeHeaders(HttpCarbonMessage outboundResponseMsg, boolean keepAlive, HttpResponseFuture outboundRespStatusFuture) {
        Util.setupChunkedRequest(outboundResponseMsg);
        StateUtil.addTrailerHeaderIfPresent(outboundResponseMsg);
        ChannelFuture outboundHeaderFuture = this.writeResponseHeaders(outboundResponseMsg, keepAlive);
        StateUtil.notifyIfHeaderWriteFailure(outboundRespStatusFuture, outboundHeaderFuture, "Remote client closed the connection before initiating outbound response");
    }

    void setChunkConfig(ChunkConfig chunkConfig) {
        this.chunkConfig = chunkConfig;
    }

    ChannelFuture writeResponseHeaders(HttpCarbonMessage outboundResponseMsg, boolean keepAlive) {
        HttpResponse response = Util.createHttpResponse(outboundResponseMsg, this.outboundResponseListener.getRequestDataHolder().getHttpVersion(), this.outboundResponseListener.getServerName(), keepAlive);
        return this.outboundResponseListener.getSourceContext().write((Object)response);
    }
}

