/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2;

import io.ballerina.stdlib.http.transport.contract.HttpResponseFuture;
import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.contractimpl.Http2OutboundRespListener;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2MessageStateContext;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2StateUtil;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.StateUtil;
import io.ballerina.stdlib.http.transport.contractimpl.listener.http2.Http2SourceHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2.ListenerState;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2.ReceivingEntityBody;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2.SendingEntityBody;
import io.ballerina.stdlib.http.transport.message.Http2DataFrame;
import io.ballerina.stdlib.http.transport.message.Http2HeadersFrame;
import io.ballerina.stdlib.http.transport.message.Http2PushPromise;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingHeaders
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(SendingHeaders.class);
    private final Http2MessageStateContext http2MessageStateContext;
    private final ChannelHandlerContext ctx;
    private final Http2Connection conn;
    private final Http2ConnectionEncoder encoder;
    private final HttpResponseFuture outboundRespStatusFuture;
    private final HttpCarbonMessage inboundRequestMsg;
    private final int originalStreamId;
    private final String serverName;
    private final Http2OutboundRespListener http2OutboundRespListener;

    public SendingHeaders(Http2OutboundRespListener http2OutboundRespListener, Http2MessageStateContext http2MessageStateContext) {
        this.http2OutboundRespListener = http2OutboundRespListener;
        this.http2MessageStateContext = http2MessageStateContext;
        this.ctx = http2OutboundRespListener.getChannelHandlerContext();
        this.conn = http2OutboundRespListener.getConnection();
        this.encoder = http2OutboundRespListener.getEncoder();
        this.outboundRespStatusFuture = http2OutboundRespListener.getOutboundRespStatusFuture();
        this.inboundRequestMsg = http2OutboundRespListener.getInboundRequestMsg();
        this.serverName = http2OutboundRespListener.getServerName();
        this.originalStreamId = http2OutboundRespListener.getOriginalStreamId();
    }

    @Override
    public void readInboundRequestHeaders(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame) {
        LOG.warn("readInboundRequestHeaders is not a dependant action of this state");
    }

    @Override
    public void readInboundRequestBody(Http2SourceHandler http2SourceHandler, Http2DataFrame dataFrame) throws Http2Exception, ServerConnectorException {
        this.http2MessageStateContext.setListenerState(new ReceivingEntityBody(this.http2MessageStateContext));
        this.http2MessageStateContext.getListenerState().readInboundRequestBody(http2SourceHandler, dataFrame);
    }

    @Override
    public void writeOutboundResponseHeaders(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) throws Http2Exception {
        this.writeHeaders(outboundResponseMsg, streamId);
        this.http2MessageStateContext.setListenerState(new SendingEntityBody(http2OutboundRespListener, this.http2MessageStateContext));
        this.http2MessageStateContext.getListenerState().writeOutboundResponseBody(http2OutboundRespListener, outboundResponseMsg, httpContent, streamId);
    }

    @Override
    public void writeOutboundResponseBody(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) throws Http2Exception {
        this.writeOutboundResponseHeaders(http2OutboundRespListener, outboundResponseMsg, httpContent, streamId);
    }

    @Override
    public void writeOutboundPromise(Http2OutboundRespListener http2OutboundRespListener, Http2PushPromise pushPromise) throws Http2Exception {
        LOG.warn("writeOutboundPromise is not a dependant action of this state");
        throw new Http2Exception(Http2Error.PROTOCOL_ERROR, "WriteOutboundPromise is not a dependant action of SendingHeaders state");
    }

    @Override
    public void handleStreamTimeout(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx, Http2OutboundRespListener http2OutboundRespListener, int streamId) {
        try {
            serverConnectorFuture.notifyErrorListener(new ServerConnectorException("Idle timeout triggered while writing outbound response headers"));
            LOG.error("Idle timeout triggered while writing outbound response headers");
        }
        catch (ServerConnectorException e) {
            LOG.error("Error while notifying error state to server-connector listener");
        }
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx, Http2OutboundRespListener http2OutboundRespListener, int streamId) {
        IOException connectionClose = new IOException("Remote client closed the connection while writing outbound response headers");
        http2OutboundRespListener.getOutboundResponseMsg().setIoException(connectionClose);
        this.outboundRespStatusFuture.notifyHttpListener(connectionClose);
        LOG.error("Remote client closed the connection while writing outbound response headers");
    }

    @Override
    public void handleClientGoAway(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext channelHandlerContext, Http2OutboundRespListener http2OutboundRespListener, Integer streamId) {
        IOException connectionClose = new IOException("Remote client closed the connection while writing outbound response headers");
        http2OutboundRespListener.getOutboundResponseMsg().setIoException(connectionClose);
        this.outboundRespStatusFuture.notifyHttpListener(connectionClose);
        LOG.error("Remote client sent GOAWAY while writing outbound response headers");
    }

    private void writeHeaders(HttpCarbonMessage outboundResponseMsg, int streamId) throws Http2Exception {
        outboundResponseMsg.getHeaders().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
        StateUtil.addTrailerHeaderIfPresent(outboundResponseMsg);
        HttpResponse httpMessage = Util.createHttpResponse(outboundResponseMsg, "2.0", this.serverName, true);
        Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers((HttpMessage)httpMessage, (boolean)true);
        Http2StateUtil.validatePromisedStreamState(this.originalStreamId, streamId, this.conn, this.inboundRequestMsg);
        Http2StateUtil.writeHttp2ResponseHeaders(this.ctx, this.encoder, this.outboundRespStatusFuture, streamId, http2Headers, false, this.http2OutboundRespListener, this.inboundRequestMsg);
        this.http2MessageStateContext.setHeadersSent(true);
    }
}

