/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.uri;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class URIUtil {
    public static final String URI_PATH_DELIMITER = "/";
    public static final char DOT_SEGMENT = '.';

    public static String getSubPath(String path, String basePath) {
        if (path.length() == basePath.length()) {
            return URI_PATH_DELIMITER;
        }
        return path.substring(basePath.length());
    }

    public static void populateQueryParamMap(String queryParamString, BMap<BString, Object> queryParamsMap) throws UnsupportedEncodingException {
        HashMap tempParamMap = new HashMap();
        String[] queryParamVals = queryParamString.split("&");
        for (String queryParam : queryParamVals) {
            int index = queryParam.indexOf(61);
            if (index == -1) {
                if (tempParamMap.containsKey(queryParam)) continue;
                tempParamMap.put(queryParam, null);
                continue;
            }
            String queryParamName = queryParam.substring(0, index).trim();
            String queryParamValue = queryParam.substring(index + 1).trim();
            ArrayList<String> values = new ArrayList<String>();
            HashSet<String> uniqueValues = new HashSet<String>();
            for (String val : queryParamValue.split(",")) {
                String decodedValue = URLDecoder.decode(val, StandardCharsets.UTF_8);
                if (!uniqueValues.add(decodedValue)) continue;
                values.add(decodedValue);
            }
            if (tempParamMap.containsKey(queryParamName) && tempParamMap.get(queryParamName) != null) {
                ((List)tempParamMap.get(queryParamName)).addAll(values);
                continue;
            }
            tempParamMap.put(queryParamName, values);
        }
        for (Map.Entry entry : tempParamMap.entrySet()) {
            List entryValue = (List)entry.getValue();
            if (entryValue != null) {
                queryParamsMap.put((Object)StringUtils.fromString((String)((String)entry.getKey())), (Object)StringUtils.fromStringArray((String[])entryValue.toArray(new String[0])));
                continue;
            }
            queryParamsMap.put((Object)StringUtils.fromString((String)((String)entry.getKey())), null);
        }
    }

    public static BMap<BString, Object> getMatrixParamsMap(String path, HttpCarbonMessage carbonMessage) {
        BMap matrixParamsBMap = ValueCreator.createMapValue();
        Map pathToMatrixParamMap = (Map)carbonMessage.getProperty("MATRIX_PARAMS");
        Map matrixParamsMap = (Map)pathToMatrixParamMap.get(path);
        if (matrixParamsMap != null) {
            for (Map.Entry matrixParamEntry : matrixParamsMap.entrySet()) {
                matrixParamsBMap.put((Object)StringUtils.fromString((String)((String)matrixParamEntry.getKey())), (Object)StringUtils.fromString((String)((String)matrixParamEntry.getValue())));
            }
        }
        return matrixParamsBMap;
    }

    public static String extractMatrixParams(String path, Map<String, Map<String, String>> matrixParams, HttpCarbonMessage inboundReqMsg) {
        if (path.startsWith(URI_PATH_DELIMITER)) {
            path = path.substring(1);
        }
        String[] pathSplits = path.split("\\?");
        String[] pathSegments = pathSplits[0].split(URI_PATH_DELIMITER);
        String pathToMatrixParam = "";
        for (String pathSegment : pathSegments) {
            String[] splitPathSegment = pathSegment.split(";");
            pathToMatrixParam = pathToMatrixParam.concat(URI_PATH_DELIMITER + splitPathSegment[0]);
            HashMap<String, String> segmentMatrixParams = new HashMap<String, String>();
            for (int i = 1; i < splitPathSegment.length; ++i) {
                String[] splitMatrixParam = splitPathSegment[i].split("=");
                if (splitMatrixParam.length != 2) {
                    String message = String.format("found non-matrix parameter '%s' in path '%s'", splitPathSegment[i], path);
                    throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_BAD_MATRIX_PARAMS_ERROR, message);
                }
                segmentMatrixParams.put(splitMatrixParam[0], splitMatrixParam[1]);
            }
            matrixParams.put(pathToMatrixParam, segmentMatrixParams);
        }
        for (int i = 1; i < pathSplits.length; ++i) {
            pathToMatrixParam = pathToMatrixParam.concat("?").concat(pathSplits[i]);
        }
        return pathToMatrixParam;
    }

    private URIUtil() {
    }
}

