/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mime.util;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.XmlUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStreamingJson;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.stdlib.mime.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.mime.util.EntityHeaderHandler;
import io.ballerina.stdlib.mime.util.HeaderUtil;
import io.ballerina.stdlib.mime.util.MimeConstants;
import jakarta.activation.MimeType;
import jakarta.activation.MimeTypeParameterList;
import jakarta.activation.MimeTypeParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MimeUtil.class);
    public static final String EMPTY_JSON_DOCUMENT = "empty JSON document";
    public static final String EMPTY_XML_PAYLOAD = "Empty xml payload";
    public static final String UNEXPECTED_EOF_IN_PROLOG = "Unexpected EOF in prolog";

    public static String getBaseType(BObject entity) {
        BObject mediaType;
        if (entity.get(MimeConstants.MEDIA_TYPE_FIELD) != null && (mediaType = (BObject)entity.get(MimeConstants.MEDIA_TYPE_FIELD)) != null) {
            return mediaType.get(MimeConstants.PRIMARY_TYPE_FIELD).toString() + "/" + mediaType.get(MimeConstants.SUBTYPE_FIELD).toString();
        }
        return null;
    }

    public static String getContentTypeWithParameters(BObject entity) {
        if (entity.get(MimeConstants.MEDIA_TYPE_FIELD) == null) {
            return EntityHeaderHandler.getHeaderValue(entity, "content-type");
        }
        BObject mediaType = (BObject)entity.get(MimeConstants.MEDIA_TYPE_FIELD);
        String primaryType = String.valueOf(mediaType.get(MimeConstants.PRIMARY_TYPE_FIELD));
        String subType = String.valueOf(mediaType.get(MimeConstants.SUBTYPE_FIELD));
        String contentType = null;
        if (!primaryType.isEmpty() && !subType.isEmpty()) {
            contentType = primaryType + "/" + subType;
            if (mediaType.get(MimeConstants.PARAMETER_MAP_FIELD) != null) {
                BMap map;
                BMap bMap = map = mediaType.get(MimeConstants.PARAMETER_MAP_FIELD) != null ? (BMap)mediaType.get(MimeConstants.PARAMETER_MAP_FIELD) : null;
                if (map != null && !map.isEmpty()) {
                    contentType = contentType + ";";
                    return HeaderUtil.appendHeaderParams(new StringBuilder(contentType), (BMap<BString, Object>)map);
                }
            }
        }
        return contentType;
    }

    public static String getContentTypeParamValue(String contentType, String parameterName) {
        try {
            MimeType mimeType = new MimeType(contentType);
            MimeTypeParameterList parameterList = mimeType.getParameters();
            return parameterList.get(parameterName);
        }
        catch (MimeTypeParseException e) {
            throw MimeUtil.createError("InvalidContentTypeError", e.getMessage());
        }
    }

    public static void setContentType(BObject mediaType, BObject entityStruct, String contentType) {
        BObject mimeType = MimeUtil.parseMediaType(mediaType, contentType);
        if (contentType == null) {
            mimeType.set(MimeConstants.PRIMARY_TYPE_FIELD, (Object)MimeConstants.DEFAULT_PRIMARY_TYPE);
            mimeType.set(MimeConstants.SUBTYPE_FIELD, (Object)MimeConstants.DEFAULT_SUB_TYPE);
        }
        entityStruct.set(MimeConstants.MEDIA_TYPE_FIELD, (Object)mimeType);
    }

    public static BObject parseMediaType(BObject mediaType, String contentType) {
        try {
            BString suffix;
            BString subType;
            BString primaryType;
            BMap parameterMap = ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_STRING));
            if (contentType != null) {
                MimeType mimeType = new MimeType(contentType);
                primaryType = StringUtils.fromString((String)mimeType.getPrimaryType());
                String subTypeStr = mimeType.getSubType();
                subType = StringUtils.fromString((String)subTypeStr);
                suffix = subTypeStr != null && subTypeStr.contains("+") ? StringUtils.fromString((String)subTypeStr.substring(subTypeStr.lastIndexOf("+") + 1)) : (BString)PredefinedTypes.TYPE_STRING.getZeroValue();
                MimeTypeParameterList parameterList = mimeType.getParameters();
                Enumeration keys = parameterList.getNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    BString value = StringUtils.fromString((String)parameterList.get(key));
                    parameterMap.put((Object)StringUtils.fromString((String)key), (Object)value);
                }
            } else {
                suffix = subType = (BString)PredefinedTypes.TYPE_STRING.getZeroValue();
                primaryType = subType;
            }
            mediaType.set(MimeConstants.PRIMARY_TYPE_FIELD, (Object)primaryType);
            mediaType.set(MimeConstants.SUBTYPE_FIELD, (Object)subType);
            mediaType.set(MimeConstants.SUFFIX_FIELD, (Object)suffix);
            mediaType.set(MimeConstants.PARAMETER_MAP_FIELD, (Object)parameterMap);
        }
        catch (MimeTypeParseException e) {
            throw MimeUtil.createError("InvalidContentTypeError", e.getMessage());
        }
        return mediaType;
    }

    public static void setMediaTypeToEntity(BObject entityStruct, String contentType) {
        BObject mediaType = ValueCreator.createObjectValue((Module)MimeUtil.getMimePackage(), (String)"MediaType", (Object[])new Object[0]);
        MimeUtil.setContentType(mediaType, entityStruct, contentType);
        HeaderUtil.setHeaderToEntity(entityStruct, "content-type", contentType);
    }

    public static void setContentDisposition(BObject contentDisposition, BObject bodyPart, String contentDispositionHeaderWithParams) {
        MimeUtil.populateContentDispositionObject(contentDisposition, contentDispositionHeaderWithParams);
        bodyPart.set(MimeConstants.CONTENT_DISPOSITION_FIELD, (Object)contentDisposition);
    }

    public static void populateContentDispositionObject(BObject contentDisposition, String contentDispositionHeaderWithParams) {
        if (MimeUtil.isNotNullAndEmpty(contentDispositionHeaderWithParams)) {
            String dispositionValue = contentDispositionHeaderWithParams.contains(";") ? HeaderUtil.getHeaderValue(contentDispositionHeaderWithParams) : contentDispositionHeaderWithParams;
            contentDisposition.set(MimeConstants.DISPOSITION_FIELD, (Object)StringUtils.fromString((String)dispositionValue));
            BMap<BString, Object> paramMap = HeaderUtil.getParamMap(contentDispositionHeaderWithParams);
            block8: for (BString key : (BString[])paramMap.getKeys()) {
                BString paramValue = (BString)paramMap.get((Object)key);
                switch (key.getValue()) {
                    case "filename": {
                        contentDisposition.set(MimeConstants.CONTENT_DISPOSITION_FILENAME_FIELD, (Object)MimeUtil.stripQuotes(paramValue));
                        continue block8;
                    }
                    case "name": {
                        contentDisposition.set(MimeConstants.CONTENT_DISPOSITION_NAME_FIELD, (Object)MimeUtil.stripQuotes(paramValue));
                        continue block8;
                    }
                }
            }
            paramMap.remove((Object)StringUtils.fromString((String)"filename"));
            paramMap.remove((Object)StringUtils.fromString((String)"name"));
            contentDisposition.set(MimeConstants.CONTENT_DISPOSITION_PARA_MAP_FIELD, paramMap);
        }
    }

    public static String getContentDisposition(BObject entity) {
        BObject contentDispositionStruct;
        StringBuilder dispositionBuilder = new StringBuilder();
        if (entity.get(MimeConstants.CONTENT_DISPOSITION_FIELD) != null && (contentDispositionStruct = (BObject)entity.get(MimeConstants.CONTENT_DISPOSITION_FIELD)) != null) {
            Object disposition = contentDispositionStruct.get(MimeConstants.DISPOSITION_FIELD);
            if (disposition == null || disposition.toString().isEmpty()) {
                String contentType = MimeUtil.getBaseType(entity);
                if (contentType != null && contentType.equals("multipart/form-data")) {
                    dispositionBuilder.append("form-data");
                }
            } else {
                dispositionBuilder.append(disposition);
            }
            if (!dispositionBuilder.toString().isEmpty()) {
                dispositionBuilder = MimeUtil.convertDispositionObjectToString(dispositionBuilder, contentDispositionStruct);
            }
        }
        return dispositionBuilder.toString();
    }

    public static StringBuilder convertDispositionObjectToString(StringBuilder dispositionBuilder, BObject contentDispositionStruct) {
        String fileName;
        Object nameBVal = contentDispositionStruct.get(MimeConstants.CONTENT_DISPOSITION_NAME_FIELD);
        String name = nameBVal != null ? nameBVal.toString() : null;
        Object fileNameBVal = contentDispositionStruct.get(MimeConstants.CONTENT_DISPOSITION_FILENAME_FIELD);
        String string = fileName = fileNameBVal != null ? fileNameBVal.toString() : null;
        if (MimeUtil.isNotNullAndEmpty(name)) {
            MimeUtil.appendSemiColon(dispositionBuilder).append("name").append("=").append(MimeUtil.includeQuotes(name)).append(";");
        }
        if (MimeUtil.isNotNullAndEmpty(fileName)) {
            MimeUtil.appendSemiColon(dispositionBuilder).append("filename").append("=").append(MimeUtil.includeQuotes(fileName)).append(";");
        }
        if (contentDispositionStruct.get(MimeConstants.CONTENT_DISPOSITION_PARA_MAP_FIELD) != null) {
            BMap map = (BMap)contentDispositionStruct.get(MimeConstants.CONTENT_DISPOSITION_PARA_MAP_FIELD);
            HeaderUtil.appendHeaderParams(MimeUtil.appendSemiColon(dispositionBuilder), (BMap<BString, Object>)map);
        }
        if (dispositionBuilder.toString().endsWith(";")) {
            dispositionBuilder.setLength(dispositionBuilder.length() - 1);
        }
        return dispositionBuilder;
    }

    private static StringBuilder appendSemiColon(StringBuilder disposition) {
        if (!disposition.toString().endsWith(";")) {
            disposition.append(";");
        }
        return disposition;
    }

    public static void setContentLength(BObject entityStruct, long length) {
        entityStruct.set(MimeConstants.SIZE_FIELD, (Object)length);
    }

    public static void writeInputToOutputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        while ((len = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
    }

    public static byte[] getByteArray(InputStream input) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = input.read(buffer)) != -1) {
                output.write(buffer, 0, len);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static boolean isNotNullAndEmpty(String textValue) {
        return textValue != null && !textValue.isEmpty();
    }

    public static String includeQuotes(String textValue) {
        if (!((String)textValue).startsWith("\"")) {
            textValue = "\"" + (String)textValue;
        }
        if (!((String)textValue).endsWith("\"")) {
            textValue = (String)textValue + "\"";
        }
        return textValue;
    }

    public static BString stripQuotes(BString textValue) {
        if (textValue.getValue().startsWith("\"")) {
            textValue = textValue.substring(1, textValue.length());
        }
        if (textValue.getValue().endsWith("\"")) {
            textValue = textValue.substring(0, textValue.length() - 1);
        }
        return textValue;
    }

    public static String getNewMultipartDelimiter() {
        Random random = new Random();
        return Long.toHexString(random.nextLong());
    }

    static boolean isNestedPartsAvailable(BObject bodyPart) {
        String contentTypeOfChildPart = MimeUtil.getBaseType(bodyPart);
        return contentTypeOfChildPart != null && contentTypeOfChildPart.startsWith("multipart/") && bodyPart.getNativeData("body_parts") != null;
    }

    public static BError createError(String errorTypeName, String errMsg) {
        return ErrorCreator.createError((Module)MimeUtil.getMimePackage(), (String)errorTypeName, (BString)StringUtils.fromString((String)errMsg), null, null);
    }

    public static BError createError(String errorTypeName, String errMsg, BError errorValue) {
        return ErrorCreator.createError((Module)MimeUtil.getMimePackage(), (String)errorTypeName, (BString)StringUtils.fromString((String)errMsg), (BError)errorValue, null);
    }

    public static boolean isJSONCompatible(Type type) {
        switch (type.getTag()) {
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 15: {
                return true;
            }
            case 32: {
                return MimeUtil.isJSONCompatible(((ArrayType)type).getElementType());
            }
            case 27: {
                return MimeUtil.isJSONCompatible(((MapType)type).getConstrainedType());
            }
        }
        return false;
    }

    public static String getMessageAsString(Object dataSource) {
        Type type = TypeUtils.getType((Object)dataSource);
        if (type.getTag() == 5) {
            if (dataSource instanceof BString) {
                return ((BString)dataSource).getValue();
            }
            return (String)dataSource;
        }
        if (type.getTag() == 32 && ((ArrayType)type).getElementType().getTag() == 2) {
            return new String(((BArray)dataSource).getBytes(), StandardCharsets.UTF_8);
        }
        return StringUtils.getJsonString((Object)dataSource);
    }

    public static boolean generateAsJSON(Object value, BObject entity) {
        if (value instanceof BStreamingJson) {
            return false;
        }
        return MimeUtil.parseAsJson(entity) && MimeUtil.isJSONCompatible(TypeUtils.getType((Object)value));
    }

    private static boolean parseAsJson(BObject entity) {
        Object parseAsJson = entity.getNativeData("PARSE_AS_TEXT");
        return parseAsJson != null && (Boolean)entity.getNativeData("PARSE_AS_TEXT") != false;
    }

    public static Object parseAsJson(InputStream inputStream) {
        return MimeUtil.parseAsJson(inputStream, Charset.defaultCharset().name());
    }

    public static Object parseAsJson(InputStream inputStream, String charset) {
        try {
            return JsonUtils.parse((InputStream)inputStream, (String)charset);
        }
        catch (BError parserError) {
            MimeUtil.handleJsonParseError(parserError);
            throw parserError;
        }
    }

    public static Object parseAsJson(String jsonString) {
        try {
            return JsonUtils.parse((String)jsonString);
        }
        catch (BError parserError) {
            MimeUtil.handleJsonParseError(parserError);
            throw parserError;
        }
    }

    public static BXml parseAsXml(InputStream inputStream) {
        return MimeUtil.parseAsXml(inputStream, Charset.defaultCharset().name());
    }

    public static BXml parseAsXml(InputStream inputStream, String charsetValue) {
        try {
            return XmlUtils.parse((InputStream)inputStream, (String)charsetValue);
        }
        catch (BError parserError) {
            MimeUtil.handleXmlParseError(parserError);
            throw parserError;
        }
    }

    public static BXml parseAsXml(String xmlString) {
        try {
            return XmlUtils.parse((String)xmlString);
        }
        catch (BError parserError) {
            MimeUtil.handleXmlParseError(parserError);
            throw parserError;
        }
    }

    private static void handleJsonParseError(BError parserError) {
        String errorMsg = parserError.getMessage();
        if (errorMsg != null && errorMsg.startsWith(EMPTY_JSON_DOCUMENT)) {
            throw MimeUtil.createError("NoContentError", EMPTY_JSON_DOCUMENT, parserError);
        }
    }

    private static void handleXmlParseError(BError parserError) {
        String errorMsg = parserError.getMessage();
        if (errorMsg != null && errorMsg.contains(UNEXPECTED_EOF_IN_PROLOG)) {
            throw MimeUtil.createError("NoContentError", EMPTY_XML_PAYLOAD, parserError);
        }
    }

    public static boolean isValidateContentType(String contentType) {
        try {
            new MimeType(contentType);
        }
        catch (MimeTypeParseException e) {
            return false;
        }
        return true;
    }

    public static void closeOutputStream(OutputStream outputStream) throws IOException {
        if (outputStream != null) {
            outputStream.close();
        }
    }

    public static Module getMimePackage() {
        return ModuleUtils.getModule();
    }

    private MimeUtil() {
    }

    public static String removeJavaExceptionPrefix(String errorMessage) {
        String prefixRegex = "^(?:[a-z]+\\.)+[A-Za-z]+Exception:";
        Pattern pattern = Pattern.compile(prefixRegex);
        Matcher matcher = pattern.matcher(errorMessage);
        return matcher.find() ? matcher.replaceFirst("").trim() : errorMessage;
    }
}

