/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mime.util;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.mime.util.EntityBodyHandler;
import io.ballerina.stdlib.mime.util.EntityHeaderHandler;
import io.ballerina.stdlib.mime.util.HeaderUtil;
import io.ballerina.stdlib.mime.util.MimeConstants;
import io.ballerina.stdlib.mime.util.MimeUtil;
import jakarta.activation.MimeType;
import jakarta.activation.MimeTypeParseException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.mimepull.MIMEConfig;
import org.jvnet.mimepull.MIMEMessage;
import org.jvnet.mimepull.MIMEPart;

public class MultipartDecoder {
    public static void parseBody(BObject entity, String contentType, InputStream inputStream) {
        try {
            List<MIMEPart> mimeParts = MultipartDecoder.decodeBodyParts(contentType, inputStream);
            if (mimeParts != null && !mimeParts.isEmpty()) {
                MultipartDecoder.populateBallerinaParts(entity, mimeParts);
            }
        }
        catch (MimeTypeParseException e) {
            throw MimeUtil.createError("ParserError", "Error occurred while decoding body parts from inputstream " + e.getMessage());
        }
    }

    public static List<MIMEPart> decodeBodyParts(String contentType, InputStream inputStream) throws MimeTypeParseException {
        MimeType mimeType = new MimeType(contentType);
        MIMEMessage mimeMessage = new MIMEMessage(inputStream, mimeType.getParameter("boundary"), MultipartDecoder.getMimeConfig());
        return mimeMessage.getAttachments();
    }

    private static MIMEConfig getMimeConfig() {
        MIMEConfig mimeConfig = new MIMEConfig();
        mimeConfig.setMemoryThreshold(MultipartDecoder.getMemoryThreshold().longValue());
        return mimeConfig;
    }

    private static Long getMemoryThreshold() {
        Long freeMemorySize = Runtime.getRuntime().freeMemory();
        Double maxThreshold = (double)freeMemorySize.longValue() * 0.1;
        return maxThreshold.longValue();
    }

    private static void populateBallerinaParts(BObject entity, List<MIMEPart> mimeParts) {
        ArrayList<BObject> bodyParts = new ArrayList<BObject>();
        for (MIMEPart mimePart : mimeParts) {
            BObject partStruct = ValueCreator.createObjectValue((Module)MimeUtil.getMimePackage(), (String)"Entity", (Object[])new Object[0]);
            BObject mediaType = ValueCreator.createObjectValue((Module)MimeUtil.getMimePackage(), (String)"MediaType", (Object[])new Object[0]);
            MultipartDecoder.populateBodyPart(mimePart, partStruct, mediaType);
            bodyParts.add(partStruct);
        }
        EntityBodyHandler.setPartsToTopLevelEntity(entity, bodyParts);
    }

    private static void populateBodyPart(MIMEPart mimePart, BObject partStruct, BObject mediaType) {
        EntityHeaderHandler.populateBodyPartHeaders(partStruct, mimePart.getAllHeaders());
        MultipartDecoder.populateContentLength(mimePart, partStruct);
        MultipartDecoder.populateContentId(mimePart, partStruct);
        MultipartDecoder.populateContentType(mimePart, partStruct, mediaType);
        List contentDispositionHeaders = mimePart.getHeader("content-disposition");
        if (HeaderUtil.isHeaderExist(contentDispositionHeaders)) {
            BObject contentDisposition = ValueCreator.createObjectValue((Module)MimeUtil.getMimePackage(), (String)"ContentDisposition", (Object[])new Object[0]);
            MultipartDecoder.populateContentDisposition(partStruct, contentDispositionHeaders, contentDisposition);
        }
        EntityBodyHandler.populateBodyContent(partStruct, mimePart);
    }

    private static void populateContentDisposition(BObject partStruct, List<String> contentDispositionHeaders, BObject contentDisposition) {
        MimeUtil.setContentDisposition(contentDisposition, partStruct, contentDispositionHeaders.get(0));
    }

    private static void populateContentType(MIMEPart mimePart, BObject partStruct, BObject mediaType) {
        MimeUtil.setContentType(mediaType, partStruct, mimePart.getContentType());
    }

    private static void populateContentId(MIMEPart mimePart, BObject partStruct) {
        partStruct.set(MimeConstants.CONTENT_ID_FIELD, (Object)StringUtils.fromString((String)mimePart.getContentId()));
    }

    private static void populateContentLength(MIMEPart mimePart, BObject partStruct) {
        List lengthHeaders = mimePart.getHeader("content-length");
        if (HeaderUtil.isHeaderExist(lengthHeaders)) {
            MimeUtil.setContentLength(partStruct, Integer.parseInt((String)lengthHeaders.get(0)));
        } else {
            MimeUtil.setContentLength(partStruct, -1L);
        }
    }

    private MultipartDecoder() {
    }
}

