/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.csvdata;

import io.ballerina.lib.data.csvdata.utils.CsvConfig;
import io.ballerina.lib.data.csvdata.utils.CsvUtils;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.FiniteType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.WeakHashMap;

public final class FromString {
    private static WeakHashMap<String, LocaleInfo> localeAttributes = new WeakHashMap();
    private static final List<Integer> TYPE_PRIORITY_ORDER = List.of(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(14), Integer.valueOf(6), Integer.valueOf(15), Integer.valueOf(5));
    private static final List<Type> BASIC_JSON_MEMBER_TYPES = List.of(PredefinedTypes.TYPE_NULL, PredefinedTypes.TYPE_BOOLEAN, PredefinedTypes.TYPE_INT, PredefinedTypes.TYPE_FLOAT, PredefinedTypes.TYPE_DECIMAL, PredefinedTypes.TYPE_STRING);
    private static final UnionType JSON_TYPE_WITH_BASIC_TYPES = TypeCreator.createUnionType(BASIC_JSON_MEMBER_TYPES);
    public static final Integer BBYTE_MIN_VALUE = 0;
    public static final Integer BBYTE_MAX_VALUE = 255;
    public static final Integer SIGNED32_MAX_VALUE = Integer.MAX_VALUE;
    public static final Integer SIGNED32_MIN_VALUE = Integer.MIN_VALUE;
    public static final Integer SIGNED16_MAX_VALUE = Short.MAX_VALUE;
    public static final Integer SIGNED16_MIN_VALUE = Short.MIN_VALUE;
    public static final Integer SIGNED8_MAX_VALUE = 127;
    public static final Integer SIGNED8_MIN_VALUE = -128;
    public static final Long UNSIGNED32_MAX_VALUE = 0xFFFFFFFFL;
    public static final Integer UNSIGNED16_MAX_VALUE = 65535;
    public static final Integer UNSIGNED8_MAX_VALUE = 255;

    private FromString() {
    }

    public static Object fromStringWithType(BString string, Type expType, CsvConfig config) {
        String value = string.getValue();
        try {
            return switch (expType.getTag()) {
                case 1 -> FromString.stringToInt(value, config);
                case 2 -> Integer.valueOf(FromString.stringToByte(value, config));
                case 7 -> Long.valueOf(FromString.stringToSigned8Int(value, config));
                case 9 -> Long.valueOf(FromString.stringToSigned16Int(value, config));
                case 11 -> Long.valueOf(FromString.stringToSigned32Int(value, config));
                case 8 -> Long.valueOf(FromString.stringToUnsigned8Int(value, config));
                case 10 -> Long.valueOf(FromString.stringToUnsigned16Int(value, config));
                case 12 -> Long.valueOf(FromString.stringToUnsigned32Int(value, config));
                case 3 -> FromString.stringToFloat(value, config);
                case 4 -> FromString.stringToDecimal(value, config);
                case 13 -> FromString.stringToChar(value);
                case 5 -> string;
                case 6 -> FromString.stringToBoolean(value);
                case 14 -> FromString.stringToNull(value, config);
                case 46 -> FromString.stringToFiniteType(value, (FiniteType)expType, config);
                case 33 -> FromString.stringToUnion(string, (UnionType)expType, config, false);
                case 15, 23 -> FromString.stringToUnion(string, JSON_TYPE_WITH_BASIC_TYPES, config, true);
                case 53 -> FromString.fromStringWithType(string, ((ReferenceType)expType).getReferredType(), config);
                case 34 -> FromString.fromStringWithType(string, ((IntersectionType)expType).getEffectiveType(), config);
                default -> FromString.returnError(value, expType.toString());
            };
        }
        catch (RuntimeException | ParseException e) {
            return FromString.returnError(value, expType.toString());
        }
    }

    private static Object stringToFiniteType(String value, FiniteType finiteType, CsvConfig config) {
        return finiteType.getValueSpace().stream().filter(finiteValue -> !(FromString.convertToSingletonValue(value, finiteValue, config) instanceof BError)).findFirst().orElseGet(() -> FromString.returnError(value, finiteType.toString()));
    }

    private static Object convertToSingletonValue(String str, Object singletonValue, CsvConfig config) {
        String singletonStr = String.valueOf(singletonValue);
        if (str.equals(singletonStr)) {
            return FromString.fromStringWithType(StringUtils.fromString((String)str), TypeUtils.getType((Object)singletonValue), config);
        }
        return FromString.returnError(str, singletonStr);
    }

    private static Long stringToInt(String value, CsvConfig config) throws NumberFormatException, ParseException {
        Number number = FromString.parseNumberValue(value, config);
        if (FromString.isIntegerValue(value, number, config.locale)) {
            return number.longValue();
        }
        throw new NumberFormatException();
    }

    private static int stringToByte(String value, CsvConfig config) throws NumberFormatException, ParseException {
        int intValue;
        Number number = FromString.parseNumberValue(value, config);
        if (FromString.isIntegerValue(value, number, config.locale) && FromString.isByteLiteral(intValue = number.intValue())) {
            return intValue;
        }
        throw new NumberFormatException();
    }

    private static long stringToSigned8Int(String value, CsvConfig config) throws NumberFormatException, ParseException {
        long intValue;
        Number number = FromString.parseNumberValue(value, config);
        if (FromString.isIntegerValue(value, number, config.locale) && FromString.isSigned8LiteralValue(intValue = number.longValue())) {
            return intValue;
        }
        throw new NumberFormatException();
    }

    private static long stringToSigned16Int(String value, CsvConfig config) throws NumberFormatException, ParseException {
        long intValue;
        Number number = FromString.parseNumberValue(value, config);
        if (FromString.isIntegerValue(value, number, config.locale) && FromString.isSigned16LiteralValue(intValue = number.longValue())) {
            return intValue;
        }
        throw new NumberFormatException();
    }

    private static long stringToSigned32Int(String value, CsvConfig config) throws NumberFormatException, ParseException {
        long intValue;
        Number number = FromString.parseNumberValue(value, config);
        if (FromString.isIntegerValue(value, number, config.locale) && FromString.isSigned32LiteralValue(intValue = number.longValue())) {
            return intValue;
        }
        throw new NumberFormatException();
    }

    private static long stringToUnsigned8Int(String value, CsvConfig config) throws NumberFormatException, ParseException {
        long intValue;
        Number number = FromString.parseNumberValue(value, config);
        if (FromString.isIntegerValue(value, number, config.locale) && FromString.isUnsigned8LiteralValue(intValue = number.longValue())) {
            return intValue;
        }
        throw new NumberFormatException();
    }

    private static long stringToUnsigned16Int(String value, CsvConfig config) throws NumberFormatException, ParseException {
        long intValue;
        Number number = FromString.parseNumberValue(value, config);
        if (FromString.isIntegerValue(value, number, config.locale) && FromString.isUnsigned16LiteralValue(intValue = number.longValue())) {
            return intValue;
        }
        throw new NumberFormatException();
    }

    private static long stringToUnsigned32Int(String value, CsvConfig config) throws NumberFormatException, ParseException {
        long intValue;
        Number number = FromString.parseNumberValue(value, config);
        if (FromString.isIntegerValue(value, number, config.locale) && FromString.isUnsigned32LiteralValue(intValue = number.longValue())) {
            return intValue;
        }
        throw new NumberFormatException();
    }

    private static BString stringToChar(String value) throws RuntimeException {
        if (FromString.isCharLiteralValue(value)) {
            return StringUtils.fromString((String)value);
        }
        throw new RuntimeException();
    }

    private static Double stringToFloat(String value, CsvConfig config) throws NumberFormatException, ParseException {
        Number number = FromString.parseNumberValue(value, config);
        if (FromString.isDoubleValue(value, number, config.locale)) {
            return number.doubleValue();
        }
        throw new NumberFormatException();
    }

    private static BDecimal stringToDecimal(String value, CsvConfig config) throws NumberFormatException, ParseException {
        Number number = FromString.parseNumberValue(value, config);
        if (FromString.isDoubleValue(value, number, config.locale)) {
            BigDecimal decimalValue = BigDecimal.valueOf(number.doubleValue());
            return ValueCreator.createDecimalValue((BigDecimal)decimalValue);
        }
        throw new NumberFormatException();
    }

    private static Object stringToBoolean(String value) throws NumberFormatException {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        return FromString.returnError(value, "boolean");
    }

    private static Object stringToNull(String value, CsvConfig config) throws NumberFormatException {
        Object nullValue = config.nilValue;
        if (CsvUtils.isNullValue(nullValue, value)) {
            return null;
        }
        return FromString.returnError(value, nullValue == null ? "()" : nullValue.toString());
    }

    private static Object stringToUnion(BString string, UnionType expType, CsvConfig config, boolean isJsonOrAnydata) throws NumberFormatException {
        ArrayList<Type> memberTypes = new ArrayList<Type>(expType.getMemberTypes());
        if (isJsonOrAnydata) {
            memberTypes.sort(Comparator.comparingInt(t -> {
                int index = TYPE_PRIORITY_ORDER.indexOf(TypeUtils.getReferredType((Type)t).getTag());
                return index == -1 ? Integer.MAX_VALUE : index;
            }));
        } else {
            memberTypes.sort(Comparator.comparingInt(t -> {
                int tag = TypeUtils.getReferredType((Type)t).getTag();
                return tag == 14 ? Integer.MIN_VALUE : memberTypes.indexOf(t);
            }));
        }
        for (Type memberType : memberTypes) {
            try {
                Object result = FromString.fromStringWithType(string, memberType, config);
                if (result instanceof BError) continue;
                return result;
            }
            catch (Exception exception) {
            }
        }
        return FromString.returnError(string.getValue(), expType.toString());
    }

    private static boolean isByteLiteral(long longValue) {
        return longValue >= (long)BBYTE_MIN_VALUE.intValue() && longValue <= (long)BBYTE_MAX_VALUE.intValue();
    }

    private static boolean isSigned32LiteralValue(Long longObject) {
        return longObject >= (long)SIGNED32_MIN_VALUE.intValue() && longObject <= (long)SIGNED32_MAX_VALUE.intValue();
    }

    private static boolean isSigned16LiteralValue(Long longObject) {
        return longObject.intValue() >= SIGNED16_MIN_VALUE && longObject.intValue() <= SIGNED16_MAX_VALUE;
    }

    private static boolean isSigned8LiteralValue(Long longObject) {
        return longObject.intValue() >= SIGNED8_MIN_VALUE && longObject.intValue() <= SIGNED8_MAX_VALUE;
    }

    private static boolean isUnsigned32LiteralValue(Long longObject) {
        return longObject >= 0L && longObject <= UNSIGNED32_MAX_VALUE;
    }

    private static boolean isUnsigned16LiteralValue(Long longObject) {
        return longObject.intValue() >= 0 && longObject.intValue() <= UNSIGNED16_MAX_VALUE;
    }

    private static boolean isUnsigned8LiteralValue(Long longObject) {
        return longObject.intValue() >= 0 && longObject.intValue() <= UNSIGNED8_MAX_VALUE;
    }

    private static boolean isCharLiteralValue(String value) {
        return value.codePoints().count() == 1L;
    }

    private static boolean isIntegerValue(String value, Number number, String localeStr) {
        return FromString.isNumericType(number) && value.matches(FromString.getLocale(localeStr).intRegex());
    }

    private static boolean isDoubleValue(String value, Number number, String localeStr) {
        return (number instanceof Double || FromString.isNumericType(number)) && value.matches(FromString.getLocale(localeStr).doubleRegex());
    }

    private static BError returnError(String value, String expType) {
        return ErrorCreator.createError((BString)StringUtils.fromString((String)("Cannot convert " + value + " to the expected type: " + expType)));
    }

    private static Number parseNumberValue(String numberString, CsvConfig config) throws ParseException {
        NumberFormat numberFormat = NumberFormat.getInstance(FromString.getLocale(config.locale).locale());
        return numberFormat.parse(numberString);
    }

    private static LocaleInfo getLocale(String localeStr) {
        if (!localeAttributes.containsKey(localeStr)) {
            localeAttributes.put(localeStr, FromString.computeLocaleIfAbsent(localeStr));
        }
        return localeAttributes.get(localeStr);
    }

    private static LocaleInfo computeLocaleIfAbsent(String localeStr) {
        Locale locale = CsvUtils.createLocaleFromString(localeStr);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(locale);
        char decimalSeparator = dfs.getDecimalSeparator();
        char minusSign = dfs.getMinusSign();
        char zeroDigit = dfs.getZeroDigit();
        String numRange = "[" + zeroDigit + "-9]";
        String exponentSeparator = dfs.getExponentSeparator();
        String intRegex = "^[" + minusSign + "+]?" + numRange + "+$";
        String doubleRegex = "^[" + minusSign + "+]?" + numRange + "+(" + String.valueOf(decimalSeparator == '.' ? "\\." : Character.valueOf(decimalSeparator)) + numRange + "*)?(" + exponentSeparator + "[+-]?" + numRange + "+)?$";
        return new LocaleInfo(locale, intRegex, doubleRegex);
    }

    private static boolean isNumericType(Object value) {
        return value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte;
    }

    private record LocaleInfo(Locale locale, String intRegex, String doubleRegex) {
    }
}

