/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.csvdata.csv;

import io.ballerina.lib.data.csvdata.csv.CsvCreator;
import io.ballerina.lib.data.csvdata.utils.CsvConfig;
import io.ballerina.lib.data.csvdata.utils.CsvUtils;
import io.ballerina.lib.data.csvdata.utils.DataUtils;
import io.ballerina.lib.data.csvdata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.csvdata.utils.DiagnosticLog;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class CsvTraversal {
    private static final ThreadLocal<CsvTree> tlCsvTree = ThreadLocal.withInitial(CsvTree::new);

    private CsvTraversal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object traverse(BArray csv, CsvConfig config, BTypedesc type) {
        CsvTree csvTree = tlCsvTree.get();
        try {
            CsvUtils.validateConfigs(config);
            Object convertedValue = csvTree.traverseCsv(csv, config, type.getDescribingType());
            Object object = DataUtils.validateConstraints(convertedValue, type, config.enableConstraintValidation);
            return object;
        }
        catch (BError e) {
            BError bError = e;
            return bError;
        }
        finally {
            csvTree.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object traverse(BArray csv, CsvConfig config, BTypedesc typed, Type type) {
        CsvTree csvTree = tlCsvTree.get();
        try {
            Object convertedValue = csvTree.traverseCsv(csv, config, type);
            Object object = DataUtils.validateConstraints(convertedValue, typed, config.enableConstraintValidation);
            return object;
        }
        catch (BError e) {
            BError bError = e;
            return bError;
        }
        finally {
            csvTree.reset();
        }
    }

    private static class CsvTree {
        Object currentCsvNode;
        Field currentField;
        Map<String, Field> fieldHierarchy = new HashMap<String, Field>();
        Map<String, String> updatedRecordFieldNames = new HashMap<String, String>();
        Map<String, Field> headerFieldHierarchy = new HashMap<String, Field>();
        HashSet<String> fields = new HashSet();
        Type restType;
        Deque<String> fieldNames = new ArrayDeque<String>();
        BArray rootCsvNode;
        Type expectedArrayElementType;
        Type sourceArrayElementType;
        CsvConfig config;
        String[] headers = null;
        int arraySize = 0;
        BString[] headersForArrayConversion = null;
        boolean addHeadersForOutput = false;
        boolean isFirstRowIsHeader = false;
        boolean isFirstRowInserted = false;

        void reset() {
            this.currentCsvNode = null;
            this.currentField = null;
            this.fieldHierarchy.clear();
            this.updatedRecordFieldNames.clear();
            this.headerFieldHierarchy.clear();
            this.fields.clear();
            this.restType = null;
            this.fieldNames.clear();
            this.rootCsvNode = null;
            this.expectedArrayElementType = null;
            this.sourceArrayElementType = null;
            this.config = null;
            this.headers = null;
            this.arraySize = 0;
            this.headersForArrayConversion = null;
            this.addHeadersForOutput = false;
            this.isFirstRowIsHeader = false;
            this.isFirstRowInserted = false;
        }

        void resetForUnionTypes() {
            this.currentCsvNode = null;
            this.currentField = null;
            this.fieldHierarchy.clear();
            this.updatedRecordFieldNames.clear();
            this.headerFieldHierarchy.clear();
            this.fields.clear();
            this.restType = null;
            this.fieldNames.clear();
            this.rootCsvNode = null;
            this.expectedArrayElementType = null;
            this.headers = null;
            this.arraySize = 0;
            this.headersForArrayConversion = null;
            this.addHeadersForOutput = false;
            this.isFirstRowIsHeader = false;
            this.isFirstRowInserted = false;
        }

        void resetForUnionMemberTypes() {
            this.currentCsvNode = null;
            this.currentField = null;
            this.fieldHierarchy.clear();
            this.updatedRecordFieldNames.clear();
            this.headerFieldHierarchy.clear();
            this.fields.clear();
            this.restType = null;
            this.fieldNames.clear();
            this.headers = null;
            this.headersForArrayConversion = null;
        }

        CsvTree() {
            this.reset();
        }

        public Object traverseCsv(BArray csv, CsvConfig config, Type type) {
            Optional<Type> mutableType;
            this.config = config;
            this.sourceArrayElementType = TypeUtils.getReferredType((Type)this.getSourceElementTypeForLists(csv));
            Type referredType = TypeUtils.getReferredType((Type)type);
            int sourceArraySize = (int)csv.getLength();
            if (referredType.getTag() == 34 && (mutableType = CsvUtils.getMutableType((IntersectionType)referredType)).isPresent()) {
                return CsvCreator.constructReadOnlyValue(this.traverseCsv(csv, config, mutableType.get()));
            }
            if (referredType.getTag() != 33) {
                Optional<Object> intersectionValue = this.handleNonUnionIntersections(referredType, csv, config);
                if (intersectionValue.isPresent()) {
                    return intersectionValue.get();
                }
                int expectedArraySize = ((ArrayType)referredType).getSize();
                this.setRootCsvNodeForNonUnionArrays(referredType, type);
                CsvUtils.validateExpectedArraySize(expectedArraySize, sourceArraySize);
                this.traverseCsvWithExpectedType(sourceArraySize, csv, type);
            } else {
                this.traverseCsvWithUnionExpectedType(referredType, type, sourceArraySize, csv);
            }
            return this.rootCsvNode;
        }

        private Optional<Object> handleNonUnionIntersections(Type referredType, BArray csv, CsvConfig config) {
            Type arrayElementType;
            if (referredType.getTag() == 32 && (arrayElementType = TypeUtils.getReferredType((Type)((ArrayType)referredType).getElementType())).getTag() == 34) {
                return CsvUtils.getMutableType((IntersectionType)arrayElementType).map(mutableType -> CsvCreator.constructReadOnlyValue(this.traverseCsv(csv, config, (Type)TypeCreator.createArrayType((Type)mutableType))));
            }
            return Optional.empty();
        }

        private void traverseCsvWithUnionExpectedType(Type referredType, Type type, int sourceArraySize, BArray csv) {
            for (Type memberType : ((UnionType)referredType).getMemberTypes()) {
                Type mType = TypeUtils.getReferredType((Type)memberType);
                if (mType.getTag() != 32) continue;
                int expectedArraySize = ((ArrayType)mType).getSize();
                this.resetForUnionTypes();
                try {
                    this.setRootCsvNodeForNonUnionArrays(mType, mType);
                    CsvUtils.validateExpectedArraySize(expectedArraySize, sourceArraySize);
                    this.traverseCsvWithExpectedType(sourceArraySize, csv, type);
                    return;
                }
                catch (Exception exception) {
                }
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.SOURCE_CANNOT_CONVERT_INTO_EXP_TYPE, type);
        }

        private void traverseCsvWithExpectedType(int sourceArraySize, BArray csv, Type type) {
            Optional<Type> mutableType;
            boolean isIntersection = false;
            this.isFirstRowIsHeader = false;
            if (this.expectedArrayElementType.getTag() == 34 && (mutableType = CsvUtils.getMutableType((IntersectionType)this.expectedArrayElementType)).isPresent()) {
                isIntersection = true;
                this.expectedArrayElementType = mutableType.get();
            }
            switch (this.expectedArrayElementType.getTag()) {
                case 24: 
                case 27: {
                    this.traverseCsvWithMappingAsExpectedType(sourceArraySize, csv, this.expectedArrayElementType, isIntersection);
                    break;
                }
                case 32: 
                case 44: {
                    this.traverseCsvWithListAsExpectedType(sourceArraySize, csv, this.expectedArrayElementType, isIntersection);
                    break;
                }
                case 33: {
                    this.traverseCsvWithUnionExpectedType(csv, (UnionType)this.expectedArrayElementType, type);
                    break;
                }
                default: {
                    throw DiagnosticLog.error(DiagnosticErrorCode.SOURCE_CANNOT_CONVERT_INTO_EXP_TYPE, type);
                }
            }
        }

        public void traverseCsvWithMappingAsExpectedType(long length, BArray csv, Type expectedArrayType, boolean isIntersection) {
            ArrayType arrayType = (ArrayType)this.rootCsvNode.getType();
            int rowNumber = 0;
            int i = 0;
            while ((long)i < length && (arrayType.getState() != ArrayType.ArrayState.CLOSED || arrayType.getSize() - 1 >= this.arraySize)) {
                Object o = csv.get((long)i);
                if ((long)i >= this.config.headerRows || (long)i == this.config.headerRows - 1L) {
                    if ((long)i >= this.config.headerRows && CsvTree.ignoreRow(rowNumber + 1, this.config.skipLines)) {
                        ++rowNumber;
                    } else {
                        Object rowValue = this.initStatesForCsvRowWithMappingAsExpectedType(o, expectedArrayType);
                        if (isIntersection) {
                            rowValue = CsvCreator.constructReadOnlyValue(rowValue);
                        }
                        if (!this.isFirstRowIsHeader) {
                            this.rootCsvNode.add((long)this.arraySize, rowValue);
                            ++this.arraySize;
                        }
                        if ((long)i >= this.config.headerRows) {
                            ++rowNumber;
                        }
                    }
                }
                ++i;
            }
        }

        public void traverseCsvWithListAsExpectedType(long length, BArray csv, Type expectedArrayType, boolean isIntersection) {
            expectedArrayType = TypeUtils.getReferredType((Type)expectedArrayType);
            ArrayType arrayType = (ArrayType)this.rootCsvNode.getType();
            int rowNumber = 0;
            int i = 0;
            while ((long)i < length && (arrayType.getState() != ArrayType.ArrayState.CLOSED || arrayType.getSize() - 1 >= this.arraySize)) {
                Object o = csv.get((long)i);
                if (!this.addHeadersForOutput && this.config.outputWithHeaders && (o instanceof BMap || this.config.customHeaders != null || (long)i == this.config.headerRows - 1L)) {
                    this.insertHeaderValuesForTheCsvIfApplicable(o, expectedArrayType);
                }
                if ((long)i >= this.config.headerRows) {
                    if (CsvTree.ignoreRow(rowNumber + 1, this.config.skipLines)) {
                        ++rowNumber;
                    } else {
                        Object rowValue = this.initStatesForCsvRowWithListAsExpectedType(o, expectedArrayType);
                        if (isIntersection) {
                            rowValue = CsvCreator.constructReadOnlyValue(rowValue);
                        }
                        if (!this.isFirstRowIsHeader) {
                            this.rootCsvNode.add((long)this.arraySize, rowValue);
                            ++this.arraySize;
                        }
                        ++rowNumber;
                    }
                }
                ++i;
            }
        }

        public void traverseCsvWithUnionExpectedType(BArray csv, UnionType expectedArrayType, Type type) {
            for (Type memberType : expectedArrayType.getMemberTypes()) {
                try {
                    memberType = TypeCreator.createArrayType((Type)TypeUtils.getReferredType((Type)memberType));
                    this.traverseCsv(csv, this.config, memberType);
                    return;
                }
                catch (Exception ex) {
                    this.resetForUnionTypes();
                }
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.SOURCE_CANNOT_CONVERT_INTO_EXP_TYPE, type);
        }

        private static boolean ignoreRow(int index, Object skipLinesConfig) {
            long[] skipLines;
            for (long skipLine : skipLines = CsvUtils.getSkipDataRows(skipLinesConfig)) {
                if (skipLine != (long)index) continue;
                return true;
            }
            return false;
        }

        public Object initStatesForCsvRowWithMappingAsExpectedType(Object csvElement, Type expectedType) {
            expectedType = TypeUtils.getReferredType((Type)expectedType);
            switch (expectedType.getTag()) {
                case 24: {
                    RecordType recordType = (RecordType)expectedType;
                    this.fieldHierarchy = new HashMap<String, Field>(recordType.getFields());
                    this.fields = new HashSet(recordType.getFields().keySet());
                    this.updatedRecordFieldNames = CsvUtils.processNameAnnotationsAndBuildCustomFieldMap(recordType, this.fieldHierarchy);
                    this.headerFieldHierarchy = new HashMap<String, Field>(recordType.getFields());
                    this.restType = recordType.getRestFieldType();
                    this.currentCsvNode = ValueCreator.createRecordValue((Module)recordType.getPackage(), (String)recordType.getName());
                    this.traverseCsvRowWithMappingAsExpectedType(csvElement, expectedType, false);
                    break;
                }
                case 27: {
                    MapType mapType = (MapType)expectedType;
                    this.currentCsvNode = ValueCreator.createMapValue((MapType)mapType);
                    this.traverseCsvRowWithMappingAsExpectedType(csvElement, expectedType, true);
                    break;
                }
                default: {
                    throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, expectedType);
                }
            }
            return this.currentCsvNode;
        }

        public Object initStatesForCsvRowWithListAsExpectedType(Object csvElement, Type expectedType) {
            expectedType = TypeUtils.getReferredType((Type)expectedType);
            switch (expectedType.getTag()) {
                case 32: {
                    ArrayType arrayType = (ArrayType)expectedType;
                    this.currentCsvNode = ValueCreator.createArrayValue((ArrayType)arrayType);
                    this.traverseCsvRowWithListAsExpectedType(csvElement, (Type)arrayType);
                    break;
                }
                case 44: {
                    TupleType tupleType = (TupleType)expectedType;
                    this.restType = tupleType.getRestType();
                    this.currentCsvNode = ValueCreator.createTupleValue((TupleType)tupleType);
                    this.traverseCsvRowWithListAsExpectedType(csvElement, (Type)tupleType);
                    break;
                }
                default: {
                    throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, expectedType);
                }
            }
            return this.currentCsvNode;
        }

        private void traverseCsvRowWithListAsExpectedType(Object csvElement, Type type) {
            int expectedTypeSize = CsvUtils.getTheExpectedArraySize(type);
            if (csvElement instanceof BMap) {
                BMap map = (BMap)csvElement;
                this.constructCsvArrayFromMapping((BMap<BString, Object>)map, type, expectedTypeSize == -1 ? map.size() : expectedTypeSize);
            } else if (csvElement instanceof BArray) {
                BArray array = (BArray)csvElement;
                this.constructCsvArrayFromNonMapping(array, type, expectedTypeSize == -1 ? array.size() : expectedTypeSize);
            }
        }

        private void constructCsvArrayFromMapping(BMap<BString, Object> map, Type type, int expectedSize) {
            BString[] keys;
            int index = 0;
            for (BString key : keys = this.generateCsvHeadersForMappingRow(map, this.config.headerOrder, map.size())) {
                boolean isArrayActive;
                if (!map.containsKey((Object)key)) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.HEADERS_WITH_VARYING_LENGTH_NOT_SUPPORTED, key);
                }
                Object v = map.get((Object)key);
                if (this.config.allowDataProjection && index >= expectedSize) break;
                Type memberType = this.getTheElementTypeFromList(type, index);
                if (memberType != null && !(isArrayActive = this.insertToListAndReturnFalseIfListEnds(v, memberType, index, this.currentCsvNode))) {
                    return;
                }
                ++index;
            }
        }

        private void constructCsvArrayFromNonMapping(BArray csvElement, Type type, int expectedSize) {
            int index = 0;
            int i = 0;
            while (!((long)i >= csvElement.getLength() || this.config.allowDataProjection && index >= expectedSize)) {
                boolean isArrayActive;
                Type memberType = this.getTheElementTypeFromList(type, index);
                if (memberType != null && !(isArrayActive = this.insertToListAndReturnFalseIfListEnds(csvElement.get((long)i), memberType, index, this.currentCsvNode))) {
                    return;
                }
                ++index;
                ++i;
            }
        }

        private void traverseCsvRowWithMappingAsExpectedType(Object csvElement, Type expectedType, boolean mappingType) {
            if (csvElement instanceof BMap) {
                BMap map = (BMap)csvElement;
                this.constructCsvMapFromMapping((BMap<BString, Object>)map, mappingType, expectedType);
            } else if (csvElement instanceof BArray) {
                BArray array = (BArray)csvElement;
                this.constructCsvMapFromNonMapping(array, mappingType, expectedType);
            } else {
                throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_CSV_DATA_FORMAT, new Object[0]);
            }
        }

        private void constructCsvMapFromNonMapping(BArray csvElement, boolean mappingType, Type expectedType) {
            boolean headersMatchWithExpType;
            this.isFirstRowIsHeader = false;
            int arraySize = csvElement.size();
            if (this.headers == null) {
                this.headers = CsvUtils.createHeadersForParseLists(csvElement, csvElement.size(), this.config);
                if (!this.isFirstRowInserted && this.config.headerRows >= 1L) {
                    this.isFirstRowIsHeader = true;
                    this.isFirstRowInserted = true;
                    return;
                }
            }
            if (!(headersMatchWithExpType = this.validateHeaders(expectedType, csvElement, arraySize))) {
                throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_CONVERSION_FOR_ARRAY_TO_MAP, csvElement, expectedType);
            }
            this.insertCsvMappingRow(csvElement, arraySize, mappingType, expectedType);
        }

        private void constructCsvMapFromMapping(BMap<BString, Object> map, boolean mappingType, Type expType) {
            for (BString key : (BString[])map.getKeys()) {
                Type currentFieldType;
                if (!mappingType) {
                    if (!this.isMappingKeyBelongsToNonRestType(map.get((Object)key), key)) continue;
                    currentFieldType = TypeUtils.getReferredType((Type)this.currentField.getFieldType());
                } else {
                    this.addFieldInMapType(key);
                    currentFieldType = TypeUtils.getReferredType((Type)((MapType)expType).getConstrainedType());
                }
                this.insertCurrentFieldMemberIntoMapping(currentFieldType, map.get((Object)key), key, mappingType);
            }
            CsvUtils.checkRequiredFieldsAndLogError(this.fieldHierarchy, this.config.absentAsNilableType);
        }

        private void insertHeaderValuesForTheCsvIfApplicable(Object obj, Type type) {
            if (this.config.outputWithHeaders && CsvUtils.isExpectedTypeIsArray(type)) {
                boolean isArrayActive;
                Type memberType;
                BArray headersArray;
                if (this.headers == null && obj instanceof BArray) {
                    BArray array = (BArray)obj;
                    this.headers = CsvUtils.createHeadersForParseLists(array, array.size(), this.config);
                }
                if (this.headers == null && obj instanceof BMap) {
                    BMap map = (BMap)obj;
                    int size = map.size();
                    BString[] headerArray = this.generateCsvHeadersForMappingRow((BMap<BString, Object>)map, this.config.headerOrder, size);
                    this.headers = new String[size];
                    for (int i = 0; i < headerArray.length; ++i) {
                        this.headers[i] = StringUtils.getStringValue((Object)headerArray[i]);
                    }
                }
                if (type instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)type;
                    headersArray = ValueCreator.createArrayValue((ArrayType)arrayType);
                } else {
                    headersArray = ValueCreator.createTupleValue((TupleType)((TupleType)type));
                }
                for (int i = 0; i < this.headers.length && ((memberType = this.getTheElementTypeFromList(type, i)) == null || (isArrayActive = this.insertToListAndReturnFalseIfListEnds(StringUtils.fromString((String)this.headers[i]), memberType, i, headersArray))); ++i) {
                }
                if (!this.isFirstRowIsHeader) {
                    this.rootCsvNode.add((long)this.arraySize, (Object)headersArray);
                    ++this.arraySize;
                    this.addHeadersForOutput = true;
                }
            }
        }

        private BString[] generateCsvHeadersForMappingRow(BMap<BString, Object> map, Object headerOrder, int size) {
            BString[] keys = new BString[size];
            if (headerOrder != null) {
                String[] order = ((BArray)headerOrder).getStringArray();
                if (order.length != size) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_HEADER_NAMES_LENGTH, new Object[0]);
                }
                for (int i = 0; i < size; ++i) {
                    keys[i] = StringUtils.fromString((String)order[i]);
                }
            } else {
                if (this.headersForArrayConversion == null) {
                    this.headersForArrayConversion = (BString[])map.getKeys();
                }
                keys = this.headersForArrayConversion;
            }
            return keys;
        }

        private Type getTheElementTypeFromList(Type type, int index) {
            if (type instanceof TupleType) {
                TupleType tupleType = (TupleType)type;
                List tupleTypes = tupleType.getTupleTypes();
                if (tupleTypes.size() >= index + 1) {
                    return (Type)tupleTypes.get(index);
                }
                Type res = tupleType.getRestType();
                if (res != null) {
                    return res;
                }
                if (this.config.allowDataProjection) {
                    return null;
                }
                throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_EXPECTED_TUPLE_SIZE, tupleTypes.size());
            }
            ArrayType arrayType = (ArrayType)type;
            if (arrayType.getSize() != -1 && arrayType.getSize() <= index) {
                if (this.config.allowDataProjection) {
                    return null;
                }
                throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_EXPECTED_ARRAY_SIZE, arrayType.getSize());
            }
            return arrayType.getElementType();
        }

        private boolean validateHeaders(Type expectedType, BArray csvElement, int arraySize) {
            if (arraySize < this.headers.length) {
                throw DiagnosticLog.error(DiagnosticErrorCode.HEADERS_WITH_VARYING_LENGTH_NOT_SUPPORTED, new Object[0]);
            }
            if (expectedType instanceof MapType) {
                return true;
            }
            Type type = csvElement.getType();
            if (type instanceof TupleType) {
                TupleType tupleType = (TupleType)type;
                return this.validateHeadersWithTupleDataRows(expectedType, tupleType);
            }
            return this.validateHeadersWithArrayDataRows(expectedType);
        }

        private boolean validateHeadersWithTupleDataRows(Type expectedType, TupleType tupleType) {
            List tupleTypes = tupleType.getTupleTypes();
            Type tupleRestType = tupleType.getRestType();
            if (expectedType instanceof RecordType) {
                if (this.restType != null && (this.restType.getTag() == 23 || this.restType.getTag() == 15)) {
                    return true;
                }
                for (int i = 0; i < this.headers.length; ++i) {
                    Type type = i >= tupleTypes.size() ? tupleRestType : (Type)tupleTypes.get(i);
                    String header = this.headers[i];
                    Field field = this.headerFieldHierarchy.remove(header);
                    if (field != null) {
                        if (this.config.stringConversion || type == null || type.getTag() == field.getFieldType().getTag()) continue;
                        return false;
                    }
                    if (tupleRestType != null && (type == this.restType || this.restType == tupleRestType) || CsvUtils.isHeaderFieldsEmpty(this.headerFieldHierarchy)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean validateHeadersWithArrayDataRows(Type expectedType) {
            if (expectedType instanceof RecordType) {
                if (this.restType != null) {
                    return true;
                }
                for (String key : this.fieldHierarchy.keySet()) {
                    for (String header : this.headers) {
                        if (!key.equals(this.updatedRecordFieldNames.get(header))) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private void insertCsvMappingRow(BArray csvElement, int arraySize, boolean mappingType, Type expectedType) {
            if (arraySize != this.headers.length) {
                throw DiagnosticLog.error(DiagnosticErrorCode.HEADERS_WITH_VARYING_LENGTH_NOT_SUPPORTED, new Object[0]);
            }
            for (int i = 1; i <= arraySize; ++i) {
                Type fieldType;
                BString key = StringUtils.fromString((String)this.headers[i - 1]);
                if (!mappingType) {
                    if (!this.isMappingKeyBelongsToNonRestType(csvElement.get((long)(i - 1)), key)) continue;
                    fieldType = TypeUtils.getReferredType((Type)this.currentField.getFieldType());
                } else {
                    this.addFieldInMapType(key);
                    fieldType = ((MapType)expectedType).getConstrainedType();
                }
                this.insertCurrentFieldMemberIntoMapping(fieldType, csvElement.get((long)(i - 1)), key, mappingType);
            }
            CsvUtils.checkRequiredFieldsAndLogError(this.fieldHierarchy, this.config.absentAsNilableType);
        }

        private boolean isMappingKeyBelongsToNonRestType(Object value, BString key) {
            String keyStr = StringUtils.getStringValue((Object)key);
            String fieldName = CsvUtils.getUpdatedHeaders(this.updatedRecordFieldNames, keyStr, this.fields.contains(keyStr));
            this.currentField = this.fieldHierarchy.remove(fieldName);
            if (this.currentField == null) {
                if (this.restType != null) {
                    Type restFieldType = TypeUtils.getReferredType((Type)this.restType);
                    this.insertRestFieldMemberIntoMapping(restFieldType, key, value);
                    return false;
                }
                if (this.config.allowDataProjection) {
                    return false;
                }
                throw DiagnosticLog.error(DiagnosticErrorCode.NO_FIELD_FOR_HEADER, key);
            }
            this.fieldNames.push(this.currentField.getFieldName());
            return true;
        }

        private void addFieldInMapType(BString key) {
            this.fieldNames.push(key.toString());
        }

        private Object convertCsvValueIntoExpectedType(Type type, Object csvMember, boolean isRecursive) {
            Type fieldType = TypeUtils.getReferredType((Type)type);
            Object nilValue = this.config.nilValue;
            if (!isRecursive && this.config.nilAsOptionalField && !fieldType.isNilable() && CsvUtils.isNullValue(nilValue, csvMember) && this.currentField != null && SymbolFlags.isFlagOn((long)this.currentField.getFlags(), (long)4096L)) {
                return CsvUtils.SkipMappedValue.VALUE;
            }
            if (this.config.stringConversion && csvMember instanceof BString) {
                BString str = (BString)csvMember;
                Object convertedValue = CsvCreator.convertToExpectedType(str, type, this.config);
                if (!(convertedValue instanceof BError)) {
                    return convertedValue;
                }
            } else {
                switch (fieldType.getTag()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 23: 
                    case 46: {
                        Object value;
                        if (!CsvUtils.checkTypeCompatibility(fieldType, csvMember, this.config.stringConversion) || (value = CsvUtils.convertToBasicType(csvMember, fieldType, this.config)) instanceof BError) break;
                        return value;
                    }
                    case 33: {
                        for (Type memberType : ((UnionType)fieldType).getMemberTypes()) {
                            if (!CsvUtils.isBasicType(memberType = TypeUtils.getReferredType((Type)memberType))) {
                                throw DiagnosticLog.error(DiagnosticErrorCode.EXPECTED_TYPE_CAN_ONLY_CONTAIN_BASIC_TYPES, memberType);
                            }
                            Object value = this.convertCsvValueIntoExpectedType(memberType, csvMember, true);
                            if (value instanceof BError || value instanceof CsvUtils.UnMappedValue) continue;
                            return value;
                        }
                        break;
                    }
                    case 34: {
                        Type effectiveType = ((IntersectionType)fieldType).getEffectiveType();
                        effectiveType = TypeUtils.getReferredType((Type)effectiveType);
                        if (!SymbolFlags.isFlagOn((long)32L, (long)effectiveType.getFlags())) {
                            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, type);
                        }
                        for (Type constituentType : ((IntersectionType)fieldType).getConstituentTypes()) {
                            if ((constituentType = TypeUtils.getReferredType((Type)constituentType)).getTag() == 51) continue;
                            return CsvCreator.constructReadOnlyValue(this.convertCsvValueIntoExpectedType(constituentType, csvMember, true));
                        }
                        break;
                    }
                    default: {
                        throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_EXPECTED_TYPE, type);
                    }
                }
            }
            return CsvUtils.UnMappedValue.VALUE;
        }

        private void insertRestFieldMemberIntoMapping(Type type, BString key, Object csvMember) {
            Object value = this.convertCsvValueIntoExpectedType(type, csvMember, false);
            if (!(value instanceof CsvUtils.UnMappedValue)) {
                ((BMap)this.currentCsvNode).put((Object)key, value);
            }
        }

        private void insertCurrentFieldMemberIntoMapping(Type type, Object recValue, BString key, boolean isMapType) {
            Object value = this.convertCsvValueIntoExpectedType(type, recValue, false);
            if (!(value instanceof CsvUtils.UnMappedValue) && !(value instanceof CsvUtils.SkipMappedValue)) {
                ((BMap)this.currentCsvNode).put((Object)StringUtils.fromString((String)this.fieldNames.pop()), value);
                return;
            }
            if (isMapType || value instanceof CsvUtils.SkipMappedValue) {
                return;
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE_FOR_FIELD, recValue, key);
        }

        public boolean insertToListAndReturnFalseIfListEnds(Object arrayValue, Type type, int index, Object currentCsvNode) {
            Object value = this.convertCsvValueIntoExpectedType(type, arrayValue, false);
            boolean isArrayType = type instanceof ArrayType;
            if (!(value instanceof CsvUtils.UnMappedValue)) {
                ArrayType arrayType;
                if (isArrayType && (arrayType = (ArrayType)TypeUtils.getType((Object)type)).getState() == ArrayType.ArrayState.CLOSED && arrayType.getSize() - 1 < index) {
                    return false;
                }
                ((BArray)currentCsvNode).add((long)index, value);
                return true;
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE_FOR_ARRAY, arrayValue, index, type);
        }

        private void setRootCsvNodeForNonUnionArrays(Type referredType, Type type) {
            if ((referredType = TypeUtils.getReferredType((Type)referredType)) instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)referredType;
                this.rootCsvNode = ValueCreator.createArrayValue((ArrayType)arrayType);
                this.expectedArrayElementType = TypeUtils.getReferredType((Type)arrayType.getElementType());
                return;
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, type, PredefinedTypes.TYPE_ANYDATA_ARRAY);
        }

        private Type getSourceElementTypeForLists(BArray csv) {
            Type type = csv.getType();
            if (type instanceof TupleType) {
                TupleType tupleType = (TupleType)type;
                ArrayList memberTypes = new ArrayList(tupleType.getTupleTypes());
                return TypeCreator.createUnionType(memberTypes);
            }
            return csv.getElementType();
        }
    }
}

