/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.csvdata.utils;

import io.ballerina.lib.data.csvdata.utils.Constants;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;

public class CsvConfig {
    public char delimiter = (char)44;
    public char textEnclosure = (char)92;
    public Object header = 0;
    public char escapeChar = (char)92;
    public Object lineTerminator = Character.valueOf('\n');
    public Object skipLines = null;
    public Object nilValue = null;
    public char comment = (char)35;
    public String locale = "en_US";
    public boolean nilAsOptionalField = false;
    public boolean absentAsNilableType = false;
    public boolean allowDataProjection = true;
    public Object headerOrder = null;
    public boolean stringConversion = false;
    public boolean enableConstraintValidation = false;
    public boolean outputWithHeaders = false;
    public Object customHeadersIfHeadersAbsent = null;
    public long headerRows = 0L;
    public Object customHeaders = null;

    private CsvConfig(CsvConfig config) {
        this.allowDataProjection = false;
        this.header = config.header;
        this.delimiter = config.delimiter;
        this.textEnclosure = config.textEnclosure;
        this.escapeChar = config.escapeChar;
        this.lineTerminator = config.lineTerminator;
        this.nilValue = config.nilValue;
        this.comment = config.comment;
        this.locale = config.locale;
    }

    public static CsvConfig createParseListOptions(BMap<BString, Object> options) {
        CsvConfig.updateDataProjectOptions(options);
        return new CsvConfig(options.getBooleanValue(Constants.ConfigConstants.NIL_AS_OPTIONAL), options.getBooleanValue(Constants.ConfigConstants.ABSENT_AS_NILABLE), options.getBooleanValue(Constants.ConfigConstants.ALLOW_DATA_PROJECTION), options.get((Object)Constants.ConfigConstants.SKIP_LINES), options.getBooleanValue(Constants.ConfigConstants.ENABLE_CONSTRAINT_VALIDATION), options.getBooleanValue(Constants.ConfigConstants.OUTPUT_WITH_HEADERS), options.getIntValue(Constants.ConfigConstants.HEADER_ROWS), options.get((Object)Constants.ConfigConstants.CUSTOM_HEADERS));
    }

    public CsvConfig(boolean nilAsOptionalField, boolean absentAsNilableType, boolean allowDataProjection, Object skipLines, boolean enableConstraintValidation, boolean outputWithHeaders, long headerRows, Object headers) {
        this.nilAsOptionalField = nilAsOptionalField;
        this.absentAsNilableType = absentAsNilableType;
        this.allowDataProjection = allowDataProjection;
        this.skipLines = skipLines;
        this.enableConstraintValidation = enableConstraintValidation;
        this.outputWithHeaders = outputWithHeaders;
        this.headerRows = headerRows;
        this.customHeaders = headers;
    }

    public static CsvConfig createTransformOptions(BMap<BString, Object> options) {
        CsvConfig.updateDataProjectOptions(options);
        return new CsvConfig(options.getBooleanValue(Constants.ConfigConstants.NIL_AS_OPTIONAL), options.getBooleanValue(Constants.ConfigConstants.ABSENT_AS_NILABLE), options.getBooleanValue(Constants.ConfigConstants.ALLOW_DATA_PROJECTION), options.get((Object)Constants.ConfigConstants.SKIP_LINES), options.getBooleanValue(Constants.ConfigConstants.ENABLE_CONSTRAINT_VALIDATION), options.getBooleanValue(Constants.ConfigConstants.OUTPUT_WITH_HEADERS), options.get((Object)Constants.ConfigConstants.HEADERS_ORDER));
    }

    public CsvConfig(boolean nilAsOptionalField, boolean absentAsNilableType, boolean allowDataProjection, Object skipLines, boolean enableConstraintValidation, boolean outputWithHeaders, Object headerOrder) {
        this.nilAsOptionalField = nilAsOptionalField;
        this.absentAsNilableType = absentAsNilableType;
        this.allowDataProjection = allowDataProjection;
        this.skipLines = skipLines;
        this.enableConstraintValidation = enableConstraintValidation;
        this.outputWithHeaders = outputWithHeaders;
        this.headerOrder = headerOrder;
    }

    public static CsvConfig createParseOptions(BMap<BString, Object> options) {
        CsvConfig.updateDataProjectOptions(options);
        return new CsvConfig(options.getBooleanValue(Constants.ConfigConstants.NIL_AS_OPTIONAL), options.getBooleanValue(Constants.ConfigConstants.ABSENT_AS_NILABLE), options.getBooleanValue(Constants.ConfigConstants.ALLOW_DATA_PROJECTION), options.get((Object)Constants.ConfigConstants.SKIP_LINES), options.getBooleanValue(Constants.ConfigConstants.ENABLE_CONSTRAINT_VALIDATION), options.getBooleanValue(Constants.ConfigConstants.OUTPUT_WITH_HEADERS), StringUtils.getStringValue((Object)options.getStringValue(Constants.ConfigConstants.DELIMITER)).charAt(0), StringUtils.getStringValue((Object)options.getStringValue(Constants.ConfigConstants.LOCALE)), StringUtils.getStringValue((Object)options.getStringValue(Constants.ConfigConstants.TEXT_ENCLOSURE)).charAt(0), StringUtils.getStringValue((Object)options.getStringValue(Constants.ConfigConstants.ESCAPE_CHAR)).charAt(0), options.get((Object)Constants.ConfigConstants.LINE_TERMINATOR), options.get((Object)Constants.ConfigConstants.NIL_VALUE), StringUtils.getStringValue((Object)options.getStringValue(Constants.ConfigConstants.COMMENT_CHAR)).charAt(0), options.get((Object)Constants.ConfigConstants.HEADER), options.get((Object)Constants.ConfigConstants.CUSTOM_HEADERS_IF_HEADER_ABSENT));
    }

    public CsvConfig(boolean nilAsOptionalField, boolean absentAsNilableType, boolean allowDataProjection, Object skipLines, boolean enableConstraintValidation, boolean outputWithHeaders, char delimiter, String locale, char textEnclosure, char escapeChar, Object lineTerminator, Object nilValue, char comment, Object header, Object customHeadersIfHeadersAbsent) {
        this.nilAsOptionalField = nilAsOptionalField;
        this.absentAsNilableType = absentAsNilableType;
        this.allowDataProjection = allowDataProjection;
        this.skipLines = skipLines;
        this.enableConstraintValidation = enableConstraintValidation;
        this.outputWithHeaders = outputWithHeaders;
        this.delimiter = delimiter;
        this.locale = locale;
        this.textEnclosure = textEnclosure;
        this.escapeChar = escapeChar;
        this.lineTerminator = lineTerminator;
        this.nilValue = nilValue;
        this.comment = comment;
        this.header = header;
        this.customHeadersIfHeadersAbsent = customHeadersIfHeadersAbsent;
    }

    public static CsvConfig createConfigOptionsForUnion(CsvConfig config) {
        return new CsvConfig(config);
    }

    private static void updateDataProjectOptions(BMap<BString, Object> options) {
        Object allowProjections = options.get((Object)Constants.ConfigConstants.ALLOW_DATA_PROJECTION);
        if (allowProjections instanceof Boolean) {
            options.put((Object)Constants.ConfigConstants.NIL_AS_OPTIONAL, (Object)false);
            options.put((Object)Constants.ConfigConstants.ABSENT_AS_NILABLE, (Object)false);
            return;
        }
        BMap projections = (BMap)allowProjections;
        options.put((Object)Constants.ConfigConstants.ALLOW_DATA_PROJECTION, (Object)true);
        options.put((Object)Constants.ConfigConstants.NIL_AS_OPTIONAL, (Object)projections.getBooleanValue(Constants.ConfigConstants.NIL_AS_OPTIONAL));
        options.put((Object)Constants.ConfigConstants.ABSENT_AS_NILABLE, (Object)projections.getBooleanValue(Constants.ConfigConstants.ABSENT_AS_NILABLE));
    }
}

