/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.servicemodelgenerator.extension.model;

import io.ballerina.servicemodelgenerator.extension.model.Codedata;
import io.ballerina.servicemodelgenerator.extension.model.DisplayAnnotation;
import io.ballerina.servicemodelgenerator.extension.model.Service;
import io.ballerina.servicemodelgenerator.extension.model.Value;
import io.ballerina.servicemodelgenerator.extension.util.Utils;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Trigger {
    private int id;
    private String name;
    private String type;
    private String displayName;
    private String documentation;
    private String moduleName;
    private String orgName;
    private String version;
    private String packageName;
    private String listenerProtocol;
    private String icon;
    private DisplayAnnotation displayAnnotation;
    private Map<String, Value> properties;
    private Service service;

    public Trigger() {
        this(0, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public Trigger(int id, String name, String type, String displayName, String documentation, String moduleName, String orgName, String version, String packageName, String listenerProtocol, String icon, DisplayAnnotation displayAnnotation, Map<String, Value> properties, Service service) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.displayName = displayName;
        this.documentation = documentation;
        this.moduleName = moduleName;
        this.orgName = orgName;
        this.version = version;
        this.packageName = packageName;
        this.listenerProtocol = listenerProtocol;
        this.icon = icon;
        this.displayAnnotation = displayAnnotation;
        this.properties = properties;
        this.service = service;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getListenerProtocol() {
        return this.listenerProtocol;
    }

    public void setListenerProtocol(String listenerProtocol) {
        this.listenerProtocol = listenerProtocol;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public DisplayAnnotation getDisplayAnnotation() {
        return this.displayAnnotation;
    }

    public void setDisplayAnnotation(DisplayAnnotation displayAnnotation) {
        this.displayAnnotation = displayAnnotation;
    }

    public Map<String, Value> getProperties() {
        return this.properties != null ? this.properties : new HashMap<String, Value>();
    }

    public Value getProperty(String key) {
        return this.properties != null ? this.properties.get(key) : null;
    }

    public void addProperty(String key, Value value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Value>();
        }
        this.properties.put(key, value);
    }

    public void setProperties(Map<String, Value> properties) {
        this.properties = properties;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public String getListenerDeclaration() {
        ArrayList params = new ArrayList();
        this.properties.forEach((key, value) -> {
            if (this.isListenerInitProperty((Value)value) && value.isEnabledWithValue()) {
                params.add(String.format("%s = %s", key, Utils.getValueString(value)));
            }
        });
        return String.format("new %s:Listener(%s)", this.listenerProtocol, String.join((CharSequence)", ", params));
    }

    public boolean isListenerInitProperty(Value value) {
        Codedata codedata = value.getCodedata();
        if (Objects.isNull(codedata)) {
            return false;
        }
        return codedata.isInListenerInit();
    }

    public boolean isBasePathProperty(Value value) {
        Codedata codedata = value.getCodedata();
        if (Objects.isNull(codedata)) {
            return false;
        }
        return codedata.isBasePath();
    }

    public boolean isDisplayAnnotationProperty(Value value) {
        Codedata codedata = value.getCodedata();
        if (Objects.isNull(codedata)) {
            return false;
        }
        return codedata.isInDisplayAnnotation();
    }

    public Optional<Value> getBasePathProperty() {
        for (Map.Entry<String, Value> entry : this.properties.entrySet()) {
            if (!this.isBasePathProperty(entry.getValue()) || !entry.getValue().isEnabledWithValue()) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public Optional<String> getBasePath() {
        return this.getBasePathProperty().map(Utils::getValueString);
    }

    public void setBasePath(String basePath) {
        this.getBasePathProperty().ifPresent(value -> value.setValue(basePath));
    }

    public Optional<Value> getSvcDisplayAnnotationProperty() {
        for (Map.Entry<String, Value> entry : this.properties.entrySet()) {
            if (!this.isDisplayAnnotationProperty(entry.getValue()) || !entry.getValue().isEnabledWithValue()) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public Optional<String> getSvcDisplayAnnotation() {
        return this.getSvcDisplayAnnotationProperty().map(Utils::getValueString);
    }

    public void setSvcDisplayAnnotation(String svcDisplayAnnotation, LineRange lineRange) {
        this.getSvcDisplayAnnotationProperty().ifPresent(value -> {
            value.setValue(svcDisplayAnnotation.replaceAll("^\"|\"$", ""));
            value.setEnabled(true);
            value.getCodedata().setLineRange(lineRange);
        });
    }
}

