/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.servicemodelgenerator.extension.util;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.modelgenerator.commons.ServiceDatabaseManager;
import io.ballerina.servicemodelgenerator.extension.model.Codedata;
import io.ballerina.servicemodelgenerator.extension.model.Function;
import io.ballerina.servicemodelgenerator.extension.model.FunctionReturnType;
import io.ballerina.servicemodelgenerator.extension.model.HttpResponse;
import io.ballerina.servicemodelgenerator.extension.model.Parameter;
import io.ballerina.servicemodelgenerator.extension.model.Service;
import io.ballerina.servicemodelgenerator.extension.model.Value;
import io.ballerina.servicemodelgenerator.extension.util.ServiceModelUtils;
import io.ballerina.servicemodelgenerator.extension.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public final class HttpUtil {
    public static final Map<String, String> HTTP_CODES;
    public static final Map<String, String> HTTP_CODES_DES;

    private HttpUtil() {
    }

    public static void populateHttpResponses(FunctionReturnType returnType, SemanticModel semanticModel, ResourceMethodSymbol resource) {
        Optional method;
        Optional returnTypeSymbol = resource.typeDescriptor().returnTypeDescriptor();
        if (returnTypeSymbol.isEmpty()) {
            return;
        }
        Optional module = resource.getModule();
        String currentModuleName = "";
        if (module.isPresent()) {
            currentModuleName = ((ModuleSymbol)module.get()).getName().orElse("");
        }
        if ((method = resource.getName()).isEmpty()) {
            return;
        }
        int defaultStatusCode = ((String)method.get()).trim().equalsIgnoreCase("post") ? 201 : 200;
        List<HttpResponse> httpResponses = HttpUtil.getHttpResponses((TypeSymbol)returnTypeSymbol.get(), defaultStatusCode, semanticModel, currentModuleName);
        returnType.setResponses(httpResponses);
    }

    public static void updateHttpServiceContractModel(Service serviceModel, TypeDefinitionNode serviceTypeNode, ServiceDeclarationNode serviceDeclaration, SemanticModel semanticModel) {
        Service commonSvcModel = HttpUtil.fromHttpServiceWithContract(serviceTypeNode, serviceDeclaration, semanticModel);
        HttpUtil.enableContractFirstApproach(serviceModel);
        HttpUtil.updateServiceInfo(serviceModel, commonSvcModel);
        serviceModel.setCodedata(new Codedata(serviceDeclaration.lineRange()));
        Utils.populateListenerInfo(serviceModel, serviceDeclaration);
    }

    public static void updateHttpServiceModel(Service serviceModel, ServiceDeclarationNode serviceNode, SemanticModel semanticModel) {
        Service commonSvcModel = HttpUtil.getServiceModel(serviceNode, semanticModel);
        HttpUtil.updateServiceInfo(serviceModel, commonSvcModel);
        serviceModel.setCodedata(new Codedata(serviceNode.lineRange()));
        Utils.populateListenerInfo(serviceModel, serviceNode);
        Utils.updateAnnotationAttachmentProperty(serviceNode, serviceModel);
        String attachPoint = Utils.getPath((NodeList<Node>)serviceNode.absoluteResourcePath());
        if (!attachPoint.isEmpty()) {
            Value basePathProperty = serviceModel.getBasePath();
            if (Objects.nonNull(basePathProperty)) {
                basePathProperty.setValue(attachPoint);
            } else {
                serviceModel.setBasePath(ServiceModelUtils.getBasePathProperty(attachPoint));
            }
        }
    }

    private static void updateServiceInfo(Service serviceModel, Service commonSvcModel) {
        Utils.populateRequiredFuncsDesignApproachAndServiceType(serviceModel);
        Utils.updateValue(serviceModel.getServiceContractTypeNameValue(), commonSvcModel.getServiceContractTypeNameValue());
        commonSvcModel.getFunctions().forEach(functionModel -> {
            if (functionModel.getKind().equals("RESOURCE")) {
                HttpUtil.getResourceFunctionModel().ifPresentOrElse(resourceFunction -> {
                    if (resourceFunction.getReturnType().getResponses().size() > 1) {
                        resourceFunction.getReturnType().getResponses().remove(1);
                    }
                    HttpUtil.updateFunctionInfo(resourceFunction, functionModel);
                    serviceModel.addFunction((Function)resourceFunction);
                }, () -> serviceModel.addFunction((Function)functionModel));
            } else {
                functionModel.setAnnotations(null);
                functionModel.getAccessor().setEnabled(false);
                serviceModel.addFunction((Function)functionModel);
            }
        });
    }

    public static Service fromHttpServiceWithContract(TypeDefinitionNode serviceTypeNode, ServiceDeclarationNode serviceDeclarationNode, SemanticModel semanticModel) {
        Service serviceModel = Service.getEmptyServiceModel();
        Value serviceContractType = new Value.ValueBuilder().enabled(true).valueType("IDENTIFIER").value(serviceTypeNode.typeName().text().trim()).build();
        serviceModel.setServiceContractTypeName(serviceContractType);
        serviceDeclarationNode.members().forEach(member -> {
            if (member instanceof FunctionDefinitionNode) {
                FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)member;
                Function functionModel = Utils.getFunctionModel(functionDefinitionNode, semanticModel, true, false, Map.of());
                serviceModel.getFunctions().add(functionModel);
            }
        });
        return serviceModel;
    }

    public static Optional<String> getHttpParameterType(NodeList<AnnotationNode> annotations) {
        for (AnnotationNode annotation : annotations) {
            String[] annotStrings;
            Node annotReference = annotation.annotReference();
            String annotName = annotReference.toString();
            if (annotReference.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE || !(annotStrings = annotName.split(":"))[0].trim().equals("http")) continue;
            return Optional.of(annotStrings[annotStrings.length - 1].trim().toUpperCase(Locale.ROOT));
        }
        return Optional.empty();
    }

    private static Service getServiceModel(ServiceDeclarationNode serviceDeclarationNode, SemanticModel semanticModel) {
        ServiceDatabaseManager databaseManager = ServiceDatabaseManager.getInstance();
        List annotationAttachments = databaseManager.getAnnotationAttachments("ballerina", "http", "OBJECT_METHOD");
        Map<String, Value> annotations = Function.createAnnotationsMap(annotationAttachments);
        Service serviceModel = Service.getEmptyServiceModel();
        serviceDeclarationNode.members().forEach(member -> {
            if (member instanceof FunctionDefinitionNode) {
                FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)member;
                Function functionModel = Utils.getFunctionModel(functionDefinitionNode, semanticModel, true, false, annotations);
                functionModel.setEditable(true);
                serviceModel.getFunctions().add(functionModel);
            }
        });
        return serviceModel;
    }

    private static Optional<Function> getResourceFunctionModel() {
        Optional<Function> optional;
        InputStream resourceStream = Utils.class.getClassLoader().getResourceAsStream("functions/http_resource.json");
        if (resourceStream == null) {
            return Optional.empty();
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
        try {
            optional = Optional.of((Function)new Gson().fromJson(reader, Function.class));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        reader.close();
        return optional;
    }

    private static void enableContractFirstApproach(Service service) {
        Value designApproach = service.getDesignApproach();
        if (Objects.nonNull(designApproach) && Objects.nonNull(designApproach.getChoices()) && !designApproach.getChoices().isEmpty()) {
            designApproach.getChoices().forEach(choice -> choice.setEnabled(false));
            designApproach.getChoices().stream().filter(choice -> choice.getMetadata().label().equals("Import From OpenAPI Specification")).findFirst().ifPresent(approach -> {
                approach.setEnabled(true);
                approach.getProperties().remove("spec");
            });
        }
    }

    private static void updateFunctionInfo(Function functionModel, Function commonFunction) {
        functionModel.setEditable(commonFunction.isEditable());
        functionModel.setEnabled(true);
        functionModel.setKind(commonFunction.getKind());
        functionModel.setCodedata(commonFunction.getCodedata());
        Utils.updateValue(functionModel.getAccessor(), commonFunction.getAccessor());
        Utils.updateValue(functionModel.getName(), commonFunction.getName());
        Utils.updateValue(functionModel.getReturnType(), commonFunction.getReturnType());
        List<Parameter> parameters = functionModel.getParameters();
        parameters.removeIf(parameter -> commonFunction.getParameters().stream().anyMatch(newParameter -> newParameter.getType().getValue().equals(parameter.getType().getValue())));
        commonFunction.getParameters().forEach(functionModel::addParameter);
    }

    private static List<HttpResponse> getHttpResponses(TypeSymbol returnTypeSymbol, int defaultStatusCode, SemanticModel semanticModel, String currentModuleName) {
        ArrayList statusCodeResponses = new ArrayList();
        ArrayList anydataResponses = new ArrayList();
        ArrayList errorResponses = new ArrayList();
        Optional<UnionTypeSymbol> unionType = HttpUtil.getUnionType(returnTypeSymbol);
        AtomicBoolean hasHttpResponse = new AtomicBoolean(false);
        TypeSymbol errorTypeSymbol = semanticModel.types().ERROR;
        unionType.ifPresentOrElse(unionTypeSymbol -> unionTypeSymbol.memberTypeDescriptors().forEach(member -> {
            if (HttpUtil.isSubTypeOfHttpStatusCodeResponse(member, semanticModel)) {
                statusCodeResponses.add(member);
            } else if (member.subtypeOf(errorTypeSymbol)) {
                errorResponses.add(member);
            } else if (HttpUtil.isHttpResponse(HttpUtil.getTypeName(member, currentModuleName))) {
                hasHttpResponse.set(true);
            } else {
                anydataResponses.add(member);
            }
        }), () -> {
            if (HttpUtil.isSubTypeOfHttpStatusCodeResponse(returnTypeSymbol, semanticModel)) {
                statusCodeResponses.add(returnTypeSymbol);
            } else if (HttpUtil.isHttpResponse(HttpUtil.getTypeName(returnTypeSymbol, currentModuleName))) {
                hasHttpResponse.set(true);
            } else if (returnTypeSymbol.subtypeOf(errorTypeSymbol)) {
                errorResponses.add(returnTypeSymbol);
            } else {
                anydataResponses.add(returnTypeSymbol);
            }
        });
        ArrayList<HttpResponse> responses = new ArrayList<HttpResponse>();
        HttpResponse normalResponse = new HttpResponse(String.valueOf(defaultStatusCode), "http:Response");
        normalResponse.setAdvanced(true);
        normalResponse.setEditable(true);
        normalResponse.setEnabled(hasHttpResponse.get());
        normalResponse.setHttpResponseType(true);
        responses.add(normalResponse);
        statusCodeResponses.stream().map(statusCodeResponse -> HttpUtil.getHttpResponse(statusCodeResponse, String.valueOf(defaultStatusCode), semanticModel, currentModuleName)).forEach(responses::add);
        anydataResponses.stream().map(type -> HttpUtil.getTypeName(type, currentModuleName)).forEach(type -> {
            HttpResponse response = new HttpResponse(String.valueOf(defaultStatusCode), (String)type);
            response.setEnabled(true);
            response.setEditable(true);
            responses.add(response);
        });
        errorResponses.stream().map(type -> HttpUtil.getTypeName(type, currentModuleName)).forEach(type -> {
            HttpResponse response = new HttpResponse(String.valueOf(500), (String)type);
            response.setEnabled(true);
            response.setEditable(true);
            responses.add(response);
        });
        return responses;
    }

    private static boolean isHttpResponse(String type) {
        return type.trim().equals("http:Response");
    }

    private static HttpResponse getHttpResponse(TypeSymbol statusCodeResponseType, String defaultStatusCode, SemanticModel semanticModel, String currentModuleName) {
        String typeName = HttpUtil.getTypeName(statusCodeResponseType, currentModuleName);
        String statusCode = HttpUtil.getResponseCode(statusCodeResponseType, defaultStatusCode, semanticModel);
        if (typeName.contains("}")) {
            return HttpResponse.getAnonResponse(statusCode, "record {|...|}");
        }
        boolean addEditButton = typeName.startsWith(currentModuleName + ":");
        return new HttpResponse(statusCode, typeName, addEditButton);
    }

    public static boolean isSubTypeOfHttpStatusCodeResponse(TypeSymbol typeSymbol, SemanticModel semanticModel) {
        return HttpUtil.isSubTypeOfBallerinaModuleType("StatusCodeResponse", "http", typeSymbol, semanticModel);
    }

    static boolean isSubTypeOfBallerinaModuleType(String type, String moduleName, TypeSymbol typeSymbol, SemanticModel semanticModel) {
        Object t;
        Optional optionalRecordSymbol = semanticModel.types().getTypeByName("ballerina", moduleName, "", type);
        if (optionalRecordSymbol.isPresent() && (t = optionalRecordSymbol.get()) instanceof TypeDefinitionSymbol) {
            TypeDefinitionSymbol recordSymbol = (TypeDefinitionSymbol)t;
            return typeSymbol.subtypeOf(recordSymbol.typeDescriptor());
        }
        return false;
    }

    private static String getResponseCode(TypeSymbol typeSymbol, String defaultCode, SemanticModel semanticModel) {
        for (Map.Entry<String, String> entry : HTTP_CODES.entrySet()) {
            if (!HttpUtil.isSubTypeOfBallerinaModuleType(entry.getKey(), "http", typeSymbol, semanticModel)) continue;
            return entry.getValue();
        }
        if (HttpUtil.isSubTypeOfBallerinaModuleType("DefaultStatusCodeResponse", "http", typeSymbol, semanticModel)) {
            return "default";
        }
        return defaultCode;
    }

    static String getTypeName(TypeSymbol typeSymbol, String currentModuleName) {
        String signature = typeSymbol.signature().trim();
        String[] parts = signature.split("[:/]");
        if (parts.length == 4) {
            return parts[1].equals(currentModuleName) ? parts[3] : parts[1] + ":" + parts[3];
        }
        return signature;
    }

    private static Optional<UnionTypeSymbol> getUnionType(TypeSymbol typeSymbol) {
        if (Objects.isNull(typeSymbol)) {
            return Optional.empty();
        }
        return switch (typeSymbol.typeKind()) {
            case TypeDescKind.UNION -> Optional.of((UnionTypeSymbol)typeSymbol);
            case TypeDescKind.TYPE_REFERENCE -> HttpUtil.getUnionType(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor());
            default -> Optional.empty();
        };
    }

    public static String getStatusCodeResponse(HttpResponse response, List<String> statusCodeResponses, Map<String, String> imports) {
        String statusCodeRes;
        Value name = response.getName();
        if (Objects.nonNull(name) && name.isEnabledWithValue()) {
            String statusCode = response.getStatusCode().getValue();
            String statusCodeRes2 = HTTP_CODES_DES.get(statusCode);
            if (Objects.isNull(statusCodeRes2)) {
                return response.getName().getValue();
            }
            statusCodeResponses.add(HttpUtil.getNewResponseTypeStr(statusCodeRes2, name.getValue(), response.getBody(), response.getHeaders(), imports));
            return response.getName().getValue();
        }
        if (response.getType().isEnabledWithValue()) {
            if (Objects.nonNull(response.getType().getImports())) {
                imports.putAll(response.getType().getImports());
            }
            return response.getType().getValue();
        }
        if (Objects.nonNull(response.getBody()) && response.getBody().isEnabledWithValue()) {
            if (Objects.nonNull(response.getBody().getImports())) {
                imports.putAll(response.getBody().getImports());
            }
            return response.getBody().getValue();
        }
        Value statusCode = response.getStatusCode();
        if (Objects.nonNull(statusCode) && statusCode.isEnabledWithValue() && Objects.nonNull(statusCodeRes = HTTP_CODES_DES.get(statusCode.getValue().trim()))) {
            return "http:" + statusCodeRes;
        }
        return null;
    }

    private static String getNewResponseTypeStr(String statusCodeTypeName, String name, Value body, Value headers, Map<String, String> imports) {
        Object template = "public type %s record {|%n\t*http:%s;".formatted(name, statusCodeTypeName);
        if (Objects.nonNull(body) && body.isEnabledWithValue()) {
            template = (String)template + "\t%s body;%n".formatted(body.getValue());
            if (Objects.nonNull(body.getImports())) {
                imports.putAll(body.getImports());
            }
        }
        if (Objects.nonNull(headers) && headers.isEnabledWithValue()) {
            template = (String)template + "\tmap<%s> headers;%n".formatted(String.join((CharSequence)"|", headers.getValues()));
        }
        template = (String)template + "|};";
        return template;
    }

    static {
        HashMap<String, String> httpCodeMap = new HashMap<String, String>();
        httpCodeMap.put("Continue", "100");
        httpCodeMap.put("SwitchingProtocols", "101");
        httpCodeMap.put("Processing", "102");
        httpCodeMap.put("EarlyHints", "103");
        httpCodeMap.put("Ok", "200");
        httpCodeMap.put("Created", "201");
        httpCodeMap.put("Accepted", "202");
        httpCodeMap.put("NonAuthoritativeInformation", "203");
        httpCodeMap.put("NoContent", "204");
        httpCodeMap.put("ResetContent", "205");
        httpCodeMap.put("PartialContent", "206");
        httpCodeMap.put("MultiStatus", "207");
        httpCodeMap.put("AlreadyReported", "208");
        httpCodeMap.put("IMUsed", "226");
        httpCodeMap.put("MultipleChoices", "300");
        httpCodeMap.put("MovedPermanently", "301");
        httpCodeMap.put("Found", "302");
        httpCodeMap.put("SeeOther", "303");
        httpCodeMap.put("NotModified", "304");
        httpCodeMap.put("UseProxy", "305");
        httpCodeMap.put("TemporaryRedirect", "307");
        httpCodeMap.put("PermanentRedirect", "308");
        httpCodeMap.put("BadRequest", "400");
        httpCodeMap.put("Unauthorized", "401");
        httpCodeMap.put("PaymentRequired", "402");
        httpCodeMap.put("Forbidden", "403");
        httpCodeMap.put("NotFound", "404");
        httpCodeMap.put("MethodNotAllowed", "405");
        httpCodeMap.put("NotAcceptable", "406");
        httpCodeMap.put("ProxyAuthenticationRequired", "407");
        httpCodeMap.put("RequestTimeout", "408");
        httpCodeMap.put("Conflict", "409");
        httpCodeMap.put("Gone", "410");
        httpCodeMap.put("LengthRequired", "411");
        httpCodeMap.put("PreconditionFailed", "412");
        httpCodeMap.put("PayloadTooLarge", "413");
        httpCodeMap.put("UriTooLong", "414");
        httpCodeMap.put("UnsupportedMediaType", "415");
        httpCodeMap.put("RangeNotSatisfiable", "416");
        httpCodeMap.put("ExpectationFailed", "417");
        httpCodeMap.put("MisdirectedRequest", "421");
        httpCodeMap.put("UnprocessableEntity", "422");
        httpCodeMap.put("Locked", "423");
        httpCodeMap.put("FailedDependency", "424");
        httpCodeMap.put("TooEarly", "425");
        httpCodeMap.put("UpgradeRequired", "426");
        httpCodeMap.put("PreconditionRequired", "428");
        httpCodeMap.put("TooManyRequests", "429");
        httpCodeMap.put("RequestHeaderFieldsTooLarge", "431");
        httpCodeMap.put("UnavailableDueToLegalReasons", "451");
        httpCodeMap.put("InternalServerError", "500");
        httpCodeMap.put("NotImplemented", "501");
        httpCodeMap.put("BadGateway", "502");
        httpCodeMap.put("ServiceUnavailable", "503");
        httpCodeMap.put("GatewayTimeout", "504");
        httpCodeMap.put("HttpVersionNotSupported", "505");
        httpCodeMap.put("VariantAlsoNegotiates", "506");
        httpCodeMap.put("InsufficientStorage", "507");
        httpCodeMap.put("LoopDetected", "508");
        httpCodeMap.put("NotExtended", "510");
        httpCodeMap.put("NetworkAuthenticationRequired", "511");
        HTTP_CODES = Collections.unmodifiableMap(httpCodeMap);
        httpCodeMap = new HashMap();
        httpCodeMap.put("100", "Continue");
        httpCodeMap.put("101", "SwitchingProtocols");
        httpCodeMap.put("102", "Processing");
        httpCodeMap.put("103", "EarlyHints");
        httpCodeMap.put("200", "Ok");
        httpCodeMap.put("201", "Created");
        httpCodeMap.put("202", "Accepted");
        httpCodeMap.put("203", "NonAuthoritativeInformation");
        httpCodeMap.put("204", "NoContent");
        httpCodeMap.put("205", "ResetContent");
        httpCodeMap.put("206", "PartialContent");
        httpCodeMap.put("207", "MultiStatus");
        httpCodeMap.put("208", "AlreadyReported");
        httpCodeMap.put("226", "IMUsed");
        httpCodeMap.put("300", "MultipleChoices");
        httpCodeMap.put("301", "MovedPermanently");
        httpCodeMap.put("302", "Found");
        httpCodeMap.put("303", "SeeOther");
        httpCodeMap.put("304", "NotModified");
        httpCodeMap.put("305", "UseProxy");
        httpCodeMap.put("307", "TemporaryRedirect");
        httpCodeMap.put("308", "PermanentRedirect");
        httpCodeMap.put("400", "BadRequest");
        httpCodeMap.put("401", "Unauthorized");
        httpCodeMap.put("402", "PaymentRequired");
        httpCodeMap.put("403", "Forbidden");
        httpCodeMap.put("404", "NotFound");
        httpCodeMap.put("405", "MethodNotAllowed");
        httpCodeMap.put("406", "NotAcceptable");
        httpCodeMap.put("407", "ProxyAuthenticationRequired");
        httpCodeMap.put("408", "RequestTimeOut");
        httpCodeMap.put("409", "Conflict");
        httpCodeMap.put("410", "Gone");
        httpCodeMap.put("411", "LengthRequired");
        httpCodeMap.put("412", "PreconditionFailed");
        httpCodeMap.put("413", "PayloadTooLarge");
        httpCodeMap.put("414", "UriTooLong");
        httpCodeMap.put("415", "UnsupportedMediaType");
        httpCodeMap.put("416", "RangeNotSatisfiable");
        httpCodeMap.put("417", "ExpectationFailed");
        httpCodeMap.put("421", "MisdirectedRequest");
        httpCodeMap.put("422", "UnprocessableEntity");
        httpCodeMap.put("423", "Locked");
        httpCodeMap.put("424", "FailedDependency");
        httpCodeMap.put("425", "TooEarly");
        httpCodeMap.put("426", "UpgradeRequired");
        httpCodeMap.put("428", "PreconditionRequired");
        httpCodeMap.put("429", "TooManyRequests");
        httpCodeMap.put("431", "RequestHeaderFieldsTooLarge");
        httpCodeMap.put("451", "UnavailableDueToLegalReasons");
        httpCodeMap.put("500", "InternalServerError");
        httpCodeMap.put("501", "NotImplemented");
        httpCodeMap.put("502", "BadGateway");
        httpCodeMap.put("503", "ServiceUnavailable");
        httpCodeMap.put("504", "GatewayTimeout");
        httpCodeMap.put("505", "HttpVersionNotSupported");
        httpCodeMap.put("506", "VariantAlsoNegotiates");
        httpCodeMap.put("507", "InsufficientStorage");
        httpCodeMap.put("508", "LoopDetected");
        httpCodeMap.put("510", "NotExtended");
        httpCodeMap.put("511", "NetworkAuthenticationRequired");
        HTTP_CODES_DES = Collections.unmodifiableMap(httpCodeMap);
    }
}

