/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.servicemodelgenerator.extension.util;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationAttachPoint;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.modelgenerator.commons.AnnotationAttachment;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.ServiceDatabaseManager;
import io.ballerina.modelgenerator.commons.ServiceDeclaration;
import io.ballerina.modelgenerator.commons.ServiceTypeFunction;
import io.ballerina.projects.Project;
import io.ballerina.servicemodelgenerator.extension.model.Codedata;
import io.ballerina.servicemodelgenerator.extension.model.DisplayAnnotation;
import io.ballerina.servicemodelgenerator.extension.model.Function;
import io.ballerina.servicemodelgenerator.extension.model.FunctionReturnType;
import io.ballerina.servicemodelgenerator.extension.model.MetaData;
import io.ballerina.servicemodelgenerator.extension.model.Parameter;
import io.ballerina.servicemodelgenerator.extension.model.PropertyTypeMemberInfo;
import io.ballerina.servicemodelgenerator.extension.model.Service;
import io.ballerina.servicemodelgenerator.extension.model.Value;
import io.ballerina.servicemodelgenerator.extension.util.GraphqlUtil;
import io.ballerina.servicemodelgenerator.extension.util.ListenerUtil;
import io.ballerina.servicemodelgenerator.extension.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class ServiceModelUtils {
    public static void updateGenericServiceModel(Service serviceModel, ServiceDeclarationNode serviceNode, SemanticModel semanticModel) {
        String attachPoint = Utils.getPath((NodeList<Node>)serviceNode.absoluteResourcePath());
        if (!attachPoint.isEmpty()) {
            boolean isStringLiteral;
            boolean bl = isStringLiteral = attachPoint.startsWith("\"") && attachPoint.endsWith("\"");
            if (isStringLiteral) {
                Value stringLiteralProperty = serviceModel.getStringLiteralProperty();
                if (Objects.nonNull(stringLiteralProperty)) {
                    stringLiteralProperty.setValue(attachPoint);
                } else {
                    serviceModel.setStringLiteral(ServiceModelUtils.getStringLiteralProperty(attachPoint));
                }
            } else {
                Value basePathProperty = serviceModel.getBasePath();
                if (Objects.nonNull(basePathProperty)) {
                    basePathProperty.setValue(attachPoint);
                } else {
                    serviceModel.setBasePath(ServiceModelUtils.getBasePathProperty(attachPoint));
                }
            }
        }
        boolean isGraphql = serviceModel.getModuleName().equals("graphql");
        List<Function> functionsInSource = serviceNode.members().stream().filter(member -> member instanceof FunctionDefinitionNode).map(member -> Utils.getFunctionModel((FunctionDefinitionNode)member, semanticModel, false, isGraphql, Map.of())).toList();
        ServiceModelUtils.updateServiceInfoNew(serviceModel, functionsInSource);
        serviceModel.setCodedata(new Codedata(serviceNode.lineRange()));
        Utils.populateListenerInfo(serviceModel, serviceNode);
        Utils.updateAnnotationAttachmentProperty(serviceNode, serviceModel);
        if (serviceModel.getModuleName().equals("rabbitmq")) {
            ServiceModelUtils.filterRabbitMqFunctions(serviceModel.getFunctions());
        }
    }

    private static void filterRabbitMqFunctions(List<Function> functions) {
        boolean hasOnMessage = false;
        boolean hasOnRequest = false;
        int onMessageIndex = -1;
        int onRequestIndex = -1;
        for (int i = 0; i < functions.size(); ++i) {
            Function function = functions.get(i);
            if (function.getName().getValue().equals("onMessage")) {
                hasOnMessage = function.isEnabled();
                onMessageIndex = i;
                continue;
            }
            if (!function.getName().getValue().equals("onRequest")) continue;
            hasOnRequest = function.isEnabled();
            onRequestIndex = i;
        }
        if (hasOnMessage) {
            functions.remove(onRequestIndex);
        } else if (hasOnRequest) {
            functions.remove(onMessageIndex);
        }
    }

    private static void updateServiceInfoNew(Service serviceModel, List<Function> functionsInSource) {
        Utils.populateRequiredFunctions(serviceModel);
        boolean isGraphql = serviceModel.getModuleName().equals("graphql");
        serviceModel.getFunctions().forEach(functionModel -> {
            Optional<Function> function = functionsInSource.stream().filter(newFunction -> Utils.isPresent(functionModel, newFunction) && newFunction.getKind().equals(functionModel.getKind())).findFirst();
            functionModel.setEditable(false);
            function.ifPresentOrElse(func -> ServiceModelUtils.updateFunction(functionModel, func, serviceModel), () -> functionModel.setEnabled(false));
        });
        functionsInSource.forEach(funcInSource -> {
            if (serviceModel.getFunctions().stream().noneMatch(newFunction -> Utils.isPresent(funcInSource, newFunction))) {
                if (isGraphql) {
                    GraphqlUtil.updateGraphqlFunctionMetaData(funcInSource);
                    serviceModel.addFunction((Function)funcInSource);
                } else {
                    serviceModel.addFunction((Function)funcInSource);
                    funcInSource.setEditable(false);
                }
            }
        });
    }

    private static void updateFunction(Function target, Function source, Service service) {
        target.setEnabled(source.isEnabled());
        target.setCodedata(source.getCodedata());
        Utils.updateValue(target.getAccessor(), source.getAccessor());
        Utils.updateValue(target.getName(), source.getName());
        List<Parameter> sourceParameters = source.getParameters();
        for (Parameter targetParameter : target.getParameters()) {
            AtomicReference parameter = new AtomicReference(Optional.empty());
            sourceParameters.removeIf(sourceParam -> {
                if (ServiceModelUtils.isEqual(targetParameter.getType(), sourceParam.getType())) {
                    parameter.set(Optional.of(sourceParam));
                    return true;
                }
                return false;
            });
            Optional<Parameter> foundSourceParam = parameter.get();
            if (foundSourceParam.isEmpty()) {
                targetParameter.setEnabled(false);
            }
            foundSourceParam.ifPresent(value -> ServiceModelUtils.updateParameter(targetParameter, value));
        }
        Utils.updateValue(target.getReturnType(), source.getReturnType());
        Value requiredFunctions = service.getProperty("requiredFunctions");
        if (Objects.nonNull(requiredFunctions) && source.isEnabled() && requiredFunctions.getItems().contains(source.getName().getValue())) {
            requiredFunctions.setValue(source.getName().getValue());
        }
    }

    private static boolean isEqual(Value target, Value source) {
        return Objects.nonNull(target) && target.getValue().equals(source.getValue());
    }

    private static void updateParameter(Parameter target, Parameter source) {
        target.setEnabled(source.isEnabled());
        target.setKind(source.getKind());
        Utils.updateValue(target.getType(), source.getType());
        Utils.updateValue(target.getName(), source.getName());
    }

    public static Optional<Service> getEmptyServiceModel(String moduleName) {
        if (moduleName.equals("http")) {
            return ServiceModelUtils.getHttpService();
        }
        Optional serviceDeclaration = ServiceDatabaseManager.getInstance().getServiceDeclaration(moduleName);
        if (serviceDeclaration.isEmpty()) {
            return Optional.empty();
        }
        ServiceDeclaration serviceTemplate = (ServiceDeclaration)serviceDeclaration.get();
        ServiceDeclaration.Package pkg = serviceTemplate.packageInfo();
        String protocol = ServiceModelUtils.getProtocol(moduleName);
        String label = serviceTemplate.displayName();
        String documentation = "Add the service documentation";
        String icon = CommonUtils.generateIcon((String)pkg.org(), (String)pkg.name(), (String)pkg.version());
        LinkedHashMap<String, Value> properties = new LinkedHashMap<String, Value>();
        Service.ServiceModelBuilder serviceBuilder = new Service.ServiceModelBuilder();
        serviceBuilder.setId(String.valueOf(pkg.packageId())).setName(label).setType(moduleName).setDisplayName(label).setDescription(documentation).setDisplayAnnotation(new DisplayAnnotation(label, icon)).setModuleName(moduleName).setOrgName(pkg.org()).setVersion(pkg.version()).setPackageName(pkg.name()).setListenerProtocol(protocol).setIcon(icon).setProperties(properties).setFunctions(new ArrayList<Function>());
        Service service = serviceBuilder.build();
        properties.put("listener", ServiceModelUtils.getListenersProperty(protocol, serviceTemplate.listenerKind()));
        properties.put("serviceType", ServiceModelUtils.getTypeDescriptorProperty(serviceTemplate, pkg.packageId()));
        if (serviceTemplate.optionalAbsoluteResourcePath() == 0) {
            properties.put("basePath", ServiceModelUtils.getBasePathProperty(serviceTemplate));
        }
        if (serviceTemplate.optionalStringLiteral() == 0) {
            properties.put("stringLiteral", ServiceModelUtils.getStringLiteral(serviceTemplate));
        }
        List annotationAttachments = ServiceDatabaseManager.getInstance().getAnnotationAttachments(pkg.packageId());
        for (AnnotationAttachment annotationAttachment : annotationAttachments) {
            if (!annotationAttachment.attachmentPoints().contains(AnnotationAttachPoint.SERVICE)) continue;
            String key = "annot" + annotationAttachment.annotName();
            properties.put(key, ServiceModelUtils.getAnnotationAttachmentProperty(annotationAttachment));
        }
        return Optional.of(service);
    }

    public static Optional<Service> getServiceModelWithFunctions(String moduleName, String serviceType) {
        Optional<Service> serviceOptional = ServiceModelUtils.getEmptyServiceModel(moduleName);
        if (serviceOptional.isEmpty() || serviceOptional.get().getPackageName().equals("http")) {
            return serviceOptional;
        }
        Service service = serviceOptional.get();
        int packageId = Integer.parseInt(service.getId());
        ServiceDatabaseManager.getInstance().getMatchingServiceTypeFunctions(packageId, serviceType).forEach(function -> service.getFunctions().add(ServiceModelUtils.getFunction(function)));
        service.getServiceType().setValue(serviceType);
        return Optional.of(service);
    }

    public static void populateRequiredFunctionsForServiceType(Service service) {
        int packageId = Integer.parseInt(service.getId());
        String serviceTypeName = Objects.nonNull(service.getServiceType()) ? service.getServiceType().getValue() : "Service";
        ServiceDatabaseManager.getInstance().getMatchingServiceTypeFunctions(packageId, serviceTypeName).forEach(function -> service.getFunctions().add(ServiceModelUtils.getFunction(function)));
    }

    private static Function getFunction(ServiceTypeFunction function) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (ServiceTypeFunction.ServiceTypeFunctionParameter parameter : function.parameters()) {
            parameters.add(ServiceModelUtils.getParameter(parameter));
        }
        Value.ValueBuilder functionName = new Value.ValueBuilder();
        functionName.metadata(function.name(), function.description()).setCodedata(new Codedata("FUNCTION_NAME")).value(function.name()).valueType("IDENTIFIER").setValueTypeConstraint("string").setPlaceholder(function.name()).enabled(true);
        Value.ValueBuilder returnValue = new Value.ValueBuilder();
        returnValue.metadata("Return Type", "The return type of the function").value(function.returnType()).valueType("TYPE").setPlaceholder(function.returnType()).editable(function.returnTypeEditable() == 1).enabled(true).isType(true).optional(true);
        FunctionReturnType functionReturnType = new FunctionReturnType(returnValue.build());
        functionReturnType.setHasError(function.returnError() == 1);
        Function.FunctionBuilder functionBuilder = new Function.FunctionBuilder();
        functionBuilder.setMetadata(new MetaData(function.name(), function.description())).kind(function.kind()).enabled(function.enable() == 1).editable(true).name(functionName.build()).returnType(functionReturnType).parameters(parameters);
        if (function.kind().equals("RESOURCE")) {
            Value.ValueBuilder accessor = new Value.ValueBuilder().metadata("Accessor", "The accessor of the resource function").setCodedata(new Codedata("ACCESSOR")).value(function.accessor()).valueType("IDENTIFIER").setValueTypeConstraint("string").setPlaceholder(function.accessor()).enabled(true).editable(false).isType(false).optional(false).setAdvanced(false);
            functionBuilder.accessor(accessor.build());
        }
        return functionBuilder.build();
    }

    private static Parameter getParameter(ServiceTypeFunction.ServiceTypeFunctionParameter parameter) {
        Value.ValueBuilder parameterName = new Value.ValueBuilder();
        parameterName.setMetadata(new MetaData(parameter.name(), parameter.description())).setCodedata(new Codedata("PARAMETER_NAME")).value(parameter.name()).valueType("IDENTIFIER").setPlaceholder(parameter.name()).enabled(true).editable(parameter.nameEditable() == 1);
        Value.ValueBuilder parameterType = new Value.ValueBuilder();
        parameterType.setMetadata(new MetaData("Type", "The type of the parameter")).value(parameter.type()).valueType("TYPE").setPlaceholder(parameter.type()).enabled(true).editable(parameter.typeEditable() == 1).isType(true).optional(true);
        Value.ValueBuilder parameterDefaultValue = new Value.ValueBuilder();
        parameterDefaultValue.setMetadata(new MetaData("Default Value", "The default value of the parameter")).value(parameter.defaultValue()).valueType("EXPRESSION").setPlaceholder(parameter.defaultValue()).enabled(true).editable(true).optional(true);
        Parameter.Builder parameterBuilder = new Parameter.Builder();
        parameterBuilder.metadata(new MetaData(parameter.name(), parameter.description())).kind(parameter.kind()).type(parameterType.build()).name(parameterName.build()).defaultValue(parameterDefaultValue.build()).enabled(true).editable(true).optional(parameter.kind().equals("OPTIONAL")).advanced(false).httpParamType(null);
        return parameterBuilder.build();
    }

    private static Value getTypeDescriptorProperty(ServiceDeclaration template, int packageId) {
        List serviceTypes = ServiceDatabaseManager.getInstance().getServiceTypes(packageId);
        String value = "";
        if (serviceTypes.size() == 1) {
            value = (String)serviceTypes.getFirst();
        }
        ArrayList<String> items = new ArrayList<String>();
        items.add("");
        items.addAll(serviceTypes);
        Value.ValueBuilder valueBuilder = new Value.ValueBuilder();
        valueBuilder.setMetadata(new MetaData(template.typeDescriptorLabel(), template.typeDescriptorDescription())).setCodedata(new Codedata("SERVICE_TYPE")).value(value).setItems(items).valueType("SINGLE_SELECT").setValueTypeConstraint("string").setPlaceholder(template.typeDescriptorDefaultValue()).optional(false).setAdvanced(false).enabled(template.optionalTypeDescriptor() == 0).editable(true).isType(false).setAddNewButton(false);
        return valueBuilder.build();
    }

    public static Value getStringLiteralProperty(String value) {
        Value.ValueBuilder valueBuilder = new Value.ValueBuilder();
        valueBuilder.setMetadata(new MetaData("String Literal", "The string literal of the service")).setCodedata(new Codedata("STRING_LITERAL")).value(value).setValues(new ArrayList<String>()).valueType("EXPRESSION").setValueTypeConstraint("string").setPlaceholder("\"/path\"").optional(false).setAdvanced(false).enabled(true).editable(true).isType(false).setAddNewButton(false);
        return valueBuilder.build();
    }

    private static Value getStringLiteral(ServiceDeclaration template) {
        Value.ValueBuilder valueBuilder = new Value.ValueBuilder();
        valueBuilder.setMetadata(new MetaData(template.stringLiteralLabel(), template.stringLiteralDescription())).setCodedata(new Codedata("STRING_LITERAL")).value("").setValues(new ArrayList<String>()).valueType("EXPRESSION").setValueTypeConstraint("string").setPlaceholder(template.stringLiteralDefaultValue()).optional(false).setAdvanced(false).enabled(true).editable(true).isType(false).setAddNewButton(false);
        return valueBuilder.build();
    }

    public static Value getBasePathProperty(String value) {
        Value.ValueBuilder valueBuilder = new Value.ValueBuilder();
        valueBuilder.setMetadata(new MetaData("Base Path", "The base path of the service")).setCodedata(new Codedata("SERVICE_BASE_PATH")).value(value).setValues(new ArrayList<String>()).valueType("IDENTIFIER").setValueTypeConstraint("string").setPlaceholder("/").optional(false).setAdvanced(false).enabled(true).editable(true).isType(false).setAddNewButton(false);
        return valueBuilder.build();
    }

    private static Value getBasePathProperty(ServiceDeclaration template) {
        Value.ValueBuilder valueBuilder = new Value.ValueBuilder();
        valueBuilder.setMetadata(new MetaData(template.absoluteResourcePathLabel(), template.absoluteResourcePathDescription())).setCodedata(new Codedata("SERVICE_BASE_PATH")).value(template.absoluteResourcePathDefaultValue()).setValues(new ArrayList<String>()).valueType("IDENTIFIER").setValueTypeConstraint("string").setPlaceholder(template.absoluteResourcePathDefaultValue()).optional(false).setAdvanced(false).enabled(true).editable(true).isType(false).setAddNewButton(false);
        return valueBuilder.build();
    }

    private static Value getAnnotationAttachmentProperty(AnnotationAttachment attachment) {
        String typeName = attachment.typeName();
        String[] split = typeName.split(":");
        if (split.length > 1) {
            typeName = split[1];
        }
        PropertyTypeMemberInfo propertyTypeMemberInfo = new PropertyTypeMemberInfo(typeName, attachment.packageInfo(), "RECORD_TYPE", true);
        Codedata codedata = new Codedata("ANNOTATION_ATTACHMENT");
        codedata.setOriginalName(attachment.annotName());
        Value.ValueBuilder valueBuilder = new Value.ValueBuilder().setMetadata(new MetaData(attachment.displayName(), attachment.description())).setCodedata(codedata).value("").setValues(new ArrayList<String>()).valueType("EXPRESSION").setValueTypeConstraint(attachment.typeName()).setPlaceholder("{}").optional(true).setAdvanced(true).enabled(true).editable(true).isType(false).setAddNewButton(false).setMembers(List.of(propertyTypeMemberInfo));
        return valueBuilder.build();
    }

    private static Value getListenersProperty(String protocol, String valueType) {
        boolean isMultiple = valueType.equals("MULTIPLE_SELECT");
        MetaData metaData = isMultiple ? new MetaData("Listeners", "The Listeners to be bound with the service") : new MetaData("Listener", "The Listener to be bound with the service");
        Value.ValueBuilder valueBuilder = new Value.ValueBuilder();
        valueBuilder.setMetadata(metaData).setCodedata(new Codedata("LISTENER")).value("").setValues(new ArrayList<String>()).valueType(valueType).setValueTypeConstraint(protocol + ":Listener").setPlaceholder("").optional(false).setAdvanced(false).enabled(true).editable(true).isType(false).setAddNewButton(isMultiple);
        return valueBuilder.build();
    }

    public static String getProtocol(String moduleName) {
        String[] split = moduleName.split("\\.");
        return split[split.length - 1];
    }

    public static Optional<Service> getHttpService() {
        Optional<Service> optional;
        InputStream resourceStream = ServiceModelUtils.class.getClassLoader().getResourceAsStream("services/http.json");
        if (resourceStream == null) {
            return Optional.empty();
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
        try {
            optional = Optional.of((Service)new Gson().fromJson(reader, Service.class));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        reader.close();
        return optional;
    }

    public static void updateListenerItems(String moduleName, SemanticModel semanticModel, Project project, Service serviceModel) {
        Set<String> listeners = ListenerUtil.getCompatibleListeners(moduleName, semanticModel, project);
        List<String> allValues = serviceModel.getListener().getValues();
        if (Objects.isNull(allValues) || allValues.isEmpty()) {
            listeners.add(serviceModel.getListener().getValue());
        } else {
            listeners.addAll(allValues);
        }
        Value listener = serviceModel.getListener();
        if (!listeners.isEmpty()) {
            listener.setItems(listeners.stream().toList());
        }
    }
}

