/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.diagramutil;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.projects.Document;
import org.ballerinalang.diagramutil.SyntaxTreeMapGenerator;

public final class DiagramUtil {
    private DiagramUtil() {
    }

    public static JsonElement getSyntaxTreeJSON(Document srcFile, SemanticModel semanticModel) {
        JsonObject syntaxTreeJson;
        try {
            SyntaxTreeMapGenerator mapGenerator = new SyntaxTreeMapGenerator(semanticModel);
            SyntaxTree syntaxTree = srcFile.syntaxTree();
            ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
            syntaxTreeJson = mapGenerator.transform(modulePartNode);
        }
        catch (NullPointerException e) {
            syntaxTreeJson = new JsonObject();
        }
        return syntaxTreeJson;
    }

    public static JsonElement getSyntaxTreeJSON(NonTerminalNode node, SemanticModel semanticModel) {
        JsonObject syntaxTreeJson;
        try {
            SyntaxTreeMapGenerator mapGenerator = new SyntaxTreeMapGenerator(semanticModel);
            syntaxTreeJson = mapGenerator.transformSyntaxNode((Node)(node.kind() == SyntaxKind.LIST ? node.parent() : node));
        }
        catch (Throwable e) {
            syntaxTreeJson = new JsonObject();
        }
        return syntaxTreeJson;
    }

    public static JsonElement getSyntaxTreeJSON(NonTerminalNode node) {
        JsonObject syntaxTreeJson;
        try {
            SyntaxTreeMapGenerator mapGenerator = new SyntaxTreeMapGenerator();
            syntaxTreeJson = mapGenerator.transformSyntaxNode((Node)(node.kind() == SyntaxKind.LIST ? node.parent() : node));
        }
        catch (Throwable e) {
            syntaxTreeJson = new JsonObject();
        }
        return syntaxTreeJson;
    }

    public static JsonElement getClassDefinitionSyntaxJson(ClassDefinitionNode classDefinitionNode, SemanticModel semanticModel) {
        JsonObject syntaxTreeJson;
        try {
            SyntaxTreeMapGenerator mapGenerator = new SyntaxTreeMapGenerator(semanticModel);
            syntaxTreeJson = mapGenerator.transform(classDefinitionNode);
        }
        catch (NullPointerException e) {
            syntaxTreeJson = new JsonObject();
        }
        return syntaxTreeJson;
    }

    public static JsonElement getTypeDefinitionSyntaxJson(TypeDefinitionNode typeDefinitionNode, SemanticModel semanticModel) {
        JsonObject syntaxTreeJson;
        try {
            SyntaxTreeMapGenerator mapGenerator = new SyntaxTreeMapGenerator(semanticModel);
            syntaxTreeJson = (JsonElement)mapGenerator.transform(typeDefinitionNode);
        }
        catch (NullPointerException e) {
            syntaxTreeJson = new JsonObject();
        }
        return syntaxTreeJson;
    }
}

