/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.diagramutil.connector.generator;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.IncludedRecordParameterNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MarkdownCodeBlockNode;
import io.ballerina.compiler.syntax.tree.MarkdownCodeLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ResourcePathParameterNode;
import io.ballerina.compiler.syntax.tree.RestParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.diagramutil.connector.models.connector.Type;
import org.ballerinalang.diagramutil.connector.models.connector.types.InclusionType;
import org.ballerinalang.diagramutil.connector.models.connector.types.PathParamType;

public final class GeneratorUtils {
    private GeneratorUtils() {
    }

    public static String getDocCodeBlockString(MarkdownCodeBlockNode markdownCodeBlockNode) {
        StringBuilder doc = new StringBuilder();
        doc.append(markdownCodeBlockNode.startBacktick().toString());
        markdownCodeBlockNode.langAttribute().ifPresent(doc::append);
        for (MarkdownCodeLineNode codeLineNode : markdownCodeBlockNode.codeLines()) {
            doc.append(codeLineNode.codeDescription().toString());
        }
        doc.append(markdownCodeBlockNode.endBacktick().toString());
        return doc.toString();
    }

    public static String getDocFromMetadata(Optional<MetadataNode> optionalMetadataNode) {
        MarkdownDocumentationNode docLines;
        if (optionalMetadataNode.isEmpty()) {
            return "";
        }
        StringBuilder doc = new StringBuilder();
        MarkdownDocumentationNode markdownDocumentationNode = docLines = optionalMetadataNode.get().documentationString().isPresent() ? (MarkdownDocumentationNode)optionalMetadataNode.get().documentationString().get() : null;
        if (docLines != null) {
            for (Node docLine : docLines.documentationLines()) {
                if (docLine instanceof MarkdownDocumentationLineNode) {
                    MarkdownDocumentationLineNode markdownDocLine = (MarkdownDocumentationLineNode)docLine;
                    doc.append(!markdownDocLine.documentElements().isEmpty() ? GeneratorUtils.getDocLineString((NodeList<Node>)markdownDocLine.documentElements()) : "\n");
                    continue;
                }
                if (!(docLine instanceof MarkdownCodeBlockNode)) break;
                MarkdownCodeBlockNode markdownCodeBlock = (MarkdownCodeBlockNode)docLine;
                doc.append(GeneratorUtils.getDocCodeBlockString(markdownCodeBlock));
            }
        }
        return doc.toString();
    }

    public static Type getReturnParameter(ReturnTypeDescriptorNode returnTypeDescriptorNode, Optional<MetadataNode> optionalMetadataNode, SemanticModel semanticModel) {
        Optional<Type> optionalParam = Type.fromSyntaxNode(returnTypeDescriptorNode.type(), semanticModel);
        if (optionalParam.isPresent()) {
            Type parameter = optionalParam.get();
            parameter.displayAnnotation = GeneratorUtils.getDisplayAnnotationFromAnnotationsList((NodeList<AnnotationNode>)returnTypeDescriptorNode.annotations());
            parameter.documentation = GeneratorUtils.getParameterDocFromMetadataList("return", optionalMetadataNode);
            return parameter;
        }
        return null;
    }

    public static String getDocLineString(NodeList<Node> documentElements) {
        if (documentElements.isEmpty()) {
            return null;
        }
        StringBuilder doc = new StringBuilder();
        for (Node docNode : documentElements) {
            doc.append(docNode.toString());
        }
        return doc.toString();
    }

    public static String getParameterDocFromMetadataList(String parameterName, Optional<MetadataNode> optionalMetadataNode) {
        if (optionalMetadataNode.isEmpty()) {
            return null;
        }
        MarkdownDocumentationNode docLines = optionalMetadataNode.get().documentationString().isPresent() ? (MarkdownDocumentationNode)optionalMetadataNode.get().documentationString().get() : null;
        StringBuilder parameterDoc = new StringBuilder();
        if (docLines != null) {
            boolean lookForMoreLines = false;
            for (Node docLine : docLines.documentationLines()) {
                if (docLine instanceof MarkdownParameterDocumentationLineNode) {
                    MarkdownParameterDocumentationLineNode markdownParameterDocumentationLineNode = (MarkdownParameterDocumentationLineNode)docLine;
                    if (markdownParameterDocumentationLineNode.parameterName().text().equals(parameterName)) {
                        parameterDoc.append(GeneratorUtils.getDocLineString((NodeList<Node>)((MarkdownParameterDocumentationLineNode)docLine).documentElements()));
                        lookForMoreLines = true;
                        continue;
                    }
                    lookForMoreLines = false;
                    continue;
                }
                if (!lookForMoreLines || !(docLine instanceof MarkdownDocumentationLineNode)) continue;
                MarkdownDocumentationLineNode markdownDocLine = (MarkdownDocumentationLineNode)docLine;
                parameterDoc.append(GeneratorUtils.getDocLineString((NodeList<Node>)markdownDocLine.documentElements()));
            }
        }
        return parameterDoc.toString();
    }

    public static Map<String, String> getDisplayAnnotationFromAnnotationsList(NodeList<AnnotationNode> annotations) {
        HashMap<String, String> displayAnnotation = new HashMap<String, String>();
        for (AnnotationNode annotation : annotations) {
            SimpleNameReferenceNode simpleNameRef;
            Node annotReference = annotation.annotReference();
            if (annotReference.kind() != SyntaxKind.SIMPLE_NAME_REFERENCE || !(simpleNameRef = (SimpleNameReferenceNode)annotReference).name().text().equals("display") || !annotation.annotValue().isPresent()) continue;
            for (MappingFieldNode fieldNode : ((MappingConstructorExpressionNode)annotation.annotValue().get()).fields()) {
                ExpressionNode valueNode;
                String fieldName;
                SpecificFieldNode specificField;
                if (fieldNode.kind() != SyntaxKind.SPECIFIC_FIELD || (specificField = (SpecificFieldNode)fieldNode).fieldName().kind() != SyntaxKind.IDENTIFIER_TOKEN || !(fieldName = ((IdentifierToken)specificField.fieldName()).text()).equals("label") && !fieldName.equals("iconPath") || !((SpecificFieldNode)fieldNode).valueExpr().isPresent() || !((valueNode = (ExpressionNode)((SpecificFieldNode)fieldNode).valueExpr().get()) instanceof BasicLiteralNode)) continue;
                BasicLiteralNode basicLiteralNode = (BasicLiteralNode)valueNode;
                String fieldValue = basicLiteralNode.literalToken().text();
                if (fieldValue.startsWith("\"") && fieldValue.endsWith("\"")) {
                    fieldValue = fieldValue.substring(1, fieldValue.length() - 1);
                }
                displayAnnotation.put(fieldName, fieldValue);
            }
        }
        return displayAnnotation;
    }

    public static List<PathParamType> getPathParameters(NodeList<Node> pathParamNodes) {
        ArrayList<PathParamType> parameters = new ArrayList<PathParamType>();
        for (Node pathParamNode : pathParamNodes) {
            switch (pathParamNode.kind()) {
                case IDENTIFIER_TOKEN: {
                    IdentifierToken token = (IdentifierToken)pathParamNode;
                    PathParamType identifierParam = new PathParamType(token.toString().trim(), "token");
                    parameters.add(identifierParam);
                    break;
                }
                case RESOURCE_PATH_SEGMENT_PARAM: {
                    ResourcePathParameterNode pathSegmentParam = (ResourcePathParameterNode)pathParamNode;
                    if (!pathSegmentParam.paramName().isPresent()) break;
                    PathParamType segmentParam = new PathParamType(((Token)pathSegmentParam.paramName().get()).text(), pathSegmentParam.typeDescriptor().toString().trim());
                    parameters.add(segmentParam);
                    break;
                }
                case RESOURCE_PATH_REST_PARAM: {
                    ResourcePathParameterNode pathRestParam = (ResourcePathParameterNode)pathParamNode;
                    if (!pathRestParam.paramName().isPresent()) break;
                    PathParamType restParam = new PathParamType(((Token)pathRestParam.paramName().get()).text(), pathRestParam.typeDescriptor().toString().trim(), true);
                    parameters.add(restParam);
                    break;
                }
            }
        }
        return parameters;
    }

    public static List<Type> getFunctionParameters(SeparatedNodeList<ParameterNode> parameterNodes, Optional<MetadataNode> optionalMetadataNode, SemanticModel semanticModel) {
        ArrayList<Type> parameters = new ArrayList<Type>();
        for (ParameterNode parameterNode : parameterNodes) {
            switch (parameterNode.kind()) {
                case REQUIRED_PARAM: {
                    RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameterNode;
                    Optional<Type> optionalParam = Type.fromSyntaxNode(requiredParameterNode.typeName(), semanticModel);
                    if (optionalParam.isEmpty()) break;
                    Type param = optionalParam.get();
                    param.name = requiredParameterNode.paramName().isPresent() ? ((Token)requiredParameterNode.paramName().get()).text() : null;
                    param.displayAnnotation = GeneratorUtils.getDisplayAnnotationFromAnnotationsList((NodeList<AnnotationNode>)requiredParameterNode.annotations());
                    param.documentation = GeneratorUtils.getParameterDocFromMetadataList(param.name, optionalMetadataNode);
                    parameters.add(param);
                    break;
                }
                case DEFAULTABLE_PARAM: {
                    DefaultableParameterNode defaultableParameter = (DefaultableParameterNode)parameterNode;
                    Optional<Type> optionalParam = Type.fromSyntaxNode(defaultableParameter.typeName(), semanticModel);
                    if (optionalParam.isEmpty()) break;
                    Type param = optionalParam.get();
                    param.name = defaultableParameter.paramName().isPresent() ? ((Token)defaultableParameter.paramName().get()).text() : "";
                    param.displayAnnotation = GeneratorUtils.getDisplayAnnotationFromAnnotationsList((NodeList<AnnotationNode>)defaultableParameter.annotations());
                    param.defaultable = true;
                    param.defaultValue = defaultableParameter.expression().toString();
                    param.documentation = GeneratorUtils.getParameterDocFromMetadataList(param.name, optionalMetadataNode);
                    parameters.add(param);
                    break;
                }
                case INCLUDED_RECORD_PARAM: {
                    IncludedRecordParameterNode includedRecord = (IncludedRecordParameterNode)parameterNode;
                    Optional<Type> optionalParam = Type.fromSyntaxNode(includedRecord.typeName(), semanticModel);
                    if (optionalParam.isEmpty()) break;
                    Type param = new InclusionType(optionalParam.get());
                    param.name = includedRecord.paramName().isPresent() ? ((Token)includedRecord.paramName().get()).text() : "";
                    param.displayAnnotation = GeneratorUtils.getDisplayAnnotationFromAnnotationsList((NodeList<AnnotationNode>)includedRecord.annotations());
                    param.documentation = GeneratorUtils.getParameterDocFromMetadataList(param.name, optionalMetadataNode);
                    parameters.add(param);
                    break;
                }
                case REST_PARAM: {
                    RestParameterNode restParameterNode = (RestParameterNode)parameterNode;
                    Optional<Type> optionalParam = Type.fromSyntaxNode(restParameterNode.typeName(), semanticModel);
                    if (optionalParam.isEmpty()) break;
                    Type param = optionalParam.get();
                    param.name = restParameterNode.paramName().isPresent() ? ((Token)restParameterNode.paramName().get()).text() : null;
                    param.displayAnnotation = GeneratorUtils.getDisplayAnnotationFromAnnotationsList((NodeList<AnnotationNode>)restParameterNode.annotations());
                    param.documentation = GeneratorUtils.getParameterDocFromMetadataList(param.name, optionalMetadataNode);
                    param.setRestType(true);
                    parameters.add(param);
                    break;
                }
            }
        }
        return parameters;
    }

    public static Map<String, String> getDisplayAnnotationFromMetadataNode(Optional<MetadataNode> optionalMetadataNode) {
        Map<String, String> displayAnnotation = new HashMap<String, String>();
        if (optionalMetadataNode.isPresent()) {
            displayAnnotation = GeneratorUtils.getDisplayAnnotationFromAnnotationsList((NodeList<AnnotationNode>)optionalMetadataNode.get().annotations());
        }
        return displayAnnotation;
    }
}

