/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.bal.tool;

import io.ballerina.tools.diagnostics.DiagnosticSeverity;

public class Constants {
    public static final String TAGS = "tags";
    public static final String OPERATIONS = "operations";
    public static final String NULLABLE = "nullable";
    public static final String CLIENT_METHODS = "clientMethods";
    public static final String LICENSE = "license";
    public static final String TRUE = "true";
    public static final String MODE = "mode";
    public static final String CLIENT = "client";
    public static final String CACHE_FILE = "openapi-cache.txt";
    public static final String STATUS_CODE_BINDING = "statusCodeBinding";
    public static final String MOCK = "mock";
    public static final String SINGLE_FILE = "singleFile";
    public static final String IS_SANITIZED_OAS = "isUsingSanitizedOas";

    public static enum DiagnosticMessages {
        LICENSE_PATH_BLANK("OAS_CLIENT_01", "given license file path is an empty string.", DiagnosticSeverity.WARNING),
        ERROR_WHILE_READING_LICENSE_FILE("OAS_CLIENT_02", "unexpected error occurred while reading the license", DiagnosticSeverity.ERROR),
        ERROR_WHILE_GENERATING_CLIENT("OAS_CLIENT_03", "unexpected error occurred while generating the client", DiagnosticSeverity.ERROR),
        PARSER_ERROR("OAS_CLIENT_04", "", DiagnosticSeverity.ERROR),
        UNEXPECTED_EXCEPTIONS("OAS_CLIENT_05", "unexpected error occurred while reading the contract", DiagnosticSeverity.ERROR),
        EMPTY_CONTRACT_PATH("OAS_CLIENT_06", "given openapi contract file path is an empty string.", DiagnosticSeverity.ERROR),
        WARNING_FOR_OTHER_GENERATION("OAS_CLIENT_07", "`%s` mode does not support for bal build code generation.", DiagnosticSeverity.ERROR),
        WARNING_FOR_UNSUPPORTED_CONTRACT("OAS_CLIENT_08", "unsupported contract type. please use .yml, .yaml, or .json files for code generation.", DiagnosticSeverity.ERROR),
        INVALID_CONTRACT_PATH("OAS_CLIENT_09", "invalid openapi contract file path.", DiagnosticSeverity.ERROR),
        TOML_UPDATED_WITH_CLIENT_NATIVE_DEPENDENCY("OAS_CLIENT_10", "the 'Ballerina.toml' file is updated with the OpenAPI client native dependency.", DiagnosticSeverity.INFO),
        TOML_ALREADY_UPDATED_WITH_CLIENT_NATIVE_DEPENDENCY("OAS_CLIENT_10", "the 'Ballerina.toml' file is already updated with the latest OpenAPI client native dependency.", DiagnosticSeverity.INFO),
        CLIENT_NATIVE_DEPENDENCY_VERSION_MISMATCH("OAS_CLIENT_10", "the 'Ballerina.toml' file is already updated with the OpenAPI client native dependency but the version is different from the current version. Please remove the existing dependency and try again.", DiagnosticSeverity.ERROR),
        ERROR_WHILE_UPDATING_TOML("OAS_CLIENT_11", "error occurred when updating Ballerina.toml file with the client native dependency.", DiagnosticSeverity.ERROR),
        OPENAPI_EXCEPTION("OAS_CLIENT_12", "exception occurred while reading the openapi contract: %s", DiagnosticSeverity.ERROR),
        CONTRACT_PATH_NOT_PROVIDED("OAS_CLIENT_13", "OpenAPI file path is not provided.", DiagnosticSeverity.ERROR);

        private final String code;
        private final String description;
        private final DiagnosticSeverity severity;

        private DiagnosticMessages(String code, String description, DiagnosticSeverity severity) {
            this.code = code;
            this.description = description;
            this.severity = severity;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public DiagnosticSeverity getSeverity() {
            return this.severity;
        }
    }
}

