/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.diagnostics;

import io.ballerina.c2c.util.ListenerInfo;
import io.ballerina.c2c.util.ProjectServiceInfo;
import io.ballerina.c2c.util.ResourceInfo;
import io.ballerina.c2c.util.ServiceInfo;
import io.ballerina.projects.Project;
import io.ballerina.toml.api.Toml;
import io.ballerina.toml.semantic.ast.TomlLongValueNode;
import io.ballerina.toml.semantic.ast.TomlStringValueNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class TomlDiagnosticChecker {
    private final Project project;

    public TomlDiagnosticChecker(Project project) {
        this.project = project;
    }

    public List<Diagnostic> validateTomlWithSource(Toml toml) {
        ArrayList<Diagnostic> diagnosticInfoList = new ArrayList<Diagnostic>();
        if (toml == null) {
            return Collections.emptyList();
        }
        ProjectServiceInfo projectService = new ProjectServiceInfo(this.project);
        Optional ready = toml.getTable("cloud.deployment.probes.readiness");
        ready.ifPresent(value -> diagnosticInfoList.addAll(this.validateProbe(projectService, (Toml)value, ProbeType.READINESS)));
        Optional live = toml.getTable("cloud.deployment.probes.liveness");
        live.ifPresent(value -> diagnosticInfoList.addAll(this.validateProbe(projectService, (Toml)value, ProbeType.LIVENESS)));
        return diagnosticInfoList;
    }

    private List<Diagnostic> validateProbe(ProjectServiceInfo projectServiceInfo, Toml probe, ProbeType type) {
        ArrayList<Diagnostic> diagnosticInfos = new ArrayList<Diagnostic>();
        TomlNodeLocation tableLocation = probe.rootNode().location();
        if (probe.get("port").isEmpty()) {
            TomlDiagnostic portDiag = this.getTomlDiagnostic(tableLocation, "C2C005", "missing.probe.port", DiagnosticSeverity.ERROR, "Missing " + type.getValue() + " Port");
            return Collections.singletonList(portDiag);
        }
        if (probe.get("path").isEmpty()) {
            TomlDiagnostic portDiag = this.getTomlDiagnostic(tableLocation, "C2C006", "missing.probe.path", DiagnosticSeverity.ERROR, "Missing " + type.getValue() + " Path");
            return Collections.singletonList(portDiag);
        }
        TomlValueNode portNode = (TomlValueNode)probe.get("port").get();
        TomlValueNode pathNode = (TomlValueNode)probe.get("path").get();
        long port = (Long)((TomlLongValueNode)portNode).getValue();
        String path = (String)((TomlStringValueNode)pathNode).getValue();
        List<ServiceInfo> serviceList = projectServiceInfo.getServiceList();
        if (!this.isListenerPortValid(port, serviceList)) {
            TomlDiagnostic portDiag = this.getTomlDiagnostic(portNode.location(), "C2C001", "error.invalid.port", DiagnosticSeverity.ERROR, "Invalid " + type.getValue() + " Port");
            TomlDiagnostic pathDiag = this.getTomlDiagnostic(pathNode.location(), "C2C002", "error.invalid.path", DiagnosticSeverity.ERROR, "Invalid " + type.getValue() + " Path");
            diagnosticInfos.add((Diagnostic)portDiag);
            diagnosticInfos.add((Diagnostic)pathDiag);
            return diagnosticInfos;
        }
        for (ServiceInfo serviceInfo : serviceList) {
            List<ListenerInfo> listeners = serviceInfo.getListeners();
            for (ListenerInfo listener : listeners) {
                int serviceListenerPort = listener.getPort();
                if ((long)serviceListenerPort != port) continue;
                String serviceName = serviceInfo.getServicePath().trim();
                if (!TomlDiagnosticChecker.isValidServicePath(serviceName, path)) {
                    TomlDiagnostic diag = this.getTomlDiagnostic(pathNode.location(), "C2C003", "error.invalid.service.path", DiagnosticSeverity.ERROR, "Invalid " + type.getValue() + " Service Path");
                    diagnosticInfos.add((Diagnostic)diag);
                    return diagnosticInfos;
                }
                boolean resourceFound = false;
                List<ResourceInfo> resourceInfoList = serviceInfo.getResourceInfo();
                for (ResourceInfo resourceInfo : resourceInfoList) {
                    String balResourceName = this.trimResourcePath(resourceInfo.getPath());
                    String resourcePath = this.trimResourcePath(this.trimResourcePath(serviceName) + "/" + balResourceName);
                    if (balResourceName.equals(".")) {
                        resourcePath = this.trimResourcePath(serviceName);
                    }
                    if (!resourcePath.equals(this.trimResourcePath(path))) continue;
                    resourceFound = true;
                    break;
                }
                if (resourceFound) continue;
                TomlDiagnostic diag = this.getTomlDiagnostic(pathNode.location(), "C2C004", "error.invalid.resource.path", DiagnosticSeverity.ERROR, "Invalid " + type.getValue() + " Resource Path");
                diagnosticInfos.add((Diagnostic)diag);
            }
        }
        return diagnosticInfos;
    }

    private static boolean isValidServicePath(String servicePath, String tomlPath) {
        if (servicePath.equals("/")) {
            return true;
        }
        if (tomlPath.startsWith(servicePath)) {
            if (tomlPath.length() == servicePath.length()) {
                return true;
            }
            return tomlPath.charAt(servicePath.length()) == '/';
        }
        return false;
    }

    private boolean isListenerPortValid(long port, List<ServiceInfo> serviceInfo) {
        boolean isValid = false;
        block0: for (ServiceInfo service : serviceInfo) {
            List<ListenerInfo> listeners = service.getListeners();
            for (ListenerInfo listener : listeners) {
                int givenPort = listener.getPort();
                if ((long)givenPort != port) continue;
                isValid = true;
                continue block0;
            }
        }
        return isValid;
    }

    private String trimResourcePath(String resourcePath) {
        if ((resourcePath = resourcePath.trim()).startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        if (resourcePath.endsWith("/")) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        return resourcePath;
    }

    private TomlDiagnostic getTomlDiagnostic(TomlNodeLocation location, String code, String template, DiagnosticSeverity severity, String message) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(code, template, severity);
        return new TomlDiagnostic(location, diagnosticInfo, message);
    }

    static enum ProbeType {
        READINESS("Readiness Probe"),
        LIVENESS("Liveness Probe");

        private String value;

        private ProbeType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

