/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.handlers;

import io.ballerina.c2c.diagnostics.NullLocation;
import io.ballerina.c2c.exceptions.KubernetesPluginException;
import io.ballerina.c2c.handlers.AbstractArtifactHandler;
import io.ballerina.c2c.models.ChoreoModel;
import io.ballerina.c2c.models.DeploymentModel;
import io.ballerina.c2c.models.PortModel;
import io.ballerina.c2c.util.C2CDiagnosticCodes;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.fabric8.kubernetes.api.model.ContainerPort;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class ChoreoHandler
extends AbstractArtifactHandler {
    @Override
    public void createArtifacts() throws KubernetesPluginException {
        DeploymentModel deploymentModel = this.dataHolder.getDeploymentModel();
        ArrayList<PortModel> choreoPorts = new ArrayList<PortModel>();
        for (ContainerPort containerPort : deploymentModel.getPorts()) {
            int port = containerPort.getContainerPort();
            String protocol = containerPort.getProtocol();
            choreoPorts.add(new PortModel(port, protocol));
        }
        ChoreoModel choreoModel = new ChoreoModel(choreoPorts);
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Path resolve = this.dataHolder.getChoreoArtifactOutputPath().resolve("choreo.yaml");
        Representer representer = new Representer(new DumperOptions());
        representer.addClassTag(ChoreoModel.class, Tag.MAP);
        Yaml yaml = new Yaml(representer, options);
        resolve.toFile().getParentFile().mkdirs();
        try {
            PrintWriter writer = new PrintWriter(resolve.toString());
            yaml.dump((Object)choreoModel, (Writer)writer);
        }
        catch (FileNotFoundException e) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(C2CDiagnosticCodes.ARTIFACT_GEN_FAILED.getCode(), e.getMessage(), DiagnosticSeverity.WARNING);
            Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)new NullLocation(), (Object[])new Object[]{"choreo", "ports"});
            throw new KubernetesPluginException(diagnostic);
        }
    }
}

