/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.handlers;

import io.ballerina.c2c.diagnostics.NullLocation;
import io.ballerina.c2c.exceptions.DockerGenException;
import io.ballerina.c2c.exceptions.KubernetesPluginException;
import io.ballerina.c2c.handlers.AbstractArtifactHandler;
import io.ballerina.c2c.models.ConfigMapModel;
import io.ballerina.c2c.models.DockerModel;
import io.ballerina.c2c.models.JobModel;
import io.ballerina.c2c.models.KubernetesContext;
import io.ballerina.c2c.models.KubernetesDataHolder;
import io.ballerina.c2c.models.SecretModel;
import io.ballerina.c2c.util.C2CDiagnosticCodes;
import io.ballerina.c2c.utils.DockerGenUtils;
import io.ballerina.c2c.utils.KubernetesUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.batch.v1.CronJob;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobFluent;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpecFluent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JobHandler
extends AbstractArtifactHandler {
    private void generate(JobModel jobModel) throws KubernetesPluginException {
        try {
            String jobContent = KubernetesUtils.isBlank(jobModel.getSchedule()) ? KubernetesUtils.asYaml(this.getJob(jobModel)) : KubernetesUtils.asYaml(this.getCronJob(jobModel));
            Object outputFileName = "_job.yaml";
            if (this.dataHolder.isSingleYaml()) {
                outputFileName = this.getJob(jobModel).getMetadata().getName() + ".yaml";
            }
            KubernetesUtils.writeToFile(jobContent, (String)outputFileName);
        }
        catch (IOException e) {
            Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.ARTIFACT_GEN_FAILED, new NullLocation(), "job", jobModel.getName());
            throw new KubernetesPluginException(diagnostic);
        }
    }

    private Container generateContainer(JobModel jobModel) {
        return ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(jobModel.getName())).withImage(jobModel.getImage())).withEnv(jobModel.getEnvVars())).withVolumeMounts(this.populateVolumeMounts())).build();
    }

    private Job getJob(JobModel jobModel) {
        JobBuilder jobBuilder = (JobBuilder)((JobFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withName(jobModel.getName())).withNamespace(this.dataHolder.getNamespace())).endMetadata()).withNewSpec().withNewTemplate().withNewSpec().withRestartPolicy(jobModel.getRestartPolicy())).withContainers(this.generateContainer(jobModel))).withImagePullSecrets(this.getImagePullSecrets(jobModel))).withVolumes(this.populateVolume())).endSpec()).endTemplate()).endSpec();
        return jobBuilder.build();
    }

    private List<LocalObjectReference> getImagePullSecrets(JobModel jobModel) {
        ArrayList<LocalObjectReference> imagePullSecrets = new ArrayList<LocalObjectReference>();
        for (String imagePullSecret : jobModel.getImagePullSecrets()) {
            imagePullSecrets.add(((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(imagePullSecret)).build());
        }
        return imagePullSecrets;
    }

    private CronJob getCronJob(JobModel jobModel) {
        return ((CronJobBuilder)((CronJobFluent.SpecNested)((CronJobSpecFluent.JobTemplateNested)((JobTemplateSpecFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((CronJobFluent.SpecNested)((CronJobBuilder)((CronJobFluent.MetadataNested)new CronJobBuilder().withNewMetadata().withName(jobModel.getName())).endMetadata()).withNewSpec().withSchedule(jobModel.getSchedule())).withNewJobTemplate().withNewSpec().withNewTemplate().withNewSpec().withRestartPolicy(jobModel.getRestartPolicy())).withContainers(this.generateContainer(jobModel))).withVolumes(this.populateVolume())).endSpec()).endTemplate()).endSpec()).endJobTemplate()).endSpec()).build();
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        try {
            String balxFileName = DockerGenUtils.extractJarName(this.dataHolder.getJarPath());
            JobModel jobModel = this.dataHolder.getJobModel();
            if (KubernetesUtils.isBlank(jobModel.getName())) {
                jobModel.setName(KubernetesUtils.getValidName(balxFileName) + "-job");
            }
            if (KubernetesUtils.isBlank(jobModel.getImage())) {
                jobModel.setImage(balxFileName + ":latest");
            }
            jobModel.addLabel("app", balxFileName);
            KubernetesUtils.resolveDockerToml(jobModel);
            this.generate(jobModel);
            this.dataHolder.setDockerModel(this.getDockerModel(jobModel));
            OUT.println("\t@kubernetes:Job");
        }
        catch (DockerGenException e) {
            Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.DOCKER_FAILED, new NullLocation(), new Object[0]);
            throw new KubernetesPluginException(diagnostic);
        }
    }

    private DockerModel getDockerModel(JobModel jobModel) throws DockerGenException {
        KubernetesDataHolder dataHolder = KubernetesContext.getInstance().getDataHolder();
        DockerModel dockerModel = dataHolder.getDockerModel();
        String dockerImage = jobModel.getImage();
        String imageTag = dockerImage.substring(dockerImage.lastIndexOf(":") + 1);
        dockerImage = dockerImage.substring(0, dockerImage.lastIndexOf(":"));
        dockerModel.setRegistry(jobModel.getRegistry());
        dockerModel.setName(dockerImage);
        dockerModel.setTag(imageTag);
        dockerModel.setEntryPoint(jobModel.getEntryPoint());
        dockerModel.setJarFileName(DockerGenUtils.extractJarName(this.dataHolder.getJarPath()) + ".jar");
        dockerModel.setService(false);
        dockerModel.setBuildImage(jobModel.isBuildImage());
        dockerModel.setPkgId(dataHolder.getPackageID());
        dockerModel.setCopyFiles(jobModel.getCopyFiles());
        dockerModel.setPkgId(this.dataHolder.getPackageID());
        return dockerModel;
    }

    private List<VolumeMount> populateVolumeMounts() {
        ArrayList<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
        volumeMounts.addAll(KubernetesUtils.generateSecretVolumeMounts(this.dataHolder.getSecretModelSet()));
        volumeMounts.addAll(KubernetesUtils.generateConfigMapVolumeMounts(this.dataHolder.getConfigMapModelSet()));
        return volumeMounts;
    }

    private List<Volume> populateVolume() {
        Volume volume;
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        for (SecretModel secretModel : this.dataHolder.getSecretModelSet()) {
            volume = ((VolumeBuilder)((VolumeFluent.SecretNested)((VolumeBuilder)new VolumeBuilder().withName(secretModel.getName() + "-volume")).withNewSecret().withSecretName(secretModel.getName())).endSecret()).build();
            if (secretModel.getDefaultMode() > 0) {
                volume.getSecret().setDefaultMode(secretModel.getDefaultMode());
            }
            volumes.add(volume);
        }
        for (ConfigMapModel configMapModel : this.dataHolder.getConfigMapModelSet()) {
            volume = ((VolumeBuilder)((VolumeFluent.ConfigMapNested)((VolumeBuilder)new VolumeBuilder().withName(configMapModel.getName() + "-volume")).withNewConfigMap().withName(configMapModel.getName())).endConfigMap()).build();
            if (configMapModel.getDefaultMode() > 0) {
                volume.getConfigMap().setDefaultMode(configMapModel.getDefaultMode());
            }
            volumes.add(volume);
        }
        return volumes;
    }
}

