/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.models;

import io.ballerina.c2c.exceptions.DockerGenException;
import io.ballerina.c2c.models.CopyFileModel;
import io.ballerina.projects.internal.model.Target;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.ballerinalang.model.elements.PackageID;

public class DockerModel {
    private String name;
    private String registry;
    private String tag = "latest";
    private boolean buildImage = true;
    private String baseImage = "ballerina/jvm-runtime:3.1";
    private Set<Integer> ports;
    private boolean enableDebug = false;
    private int debugPort = 5005;
    private boolean isService;
    private String jarFileName;
    private Set<CopyFileModel> externalFiles = new HashSet<CopyFileModel>();
    private String commandArg = "";
    private String entryPoint;
    private Map<String, String> env = new HashMap<String, String>();
    private Set<Path> dependencyJarPaths = new TreeSet<Path>();
    private PackageID pkgId;
    private Path fatJarPath;
    private boolean thinJar = true;
    private String graalvmBuildArgs;
    private boolean isGraalVMBuild = false;
    private String builderBase = "ghcr.io/graalvm/native-image-community:21-ol9";
    private String builderCmd = "";
    private boolean isTest = false;
    private TestSpecificProps testSpecificProps = null;

    public void setTestRunTimeCmdArgs(List<String> cmdArgsList) {
        if (this.testSpecificProps.getTestRunTimeCmdArgs() == null) {
            this.testSpecificProps.setTestRunTimeCmdArgs(cmdArgsList);
        }
    }

    public List<String> getTestRunTimeCmdArgs() {
        return this.testSpecificProps.getTestRunTimeCmdArgs();
    }

    public void setTest(boolean isTest) {
        this.isTest = isTest;
        if (isTest) {
            this.testSpecificProps = new TestSpecificProps();
        }
    }

    public void setClassPath(String classPath) {
        this.testSpecificProps.setClassPath(classPath);
    }

    public String getClassPath() {
        return this.testSpecificProps.getClassPath();
    }

    public void setTestSuiteJsonPath(Path testSuiteJsonPath) {
        this.testSpecificProps.setTestSuiteJsonPath(testSuiteJsonPath);
    }

    public Path getTestSuiteJsonPath() {
        return this.testSpecificProps.getTestSuiteJsonPath();
    }

    public void setJacocoAgentJarPath(Path jacocoAgentJarPath) {
        this.testSpecificProps.setJacocoAgentJarPath(jacocoAgentJarPath);
    }

    public Path getJacocoAgentJarPath() {
        return this.testSpecificProps.getJacocoAgentJarPath();
    }

    public void setTarget(Target target) {
        this.testSpecificProps.setTarget(target);
    }

    public Target getTarget() {
        return this.testSpecificProps.getTarget();
    }

    public void setTestConfigPaths(List<Path> testConfigPaths) {
        this.testSpecificProps.setTestConfigPaths(testConfigPaths);
    }

    public List<Path> getTestConfigPaths() {
        return this.testSpecificProps.getTestConfigPaths();
    }

    public void setSourceRoot(Path sourceRoot) {
        this.testSpecificProps.setSourceRoot(sourceRoot);
    }

    public Path getSourceRoot() {
        return this.testSpecificProps.getSourceRoot();
    }

    public void addDependencyJarPaths(Set<Path> paths) {
        this.dependencyJarPaths.addAll(paths);
    }

    public Set<Path> getDependencyJarPaths() {
        return this.dependencyJarPaths.stream().sorted().collect(Collectors.toSet());
    }

    public Set<CopyFileModel> getCopyFiles() {
        return this.externalFiles;
    }

    public void setCopyFiles(Set<CopyFileModel> externalFiles) throws DockerGenException {
        this.externalFiles = externalFiles;
        for (CopyFileModel externalFile : externalFiles) {
            if (!externalFile.isBallerinaConf()) continue;
            if (Files.isDirectory(Paths.get(externalFile.getSource(), new String[0]), new LinkOption[0])) {
                throw new DockerGenException("invalid config file given: " + externalFile.getSource());
            }
            this.env.put("BALCONFIGFILE", externalFile.getTarget());
        }
    }

    public void addCommandArg(String commandArg) {
        this.commandArg = this.commandArg + commandArg;
    }

    public String getEntryPoint() {
        if (this.entryPoint == null) {
            return null;
        }
        String configFile = "";
        for (CopyFileModel externalFile : this.externalFiles) {
            if (!externalFile.isBallerinaConf()) continue;
            configFile = externalFile.getTarget();
        }
        return this.entryPoint.replace("${APP}", this.jarFileName).replace("${CONFIG_FILE}", configFile);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getRegistry() {
        return this.registry;
    }

    @Generated
    public String getTag() {
        return this.tag;
    }

    @Generated
    public boolean isBuildImage() {
        return this.buildImage;
    }

    @Generated
    public String getBaseImage() {
        return this.baseImage;
    }

    @Generated
    public Set<Integer> getPorts() {
        return this.ports;
    }

    @Generated
    public boolean isEnableDebug() {
        return this.enableDebug;
    }

    @Generated
    public int getDebugPort() {
        return this.debugPort;
    }

    @Generated
    public boolean isService() {
        return this.isService;
    }

    @Generated
    public String getJarFileName() {
        return this.jarFileName;
    }

    @Generated
    public Set<CopyFileModel> getExternalFiles() {
        return this.externalFiles;
    }

    @Generated
    public String getCommandArg() {
        return this.commandArg;
    }

    @Generated
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Generated
    public PackageID getPkgId() {
        return this.pkgId;
    }

    @Generated
    public Path getFatJarPath() {
        return this.fatJarPath;
    }

    @Generated
    public boolean isThinJar() {
        return this.thinJar;
    }

    @Generated
    public String getGraalvmBuildArgs() {
        return this.graalvmBuildArgs;
    }

    @Generated
    public boolean isGraalVMBuild() {
        return this.isGraalVMBuild;
    }

    @Generated
    public String getBuilderBase() {
        return this.builderBase;
    }

    @Generated
    public String getBuilderCmd() {
        return this.builderCmd;
    }

    @Generated
    public boolean isTest() {
        return this.isTest;
    }

    @Generated
    public TestSpecificProps getTestSpecificProps() {
        return this.testSpecificProps;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setRegistry(String registry) {
        this.registry = registry;
    }

    @Generated
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Generated
    public void setBuildImage(boolean buildImage) {
        this.buildImage = buildImage;
    }

    @Generated
    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    @Generated
    public void setPorts(Set<Integer> ports) {
        this.ports = ports;
    }

    @Generated
    public void setEnableDebug(boolean enableDebug) {
        this.enableDebug = enableDebug;
    }

    @Generated
    public void setDebugPort(int debugPort) {
        this.debugPort = debugPort;
    }

    @Generated
    public void setService(boolean isService) {
        this.isService = isService;
    }

    @Generated
    public void setJarFileName(String jarFileName) {
        this.jarFileName = jarFileName;
    }

    @Generated
    public void setExternalFiles(Set<CopyFileModel> externalFiles) {
        this.externalFiles = externalFiles;
    }

    @Generated
    public void setCommandArg(String commandArg) {
        this.commandArg = commandArg;
    }

    @Generated
    public void setEntryPoint(String entryPoint) {
        this.entryPoint = entryPoint;
    }

    @Generated
    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    @Generated
    public void setDependencyJarPaths(Set<Path> dependencyJarPaths) {
        this.dependencyJarPaths = dependencyJarPaths;
    }

    @Generated
    public void setPkgId(PackageID pkgId) {
        this.pkgId = pkgId;
    }

    @Generated
    public void setFatJarPath(Path fatJarPath) {
        this.fatJarPath = fatJarPath;
    }

    @Generated
    public void setThinJar(boolean thinJar) {
        this.thinJar = thinJar;
    }

    @Generated
    public void setGraalvmBuildArgs(String graalvmBuildArgs) {
        this.graalvmBuildArgs = graalvmBuildArgs;
    }

    @Generated
    public void setGraalVMBuild(boolean isGraalVMBuild) {
        this.isGraalVMBuild = isGraalVMBuild;
    }

    @Generated
    public void setBuilderBase(String builderBase) {
        this.builderBase = builderBase;
    }

    @Generated
    public void setBuilderCmd(String builderCmd) {
        this.builderCmd = builderCmd;
    }

    @Generated
    public void setTestSpecificProps(TestSpecificProps testSpecificProps) {
        this.testSpecificProps = testSpecificProps;
    }

    private static class TestSpecificProps {
        private List<String> testRunTimeCmdArgs = null;
        private String classPath;
        private Path testSuiteJsonPath;
        private Path jacocoAgentJarPath;
        private Target target;
        private List<Path> testConfigPaths;
        private Path sourceRoot;

        private TestSpecificProps() {
        }

        private List<String> getTestRunTimeCmdArgs() {
            return this.testRunTimeCmdArgs;
        }

        private void setTestRunTimeCmdArgs(List<String> runTimeArgs) {
            this.testRunTimeCmdArgs = runTimeArgs;
        }

        private String getClassPath() {
            return this.classPath;
        }

        private void setClassPath(String classPath) {
            this.classPath = classPath;
        }

        private Path getTestSuiteJsonPath() {
            return this.testSuiteJsonPath;
        }

        private void setTestSuiteJsonPath(Path testSuiteJsonPath) {
            this.testSuiteJsonPath = testSuiteJsonPath;
        }

        private Path getJacocoAgentJarPath() {
            return this.jacocoAgentJarPath;
        }

        private void setJacocoAgentJarPath(Path jacocoAgentJarPath) {
            this.jacocoAgentJarPath = jacocoAgentJarPath;
        }

        private Target getTarget() {
            return this.target;
        }

        private void setTarget(Target target) {
            this.target = target;
        }

        private List<Path> getTestConfigPaths() {
            return this.testConfigPaths;
        }

        private void setTestConfigPaths(List<Path> testConfigPaths) {
            this.testConfigPaths = testConfigPaths;
        }

        private Path getSourceRoot() {
            return this.sourceRoot;
        }

        private void setSourceRoot(Path sourceRoot) {
            this.sourceRoot = sourceRoot;
        }
    }
}

