/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.tasks;

import io.ballerina.c2c.choreo.ProjectServiceInfo;
import io.ballerina.c2c.models.DeploymentModel;
import io.ballerina.c2c.models.KubernetesContext;
import io.ballerina.c2c.models.KubernetesDataHolder;
import io.ballerina.c2c.models.ServiceModel;
import io.ballerina.c2c.util.ListenerInfo;
import io.ballerina.c2c.util.ServiceInfo;
import io.ballerina.c2c.utils.KubernetesUtils;
import io.ballerina.projects.CloudToml;
import io.ballerina.projects.Package;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.CompilationAnalysisContext;
import io.ballerina.toml.syntax.tree.NodeLocation;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ChoreoAnalysisTask
implements AnalysisTask<CompilationAnalysisContext> {
    public void perform(CompilationAnalysisContext compilationAnalysisContext) {
        Package currentPackage = compilationAnalysisContext.currentPackage();
        String cloud = currentPackage.project().buildOptions().cloud();
        if (cloud == null || !cloud.equals("choreo")) {
            return;
        }
        KubernetesContext.getInstance().setCurrentPackage(KubernetesUtils.getProjectID(currentPackage));
        KubernetesDataHolder dataHolder = KubernetesContext.getInstance().getDataHolder();
        dataHolder.setPackageID(KubernetesUtils.getProjectID(currentPackage));
        Optional cloudToml = currentPackage.cloudToml();
        if (cloudToml.isPresent()) {
            NodeLocation location = ((CloudToml)cloudToml.get()).tomlDocument().syntaxTree().rootNode().location();
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo("C2C_016", "Cloud.toml is not supported and will be ignored in choreo", DiagnosticSeverity.WARNING);
            compilationAnalysisContext.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]));
        }
        ArrayList<Diagnostic> c2cDiagnostics = new ArrayList<Diagnostic>();
        ProjectServiceInfo projectServiceInfo = new ProjectServiceInfo(currentPackage.project(), c2cDiagnostics);
        List<ServiceInfo> serviceList = projectServiceInfo.getServiceList();
        this.addServices(serviceList);
        this.addDeployments();
        for (Diagnostic diagnostic : c2cDiagnostics) {
            compilationAnalysisContext.reportDiagnostic(diagnostic);
        }
    }

    private void addServices(List<ServiceInfo> serviceList) {
        for (ServiceInfo choreoServiceInfo : serviceList) {
            List<ListenerInfo> listeners = choreoServiceInfo.getListeners();
            for (ListenerInfo listener : listeners) {
                ServiceModel serviceModel = new ServiceModel();
                if (KubernetesUtils.isBlank(serviceModel.getName())) {
                    serviceModel.setName(KubernetesUtils.getValidName(choreoServiceInfo.getServicePath() + "-svc"));
                }
                int port = listener.getPort();
                if (serviceModel.getPort() == -1) {
                    serviceModel.setPort(port);
                }
                if (serviceModel.getTargetPort() == -1) {
                    serviceModel.setTargetPort(port);
                }
                serviceModel.setProtocol("http");
                KubernetesContext.getInstance().getDataHolder().addServiceModel(serviceModel);
            }
        }
    }

    private void addDeployments() {
        String dockerCertPath;
        DeploymentModel deploymentModel = new DeploymentModel();
        String dockerHost = System.getenv("DOCKER_HOST");
        if (!KubernetesUtils.isBlank(dockerHost)) {
            deploymentModel.setDockerHost(dockerHost);
        }
        if (!KubernetesUtils.isBlank(dockerCertPath = System.getenv("DOCKER_CERT_PATH"))) {
            deploymentModel.setDockerCertPath(dockerCertPath);
        }
        KubernetesContext.getInstance().getDataHolder().setDeploymentModel(deploymentModel);
    }
}

