/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.tasks;

import io.ballerina.c2c.ArtifactManager;
import io.ballerina.c2c.exceptions.KubernetesPluginException;
import io.ballerina.c2c.models.KubernetesContext;
import io.ballerina.c2c.models.KubernetesDataHolder;
import io.ballerina.c2c.tasks.C2CCodeGeneratedTask;
import io.ballerina.c2c.utils.DockerGenUtils;
import io.ballerina.c2c.utils.KubernetesUtils;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JarLibrary;
import io.ballerina.projects.JarResolver;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.plugins.CompilerLifecycleEventContext;
import io.ballerina.projects.plugins.CompilerLifecycleTask;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.PackageID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChoreoCodeGenTask
implements CompilerLifecycleTask<CompilerLifecycleEventContext> {
    private static final Logger pluginLog = LoggerFactory.getLogger(C2CCodeGeneratedTask.class);
    private final KubernetesDataHolder dataHolder = KubernetesContext.getInstance().getDataHolder();

    public void perform(CompilerLifecycleEventContext compilerLifecycleEventContext) {
        Project project = compilerLifecycleEventContext.currentPackage().project();
        String cloud = project.buildOptions().cloud();
        if (cloud == null || !cloud.equals("choreo")) {
            return;
        }
        Optional executablePath = compilerLifecycleEventContext.getGeneratedArtifactPath();
        PackageID currentPackage = KubernetesContext.getInstance().getCurrentPackage();
        executablePath.ifPresent(path -> {
            String executableJarName = "$anon".equals(currentPackage.orgName.getValue()) ? path.getFileName().toString() : currentPackage.orgName.getValue() + "-" + currentPackage.name.getValue() + "-" + currentPackage.version.getValue() + ".jar";
            String outputName = "$anon".equals(currentPackage.orgName.getValue()) ? DockerGenUtils.extractJarName(path.getFileName()) : currentPackage.name.getValue();
            this.dataHolder.setOutputName(outputName);
            this.addDependencyJars(compilerLifecycleEventContext.compilation(), executableJarName);
            this.dataHolder.setSourceRoot(((Path)executablePath.get()).getParent().getParent().getParent());
            this.codeGeneratedInternal(currentPackage, (Path)path, project.buildOptions().cloud());
        });
    }

    public void codeGeneratedInternal(PackageID packageId, Path executableJarFile, String buildType) {
        KubernetesContext.getInstance().setCurrentPackage(packageId);
        this.dataHolder.setPackageID(packageId);
        executableJarFile = executableJarFile.toAbsolutePath();
        if (null != executableJarFile.getParent() && Files.exists(executableJarFile.getParent(), new LinkOption[0])) {
            Path projectRoot;
            Path choreoOutputPath = executableJarFile.getParent().resolve("choreo");
            Path dockerOutputPath = executableJarFile.getParent().resolve("docker");
            if (null != executableJarFile.getParent().getParent().getParent() && Files.exists(executableJarFile.getParent().getParent().getParent(), new LinkOption[0]) && Files.exists((projectRoot = executableJarFile.getParent().getParent().getParent()).resolve("Ballerina.toml"), new LinkOption[0])) {
                choreoOutputPath = projectRoot.resolve("target").resolve("choreo").resolve(DockerGenUtils.extractJarName(executableJarFile));
                dockerOutputPath = projectRoot.resolve("target").resolve("docker").resolve(DockerGenUtils.extractJarName(executableJarFile));
            }
            this.dataHolder.setChoreoArtifactOutputPath(choreoOutputPath);
            this.dataHolder.setDockerArtifactOutputPath(dockerOutputPath);
            ArtifactManager artifactManager = new ArtifactManager();
            try {
                KubernetesUtils.deleteDirectory(choreoOutputPath);
                artifactManager.populateDeploymentModel();
                artifactManager.createArtifacts(buildType, false);
            }
            catch (KubernetesPluginException e) {
                String errorMessage = "module [" + String.valueOf(packageId) + "] " + e.getMessage();
                KubernetesUtils.printError(errorMessage);
                pluginLog.error(errorMessage, (Throwable)e);
                try {
                    KubernetesUtils.deleteDirectory(choreoOutputPath);
                }
                catch (KubernetesPluginException kubernetesPluginException) {}
            }
        } else {
            KubernetesUtils.printError("error in resolving Docker generation location.");
            pluginLog.error("error in resolving Docker generation location.");
        }
    }

    private void addDependencyJars(PackageCompilation compilation, String executableFatJar) {
        JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)compilation, (JvmTarget)JvmTarget.JAVA_21);
        JarResolver jarResolver = jBallerinaBackend.jarResolver();
        this.dataHolder.getDockerModel().addDependencyJarPaths(jarResolver.getJarFilePathsRequiredForExecution().stream().map(JarLibrary::path).collect(Collectors.toSet()));
        jarResolver.getJarFilePathsRequiredForExecution().stream().filter(jarLibrary -> jarLibrary.path().getFileName().toString().endsWith(executableFatJar)).findFirst().ifPresent(jarLibrary -> this.dataHolder.setJarPath(jarLibrary.path()));
    }
}

