/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.utils;

import io.ballerina.c2c.KubernetesConstants;
import io.ballerina.c2c.exceptions.DockerGenException;
import io.ballerina.c2c.models.DockerModel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.FileUtils;

public class DockerGenUtils {
    private static final boolean debugEnabled = "true".equals(System.getenv("BAL_DOCKER_DEBUG"));
    private static final PrintStream out = System.out;

    public static void printDebug(String msg) {
        if (debugEnabled) {
            out.println("debug [docker client]: " + msg);
        }
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static void writeToFile(String context, Path targetFilePath) throws IOException {
        File newFile = targetFilePath.toFile();
        if (newFile.exists() && newFile.delete()) {
            Files.write(targetFilePath, context.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return;
        }
        if (newFile.getParentFile().mkdirs()) {
            Files.write(targetFilePath, context.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return;
        }
        Files.write(targetFilePath, context.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static String extractJarName(Path jarFilePath) {
        Path fileName;
        if (null != jarFilePath && null != (fileName = jarFilePath.getFileName()) && fileName.toString().endsWith(".jar")) {
            return fileName.toString().replace(".jar", "");
        }
        return null;
    }

    public static void copyFileOrDirectory(Path source, Path destination) throws DockerGenException {
        DockerGenUtils.printDebug("copying file(s) from `" + String.valueOf(source) + "` to `" + String.valueOf(destination) + "`.");
        File src = source.toFile();
        if (!src.exists()) {
            throw new DockerGenException("error while copying file/folder '" + String.valueOf(source) + "' as it does not exist");
        }
        File dst = destination.toFile();
        try {
            if (Files.isRegularFile(source, new LinkOption[0])) {
                if (Files.isDirectory(dst.toPath(), new LinkOption[0])) {
                    FileUtils.copyFileToDirectory((File)src, (File)dst);
                } else {
                    FileUtils.copyFile((File)src, (File)dst);
                }
            } else if (Files.isDirectory(source, new LinkOption[0])) {
                FileUtils.copyDirectory((File)src, (File)dst);
            }
        }
        catch (IOException e) {
            throw new DockerGenException("error while copying file/folder '" + String.valueOf(source) + "' to '" + String.valueOf(destination) + "'");
        }
    }

    public static void copyTestConfigFiles(Path outputDir, DockerModel dockerModel) throws DockerGenException {
        for (Path testConfigPath : dockerModel.getTestConfigPaths()) {
            DockerGenUtils.copyFileOrDirectory(testConfigPath, outputDir.resolve("config-files").resolve(Objects.requireNonNull(DockerGenUtils.getModuleNameOfConfigFile(testConfigPath))).resolve("Config.toml"));
        }
    }

    public static void addConfigTomls(StringBuilder testDockerFileContent, DockerModel dockerModel, Path outputDir, String projectSourceRoot) throws DockerGenException {
        for (Path testConfigPath : dockerModel.getTestConfigPaths()) {
            String relativePath = testConfigPath.toString().replace(projectSourceRoot, "");
            String[] split = relativePath.split("/");
            Path target = outputDir;
            for (int i = 0; i < split.length - 1; ++i) {
                target = target.resolve(split[i]);
            }
            Path moduleName = DockerGenUtils.getModuleNameOfConfigFile(testConfigPath);
            if (moduleName == null) {
                throw new DockerGenException("module name not found for the config file: " + String.valueOf(testConfigPath));
            }
            testDockerFileContent.append("COPY ").append("config-files/").append(moduleName).append("/").append("Config.toml").append(" ").append(target).append("/").append(KubernetesConstants.LINE_SEPARATOR);
        }
    }

    private static Path getModuleNameOfConfigFile(Path testConfigPath) {
        Path parent = testConfigPath.getParent();
        if (parent == null) {
            return null;
        }
        Path grandParent = parent.getParent();
        if (grandParent == null) {
            return null;
        }
        Optional<Path> moduleName = Optional.ofNullable(grandParent.getFileName());
        return moduleName.orElse(null);
    }

    public static String cleanErrorMessage(String errorMessage) {
        errorMessage = errorMessage.replace("javax.ws.rs.ProcessingException:", "");
        errorMessage = errorMessage.replace("java.io.IOException:", "");
        errorMessage = errorMessage.replace("java.util.concurrent.ExecutionException:", "");
        errorMessage = errorMessage.replace("java.lang.IllegalArgumentException:", "");
        errorMessage = errorMessage.replace("org.apache.http.conn.HttpHostConnectException:", "");
        if ((errorMessage = errorMessage.replace("org.apache.http.client.ClientProtocolException:", "")).contains("unable to find valid certification path")) {
            errorMessage = "unable to find docker cert path.";
        } else if (errorMessage.contains("Connection refused")) {
            errorMessage = "connection refused to docker host";
        } else if (errorMessage.contains("Unable to connect to server")) {
            errorMessage = errorMessage.replace("Unable to connect to server: Timeout: GET", "unable to connect to docker host: ");
        } else if (errorMessage.toLowerCase(Locale.getDefault()).contains("permission denied")) {
            errorMessage = "permission denied for docker";
        }
        return DockerGenUtils.firstCharToLowerCase(errorMessage);
    }

    private static String firstCharToLowerCase(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        if (str.length() == 1) {
            return str.toLowerCase(Locale.getDefault());
        }
        char[] chArr = str.toCharArray();
        chArr[0] = Character.toLowerCase(chArr[0]);
        return new String(chArr);
    }

    public static String getWorkDir() {
        return "/home/ballerina";
    }

    public static String getTargetDir() {
        Path workDir = Path.of(DockerGenUtils.getWorkDir(), new String[0]);
        return workDir.resolve("target").toString();
    }

    public static String getTestSuiteJsonCopiedDir() {
        Path targetDir = Path.of(DockerGenUtils.getTargetDir(), new String[0]);
        Path testSuiteJsonCopiedDir = targetDir.resolve("cache").resolve("tests_cache");
        return testSuiteJsonCopiedDir.toString();
    }
}

