/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import java.util.Base64;

public final class ToBase64 {
    private static final BString NOT_SUPPORT_DETAIL_ERROR = StringUtils.fromString((String)"toBase64() is only supported on 'byte[]'");

    private ToBase64() {
    }

    public static BString toBase64(BArray arr) {
        Type arrType = TypeUtils.getImpliedType((Type)arr.getType());
        if (arrType.getTag() != 32 || ((ArrayType)arrType).getElementType().getTag() != 2) {
            throw ErrorCreator.createError((BString)ErrorReasons.getModulePrefixedReason((String)"lang.array", (String)"OperationNotSupported"), (BString)NOT_SUPPORT_DETAIL_ERROR);
        }
        return StringUtils.fromString((String)Base64.getEncoder().encodeToString(arr.getBytes()));
    }
}

