/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.core;

import io.ballerina.architecturemodelgenerator.core.ArchitectureModel;
import io.ballerina.architecturemodelgenerator.core.diagnostics.ArchitectureModelDiagnostic;
import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticMessage;
import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticNode;
import io.ballerina.architecturemodelgenerator.core.generators.entity.EntityModelGenerator;
import io.ballerina.architecturemodelgenerator.core.generators.entrypoint.FunctionEntryPointModelGenerator;
import io.ballerina.architecturemodelgenerator.core.generators.service.ServiceModelGenerator;
import io.ballerina.architecturemodelgenerator.core.model.entity.Entity;
import io.ballerina.architecturemodelgenerator.core.model.functionentrypoint.FunctionEntryPoint;
import io.ballerina.architecturemodelgenerator.core.model.service.Connection;
import io.ballerina.architecturemodelgenerator.core.model.service.Service;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class ArchitectureModelBuilder {
    public ArchitectureModel constructComponentModel(Package currentPackage) {
        return this.constructComponentModel(currentPackage, null);
    }

    public ArchitectureModel constructComponentModel(Package currentPackage, PackageCompilation packageCompilation) {
        HashMap<String, Service> services = new HashMap<String, Service>();
        HashMap<String, Entity> entities = new HashMap<String, Entity>();
        ArrayList<ArchitectureModelDiagnostic> diagnostics = new ArrayList<ArchitectureModelDiagnostic>();
        ArrayList<Connection> allDependencies = new ArrayList<Connection>();
        AtomicReference functionEntryPoint = new AtomicReference();
        AtomicBoolean hasDiagnosticErrors = new AtomicBoolean(false);
        String packageOrg = currentPackage.packageOrg().value();
        String packageName = currentPackage.packageName().value();
        String packageVersion = currentPackage.packageVersion().value().toString();
        currentPackage.modules().forEach(module -> {
            PackageCompilation currentPackageCompilation;
            PackageCompilation packageCompilation2 = currentPackageCompilation = packageCompilation == null ? PackageUtil.getCompilation((Package)currentPackage) : packageCompilation;
            if (currentPackageCompilation.diagnosticResult().hasErrors() && !hasDiagnosticErrors.get()) {
                hasDiagnosticErrors.set(true);
            }
            ServiceModelGenerator serviceModelGenerator = new ServiceModelGenerator(currentPackageCompilation, (Module)module);
            try {
                serviceModelGenerator.generate();
                services.putAll(serviceModelGenerator.getServices());
                allDependencies.addAll(serviceModelGenerator.getDependencies());
            }
            catch (Exception e) {
                DiagnosticMessage message = DiagnosticMessage.failedToGenerate(DiagnosticNode.SERVICES, e.getMessage());
                ArchitectureModelDiagnostic diagnostic = new ArchitectureModelDiagnostic(message.getCode(), message.getDescription(), message.getSeverity(), null, null);
                diagnostics.add(diagnostic);
            }
            EntityModelGenerator entityModelGenerator = new EntityModelGenerator(currentPackageCompilation, (Module)module);
            try {
                entities.putAll(entityModelGenerator.generate());
            }
            catch (Exception e) {
                DiagnosticMessage message = DiagnosticMessage.failedToGenerate(DiagnosticNode.ENTITIES, e.getMessage());
                ArchitectureModelDiagnostic diagnostic = new ArchitectureModelDiagnostic(message.getCode(), message.getDescription(), message.getSeverity(), null, null);
                diagnostics.add(diagnostic);
            }
            FunctionEntryPointModelGenerator functionEntryPointModelGenerator = new FunctionEntryPointModelGenerator(currentPackageCompilation, (Module)module);
            functionEntryPointModelGenerator.generate();
            FunctionEntryPoint generatedFunctionEntryPoint = functionEntryPointModelGenerator.getFunctionEntryPoint();
            if (generatedFunctionEntryPoint != null) {
                functionEntryPoint.set(generatedFunctionEntryPoint);
                allDependencies.addAll(functionEntryPointModelGenerator.getDependencies());
            }
        });
        return new ArchitectureModel("0.4.0", packageName, packageOrg, packageVersion, diagnostics, services, entities, (FunctionEntryPoint)functionEntryPoint.get(), hasDiagnosticErrors.get(), allDependencies);
    }
}

