/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.core.generators;

import io.ballerina.architecturemodelgenerator.core.model.SourceLocation;
import io.ballerina.architecturemodelgenerator.core.model.common.DisplayAnnotation;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Annotatable;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.values.ConstantValue;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParenthesisedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.projects.Package;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class GeneratorUtils {
    public static SourceLocation getSourceLocation(String filePath, LineRange lineRange) {
        SourceLocation.LinePosition startPosition = SourceLocation.LinePosition.from(lineRange.startLine().line(), lineRange.startLine().offset());
        SourceLocation.LinePosition endLinePosition = SourceLocation.LinePosition.from(lineRange.endLine().line(), lineRange.endLine().offset());
        return SourceLocation.from(filePath, startPosition, endLinePosition);
    }

    public static DisplayAnnotation getServiceAnnotation(NodeList<AnnotationNode> annotationNodes, String filePath) {
        String id = "";
        String label = "";
        SourceLocation elementLocation = null;
        for (AnnotationNode annotationNode : annotationNodes) {
            String annotationName = annotationNode.annotReference().toString().trim();
            if (!annotationName.equals("display") || !annotationNode.annotValue().isPresent()) continue;
            SeparatedNodeList fields = ((MappingConstructorExpressionNode)annotationNode.annotValue().get()).fields();
            elementLocation = GeneratorUtils.getSourceLocation(filePath, annotationNode.lineRange());
            for (MappingFieldNode mappingFieldNode : fields) {
                if (mappingFieldNode.kind() != SyntaxKind.SPECIFIC_FIELD) continue;
                SpecificFieldNode specificFieldNode = (SpecificFieldNode)mappingFieldNode;
                String name = specificFieldNode.fieldName().toString().trim();
                if (specificFieldNode.valueExpr().isEmpty()) continue;
                ExpressionNode expressionNode = (ExpressionNode)specificFieldNode.valueExpr().get();
                String expressionNodeStr = expressionNode.toString().trim();
                String annotation = expressionNodeStr.replace("\"", "");
                if (name.equals("id")) {
                    id = annotation;
                    continue;
                }
                if (!name.equals("label")) continue;
                label = annotation;
            }
        }
        return new DisplayAnnotation(id, label, elementLocation, Collections.emptyList());
    }

    public static DisplayAnnotation getServiceAnnotation(Annotatable annotableSymbol, String filePath) {
        String id = null;
        String label = "";
        SourceLocation elementLocation = null;
        List annotSymbols = annotableSymbol.annotations();
        List annotAttachmentSymbols = annotableSymbol.annotAttachments();
        if (annotSymbols.size() == annotAttachmentSymbols.size()) {
            for (int i = 0; i < annotSymbols.size(); ++i) {
                AnnotationSymbol annotSymbol = (AnnotationSymbol)annotSymbols.get(i);
                AnnotationAttachmentSymbol annotAttachmentSymbol = (AnnotationAttachmentSymbol)annotAttachmentSymbols.get(i);
                String annotName = annotSymbol.getName().orElse("");
                SourceLocation sourceLocation = elementLocation = annotAttachmentSymbol.getLocation().isPresent() ? GeneratorUtils.getSourceLocation(filePath, ((Location)annotAttachmentSymbol.getLocation().get()).lineRange()) : null;
                if (!annotName.equals("display") || annotAttachmentSymbol.attachmentValue().isEmpty() || !(((ConstantValue)annotAttachmentSymbol.attachmentValue().get()).value() instanceof LinkedHashMap) || !annotAttachmentSymbol.isConstAnnotation()) continue;
                LinkedHashMap attachmentValue = (LinkedHashMap)((ConstantValue)annotAttachmentSymbol.attachmentValue().get()).value();
                if (attachmentValue.containsKey("id")) {
                    id = ((ConstantValue)attachmentValue.get("id")).value().toString();
                }
                if (!attachmentValue.containsKey("label")) break;
                label = ((ConstantValue)attachmentValue.get("label")).value().toString();
                break;
            }
        }
        return new DisplayAnnotation(id, label, elementLocation, Collections.emptyList());
    }

    public static String getClientModuleName(Node clientNode, SemanticModel semanticModel) {
        String clientModuleName = null;
        Optional clientTypeSymbol = semanticModel.typeOf(clientNode);
        if (clientTypeSymbol.isPresent()) {
            clientModuleName = ((TypeSymbol)clientTypeSymbol.get()).signature().trim().replace(":Client", "");
        }
        return clientModuleName;
    }

    public static String getClientModuleName(TypeSymbol typeSymbol) {
        String clientModuleName = typeSymbol.signature().trim().replace(":Client", "");
        if (typeSymbol.getModule().isPresent()) {
            clientModuleName = ((ModuleSymbol)typeSymbol.getModule().get()).id().toString();
        }
        return clientModuleName;
    }

    public static NonTerminalNode findNode(SyntaxTree syntaxTree, LineRange lineRange) {
        if (lineRange == null) {
            return null;
        }
        try {
            TextDocument textDocument = syntaxTree.textDocument();
            int start = textDocument.textPositionFrom(lineRange.startLine());
            int end = textDocument.textPositionFrom(lineRange.endLine());
            return ((ModulePartNode)syntaxTree.rootNode()).findNode(TextRange.from((int)start, (int)(end - start)), true);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static List<String> getReferencedType(TypeSymbol typeSymbol, Package currentPackage) {
        LinkedList<String> paramTypes = new LinkedList<String>();
        TypeDescKind typeDescKind = typeSymbol.typeKind();
        switch (typeDescKind) {
            case TYPE_REFERENCE: {
                TypeReferenceTypeSymbol typeReferenceTypeSymbol = (TypeReferenceTypeSymbol)typeSymbol;
                paramTypes.add(GeneratorUtils.getReferenceEntityName(typeReferenceTypeSymbol, currentPackage).trim());
                break;
            }
            case UNION: {
                UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol;
                List memberTypeDescriptors = unionTypeSymbol.memberTypeDescriptors();
                for (TypeSymbol memberTypeDescriptor : memberTypeDescriptors) {
                    paramTypes.addAll(GeneratorUtils.getReferencedType(memberTypeDescriptor, currentPackage));
                }
                break;
            }
            case ARRAY: {
                ArrayTypeSymbol arrayTypeSymbol = (ArrayTypeSymbol)typeSymbol;
                if (arrayTypeSymbol.memberTypeDescriptor().typeKind().equals((Object)TypeDescKind.TYPE_REFERENCE)) {
                    paramTypes.add(GeneratorUtils.getReferenceEntityName((TypeReferenceTypeSymbol)arrayTypeSymbol.memberTypeDescriptor(), currentPackage).trim());
                    break;
                }
                paramTypes.add(arrayTypeSymbol.signature().trim());
                break;
            }
            case NIL: {
                paramTypes.add("null");
                break;
            }
            default: {
                paramTypes.add(typeDescKind.getName());
            }
        }
        return paramTypes;
    }

    private static String getReferenceEntityName(TypeReferenceTypeSymbol typeReferenceTypeSymbol, Package currentPackage) {
        String currentPackageName = String.format("%s/%s:%s", currentPackage.packageOrg().value(), currentPackage.packageName().value(), currentPackage.packageVersion().value());
        String referenceType = typeReferenceTypeSymbol.signature();
        if (typeReferenceTypeSymbol.getModule().isPresent() && !referenceType.split(":")[0].equals(currentPackageName.split(":")[0])) {
            String orgName = ((ModuleSymbol)typeReferenceTypeSymbol.getModule().get()).id().orgName();
            String packageName = ((ModuleSymbol)typeReferenceTypeSymbol.getModule().get()).id().packageName();
            String modulePrefix = ((ModuleSymbol)typeReferenceTypeSymbol.getModule().get()).id().modulePrefix();
            String recordName = (String)typeReferenceTypeSymbol.getName().get();
            String version = ((ModuleSymbol)typeReferenceTypeSymbol.getModule().get()).id().version();
            referenceType = String.format("%s/%s:%s:%s:%s", orgName, packageName, modulePrefix, version, recordName);
        }
        return referenceType;
    }

    public static Node getReferredNode(Node typeName) {
        Node typeDescNode;
        Node qualifiedNameRefNode = null;
        if (typeName.kind().equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE) || typeName.kind().equals((Object)SyntaxKind.SIMPLE_NAME_REFERENCE)) {
            qualifiedNameRefNode = typeName;
        } else if (typeName instanceof UnionTypeDescriptorNode) {
            Node leftTypeDescNode = GeneratorUtils.getReferredNode((Node)((UnionTypeDescriptorNode)typeName).leftTypeDesc());
            Node rightTypeDescNode = GeneratorUtils.getReferredNode((Node)((UnionTypeDescriptorNode)typeName).rightTypeDesc());
            if (leftTypeDescNode != null && (leftTypeDescNode.kind().equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE) || leftTypeDescNode.kind().equals((Object)SyntaxKind.SIMPLE_NAME_REFERENCE))) {
                qualifiedNameRefNode = leftTypeDescNode;
            }
            if (rightTypeDescNode != null && (rightTypeDescNode.kind().equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE) || rightTypeDescNode.kind().equals((Object)SyntaxKind.SIMPLE_NAME_REFERENCE))) {
                qualifiedNameRefNode = rightTypeDescNode;
            }
        } else if (typeName instanceof ParenthesisedTypeDescriptorNode && (typeDescNode = GeneratorUtils.getReferredNode((Node)((ParenthesisedTypeDescriptorNode)typeName).typedesc())) != null && (typeDescNode.kind().equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE) || typeDescNode.kind().equals((Object)SyntaxKind.SIMPLE_NAME_REFERENCE))) {
            qualifiedNameRefNode = typeDescNode;
        }
        return qualifiedNameRefNode;
    }

    public static ClassSymbol getReferredClassSymbol(TypeSymbol symbol) {
        ClassSymbol classSymbol = null;
        if (symbol.kind().equals((Object)SymbolKind.CLASS)) {
            classSymbol = (ClassSymbol)symbol;
        } else if (symbol.typeKind().equals((Object)TypeDescKind.TYPE_REFERENCE)) {
            TypeReferenceTypeSymbol typeRefTypeSymbol = (TypeReferenceTypeSymbol)symbol;
            TypeSymbol typeDescTypeSymbol = typeRefTypeSymbol.typeDescriptor();
            classSymbol = GeneratorUtils.getReferredClassSymbol(typeDescTypeSymbol);
        }
        return classSymbol;
    }
}

