/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.core.generators.entrypoint.nodevisitors;

import io.ballerina.architecturemodelgenerator.core.generators.GeneratorUtils;
import io.ballerina.architecturemodelgenerator.core.model.common.DisplayAnnotation;
import io.ballerina.architecturemodelgenerator.core.model.service.Connection;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LineRange;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class FunctionEntryPointMemberNodeVisitor
extends NodeVisitor {
    private final SemanticModel semanticModel;
    private final SyntaxTree syntaxTree;
    private final List<Connection> dependencies = new LinkedList<Connection>();
    private final Path filePath;

    public FunctionEntryPointMemberNodeVisitor(SemanticModel semanticModel, SyntaxTree syntaxTree, Path filePath) {
        this.semanticModel = semanticModel;
        this.syntaxTree = syntaxTree;
        this.filePath = filePath;
    }

    public List<Connection> getDependencies() {
        return this.dependencies;
    }

    public void visit(VariableDeclarationNode variableDeclarationNode) {
        boolean isClientClass;
        ClassSymbol referredClassSymbol;
        Optional fieldTypeNameSymbol;
        if (this.hasInvocationReferences(variableDeclarationNode)) {
            return;
        }
        Node fieldTypeName = GeneratorUtils.getReferredNode((Node)variableDeclarationNode.typedBindingPattern().typeDescriptor());
        if (fieldTypeName != null && (fieldTypeNameSymbol = this.semanticModel.symbol(fieldTypeName)).isPresent() && (referredClassSymbol = GeneratorUtils.getReferredClassSymbol((TypeSymbol)fieldTypeNameSymbol.get())) != null && (isClientClass = referredClassSymbol.qualifiers().stream().anyMatch(qualifier -> qualifier.equals((Object)Qualifier.CLIENT)))) {
            DisplayAnnotation displayAnnotation = GeneratorUtils.getServiceAnnotation((NodeList<AnnotationNode>)variableDeclarationNode.annotations(), this.filePath.toString());
            String serviceId = displayAnnotation.getId() != null ? displayAnnotation.getId() : Integer.toString(variableDeclarationNode.hashCode());
            Connection dependency = new Connection(serviceId, GeneratorUtils.getClientModuleName((TypeSymbol)referredClassSymbol), GeneratorUtils.getSourceLocation(this.filePath.toString(), variableDeclarationNode.lineRange()), Collections.emptyList());
            this.dependencies.add(dependency);
        }
    }

    private boolean hasInvocationReferences(VariableDeclarationNode variableDeclarationNode) {
        Optional variableDeclarationNodeSymbol = this.semanticModel.symbol((Node)variableDeclarationNode);
        if (variableDeclarationNodeSymbol.isEmpty()) {
            return false;
        }
        List objFieldNodeRefs = this.semanticModel.references((Symbol)variableDeclarationNodeSymbol.get()).stream().map(Location::lineRange).collect(Collectors.toList());
        for (LineRange lineRange : objFieldNodeRefs) {
            NonTerminalNode referredNode = GeneratorUtils.findNode(this.syntaxTree, lineRange);
            while (!referredNode.kind().equals((Object)SyntaxKind.FUNCTION_DEFINITION) && !referredNode.kind().equals((Object)SyntaxKind.MODULE_PART)) {
                if (referredNode.kind().equals((Object)SyntaxKind.REMOTE_METHOD_CALL_ACTION) || referredNode.kind().equals((Object)SyntaxKind.CLIENT_RESOURCE_ACCESS_ACTION)) {
                    return true;
                }
                referredNode = referredNode.parent();
            }
        }
        return false;
    }
}

