/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.core.generators.entrypoint.nodevisitors;

import io.ballerina.architecturemodelgenerator.core.diagnostics.ArchitectureModelDiagnostic;
import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticMessage;
import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticNode;
import io.ballerina.architecturemodelgenerator.core.generators.GeneratorUtils;
import io.ballerina.architecturemodelgenerator.core.generators.entrypoint.nodevisitors.FunctionEntryPointMemberNodeVisitor;
import io.ballerina.architecturemodelgenerator.core.generators.service.nodevisitors.ActionNodeVisitor;
import io.ballerina.architecturemodelgenerator.core.model.SourceLocation;
import io.ballerina.architecturemodelgenerator.core.model.common.DisplayAnnotation;
import io.ballerina.architecturemodelgenerator.core.model.common.FunctionParameter;
import io.ballerina.architecturemodelgenerator.core.model.functionentrypoint.FunctionEntryPoint;
import io.ballerina.architecturemodelgenerator.core.model.service.Connection;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Annotatable;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class FunctionEntryPointVisitor
extends NodeVisitor {
    private final PackageCompilation packageCompilation;
    private final SemanticModel semanticModel;
    private final SyntaxTree syntaxTree;
    private final Package currentPackage;
    private FunctionEntryPoint functionEntryPoint = null;
    private final List<Connection> dependencies = new LinkedList<Connection>();
    private final Path filePath;

    public FunctionEntryPointVisitor(PackageCompilation packageCompilation, SemanticModel semanticModel, SyntaxTree syntaxTree, Package currentPackage, Path filePath) {
        this.packageCompilation = packageCompilation;
        this.semanticModel = semanticModel;
        this.syntaxTree = syntaxTree;
        this.currentPackage = currentPackage;
        this.filePath = filePath;
    }

    public FunctionEntryPoint getFunctionEntryPoint() {
        return this.functionEntryPoint;
    }

    public List<Connection> getDependencies() {
        return this.dependencies;
    }

    public void visit(FunctionDefinitionNode functionDefinitionNode) {
        if (functionDefinitionNode.functionName().text().equals("main")) {
            DisplayAnnotation annotation = null;
            Optional clientSymbol = this.semanticModel.symbol((Node)functionDefinitionNode);
            if (clientSymbol.isPresent()) {
                Annotatable annotatableSymbol = (Annotatable)clientSymbol.get();
                annotation = GeneratorUtils.getServiceAnnotation(annotatableSymbol, this.filePath.toString());
            }
            SourceLocation elementLocation = GeneratorUtils.getSourceLocation(this.filePath.toString(), functionDefinitionNode.lineRange());
            ArrayList<FunctionParameter> funcParamList = new ArrayList<FunctionParameter>();
            this.getParameters(functionDefinitionNode.functionSignature(), funcParamList);
            List<String> returnTypes = this.getMainReturnTypes(functionDefinitionNode);
            ActionNodeVisitor actionNodeVisitor = new ActionNodeVisitor(this.packageCompilation, this.semanticModel, this.currentPackage, this.filePath.toString());
            FunctionEntryPointMemberNodeVisitor functionEntryPointMemberNodeVisitor = new FunctionEntryPointMemberNodeVisitor(this.semanticModel, this.syntaxTree, this.filePath);
            ArrayList<ArchitectureModelDiagnostic> diagnostics = new ArrayList<ArchitectureModelDiagnostic>();
            try {
                functionDefinitionNode.accept((NodeVisitor)actionNodeVisitor);
                functionDefinitionNode.accept((NodeVisitor)functionEntryPointMemberNodeVisitor);
            }
            catch (Exception e) {
                DiagnosticMessage message = DiagnosticMessage.failedToGenerate(DiagnosticNode.MAIN_ENTRY_POINT, e.getMessage());
                ArchitectureModelDiagnostic diagnostic = new ArchitectureModelDiagnostic(message.getCode(), message.getDescription(), message.getSeverity(), null, null);
                diagnostics.add(diagnostic);
            }
            String functionId = annotation != null ? annotation.getId() : functionDefinitionNode.functionName().text();
            String label = annotation != null ? annotation.getLabel() : null;
            ArrayList<String> dependencyIDs = new ArrayList<String>();
            for (Connection dependency : functionEntryPointMemberNodeVisitor.getDependencies()) {
                dependencyIDs.add(dependency.getId());
            }
            this.functionEntryPoint = new FunctionEntryPoint(functionId, label, funcParamList, returnTypes, actionNodeVisitor.getInteractionList(), annotation, dependencyIDs, elementLocation, diagnostics);
            this.dependencies.addAll(functionEntryPointMemberNodeVisitor.getDependencies());
        }
    }

    private List<String> getMainReturnTypes(FunctionDefinitionNode functionDefinitionNode) {
        Optional symbol;
        ArrayList<String> returnTypes = new ArrayList<String>();
        FunctionSignatureNode functionSignature = functionDefinitionNode.functionSignature();
        Optional returnTypeDescriptor = functionSignature.returnTypeDesc();
        if (returnTypeDescriptor.isPresent() && (symbol = this.semanticModel.symbol((Node)functionDefinitionNode)).isPresent()) {
            FunctionSymbol functionSymbol = (FunctionSymbol)symbol.get();
            Optional returnTypeSymbol = functionSymbol.typeDescriptor().returnTypeDescriptor();
            returnTypeSymbol.ifPresent(typeSymbol -> returnTypes.addAll(GeneratorUtils.getReferencedType(typeSymbol, this.currentPackage)));
        }
        return returnTypes;
    }

    private void getParameters(FunctionSignatureNode functionSignatureNode, List<FunctionParameter> functionParameters) {
        SeparatedNodeList parameterNodes = functionSignatureNode.parameters();
        for (ParameterNode parameterNode : parameterNodes) {
            SourceLocation elementLocation = GeneratorUtils.getSourceLocation(this.filePath.toString(), parameterNode.lineRange());
            Optional symbol = this.semanticModel.symbol((Node)parameterNode);
            if (!symbol.isPresent() || !((Symbol)symbol.get()).kind().equals((Object)SymbolKind.PARAMETER)) continue;
            String paramName = "";
            boolean isRequired = false;
            ParameterSymbol parameterSymbol = (ParameterSymbol)symbol.get();
            TypeSymbol typeSymbol = parameterSymbol.typeDescriptor();
            List<String> paramTypes = GeneratorUtils.getReferencedType(typeSymbol, this.currentPackage);
            switch (parameterNode.kind()) {
                case REQUIRED_PARAM: {
                    RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameterNode;
                    paramName = requiredParameterNode.paramName().isPresent() ? ((Token)requiredParameterNode.paramName().get()).toString() : "";
                    isRequired = true;
                    break;
                }
                case DEFAULTABLE_PARAM: {
                    DefaultableParameterNode defaultableParameterNode = (DefaultableParameterNode)parameterNode;
                    paramName = defaultableParameterNode.paramName().isPresent() ? ((Token)defaultableParameterNode.paramName().get()).toString() : "";
                    break;
                }
            }
            functionParameters.add(new FunctionParameter(paramTypes, paramName, isRequired, elementLocation, Collections.emptyList()));
        }
    }
}

