/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.core.generators.service.nodevisitors;

import io.ballerina.architecturemodelgenerator.core.Constants;
import io.ballerina.architecturemodelgenerator.core.diagnostics.ArchitectureModelDiagnostic;
import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticMessage;
import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticNode;
import io.ballerina.architecturemodelgenerator.core.generators.GeneratorUtils;
import io.ballerina.architecturemodelgenerator.core.generators.service.nodevisitors.ActionNodeVisitor;
import io.ballerina.architecturemodelgenerator.core.model.SourceLocation;
import io.ballerina.architecturemodelgenerator.core.model.common.DisplayAnnotation;
import io.ballerina.architecturemodelgenerator.core.model.common.FunctionParameter;
import io.ballerina.architecturemodelgenerator.core.model.service.Connection;
import io.ballerina.architecturemodelgenerator.core.model.service.RemoteFunction;
import io.ballerina.architecturemodelgenerator.core.model.service.ResourceFunction;
import io.ballerina.architecturemodelgenerator.core.model.service.ResourceParameter;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ResourcePathParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ServiceMemberFunctionNodeVisitor
extends NodeVisitor {
    private final String serviceId;
    private final PackageCompilation packageCompilation;
    private final SemanticModel semanticModel;
    private final SyntaxTree syntaxTree;
    private final Package currentPackage;
    private List<ResourceFunction> resourceFunctions = new LinkedList<ResourceFunction>();
    private List<RemoteFunction> remoteFunctions = new LinkedList<RemoteFunction>();
    private final List<Connection> dependencies = new LinkedList<Connection>();
    private final String filePath;

    public ServiceMemberFunctionNodeVisitor(String serviceId, PackageCompilation packageCompilation, SemanticModel semanticModel, SyntaxTree syntaxTree, Package currentPackage, String filePath) {
        this.serviceId = serviceId;
        this.packageCompilation = packageCompilation;
        this.semanticModel = semanticModel;
        this.syntaxTree = syntaxTree;
        this.currentPackage = currentPackage;
        this.filePath = filePath;
    }

    public List<ResourceFunction> getResourceFunctions() {
        return this.resourceFunctions;
    }

    public List<RemoteFunction> getRemoteFunctions() {
        return this.remoteFunctions;
    }

    public List<Connection> getDependencies() {
        return this.dependencies;
    }

    public void visit(FunctionDefinitionNode functionDefinitionNode) {
        SourceLocation elementLocation = GeneratorUtils.getSourceLocation(this.filePath, functionDefinitionNode.lineRange());
        SyntaxKind kind = functionDefinitionNode.kind();
        switch (kind) {
            case RESOURCE_ACCESSOR_DEFINITION: {
                StringBuilder resourcePathBuilder = new StringBuilder();
                ArrayList<ResourceParameter> resourceParameterList = new ArrayList<ResourceParameter>();
                NodeList relativeResourcePaths = functionDefinitionNode.relativeResourcePath();
                for (Node path : relativeResourcePaths) {
                    if (path instanceof ResourcePathParameterNode) {
                        ResourcePathParameterNode pathParam = (ResourcePathParameterNode)path;
                        resourceParameterList.add(this.getPathParameter(pathParam));
                    }
                    resourcePathBuilder.append(path);
                }
                String resourcePath = resourcePathBuilder.toString().trim();
                String method = functionDefinitionNode.functionName().text().trim();
                String resourceId = String.format("%s:%s:%s", this.serviceId, resourcePath, method);
                this.getParameters(functionDefinitionNode.functionSignature(), true, resourceParameterList, null);
                List<String> returnTypes = this.getReturnTypes(functionDefinitionNode);
                ActionNodeVisitor actionNodeVisitor = new ActionNodeVisitor(this.packageCompilation, this.semanticModel, this.currentPackage, this.filePath);
                ArrayList<ArchitectureModelDiagnostic> diagnostics = new ArrayList<ArchitectureModelDiagnostic>();
                try {
                    functionDefinitionNode.accept((NodeVisitor)actionNodeVisitor);
                }
                catch (Exception e) {
                    DiagnosticMessage message = DiagnosticMessage.failedToGenerate(DiagnosticNode.RESOURCE, e.getMessage());
                    ArchitectureModelDiagnostic diagnostic = new ArchitectureModelDiagnostic(message.getCode(), message.getDescription(), message.getSeverity(), null, null);
                    diagnostics.add(diagnostic);
                }
                ResourceFunction resource = new ResourceFunction(resourceId, resourcePath, resourceParameterList, returnTypes, actionNodeVisitor.getInteractionList(), elementLocation, diagnostics);
                this.resourceFunctions.add(resource);
                break;
            }
            case OBJECT_METHOD_DEFINITION: {
                boolean isRemote = functionDefinitionNode.qualifierList().stream().anyMatch(item -> item.kind().equals((Object)SyntaxKind.REMOTE_KEYWORD));
                if (!isRemote) break;
                String name = functionDefinitionNode.functionName().text().trim();
                ArrayList<FunctionParameter> parameterList = new ArrayList<FunctionParameter>();
                this.getParameters(functionDefinitionNode.functionSignature(), false, null, parameterList);
                List<String> returnTypes = this.getReturnTypes(functionDefinitionNode);
                ActionNodeVisitor actionNodeVisitor = new ActionNodeVisitor(this.packageCompilation, this.semanticModel, this.currentPackage, this.filePath);
                ArrayList<ArchitectureModelDiagnostic> diagnostics = new ArrayList<ArchitectureModelDiagnostic>();
                try {
                    functionDefinitionNode.accept((NodeVisitor)actionNodeVisitor);
                }
                catch (Exception e) {
                    DiagnosticMessage message = DiagnosticMessage.failedToGenerate(DiagnosticNode.REMOTE_FUNCTION, e.getMessage());
                    ArchitectureModelDiagnostic diagnostic = new ArchitectureModelDiagnostic(message.getCode(), message.getDescription(), message.getSeverity(), null, null);
                    diagnostics.add(diagnostic);
                }
                String remoteFunctionId = String.format("%s:%s", this.serviceId, name);
                RemoteFunction remoteFunction = new RemoteFunction(remoteFunctionId, name, parameterList, returnTypes, actionNodeVisitor.getInteractionList(), elementLocation, diagnostics);
                this.remoteFunctions.add(remoteFunction);
                break;
            }
        }
    }

    private ResourceParameter getPathParameter(ResourcePathParameterNode resourcePathParameterNode) {
        SourceLocation elementLocation = GeneratorUtils.getSourceLocation(this.filePath, resourcePathParameterNode.lineRange());
        String name = ((Token)resourcePathParameterNode.paramName().get()).text();
        List<String> paramTypes = new LinkedList<String>();
        Optional symbol = this.semanticModel.symbol((Node)resourcePathParameterNode);
        if (symbol.isPresent()) {
            PathParameterSymbol parameterSymbol = (PathParameterSymbol)symbol.get();
            paramTypes = GeneratorUtils.getReferencedType(parameterSymbol.typeDescriptor(), this.currentPackage);
        }
        return new ResourceParameter(paramTypes, name, Constants.ParameterIn.PATH.getValue(), true, elementLocation, Collections.emptyList());
    }

    private void getParameters(FunctionSignatureNode functionSignatureNode, boolean isResource, List<ResourceParameter> resourceParams, List<FunctionParameter> remoteFunctionParams) {
        SeparatedNodeList parameterNodes = functionSignatureNode.parameters();
        for (ParameterNode parameterNode : parameterNodes) {
            SourceLocation elementLocation = GeneratorUtils.getSourceLocation(this.filePath, parameterNode.lineRange());
            Optional symbol = this.semanticModel.symbol((Node)parameterNode);
            if (!symbol.isPresent() || !((Symbol)symbol.get()).kind().equals((Object)SymbolKind.PARAMETER)) continue;
            String paramIn = "";
            String paramName = "";
            boolean isRequired = false;
            ParameterSymbol parameterSymbol = (ParameterSymbol)symbol.get();
            TypeSymbol typeSymbol = parameterSymbol.typeDescriptor();
            List<String> paramTypes = GeneratorUtils.getReferencedType(typeSymbol, this.currentPackage);
            switch (parameterNode.kind()) {
                case REQUIRED_PARAM: {
                    RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameterNode;
                    paramIn = this.getParameterIn((NodeList<AnnotationNode>)requiredParameterNode.annotations());
                    paramName = requiredParameterNode.paramName().isPresent() ? ((Token)requiredParameterNode.paramName().get()).toString() : "";
                    isRequired = true;
                    break;
                }
                case DEFAULTABLE_PARAM: {
                    DefaultableParameterNode defaultableParameterNode = (DefaultableParameterNode)parameterNode;
                    paramIn = this.getParameterIn((NodeList<AnnotationNode>)defaultableParameterNode.annotations());
                    paramName = defaultableParameterNode.paramName().isPresent() ? ((Token)defaultableParameterNode.paramName().get()).toString() : "";
                    break;
                }
            }
            if (isResource) {
                resourceParams.add(new ResourceParameter(paramTypes, paramName.trim(), paramIn, isRequired, elementLocation, Collections.emptyList()));
                continue;
            }
            remoteFunctionParams.add(new FunctionParameter(paramTypes, paramName, isRequired, elementLocation, Collections.emptyList()));
        }
    }

    private String getParameterIn(NodeList<AnnotationNode> annotationNodes) {
        String in = "";
        Optional<AnnotationNode> payloadAnnotation = annotationNodes.stream().filter(annot -> annot.toString().trim().equals("@http:Payload")).findAny();
        Optional<AnnotationNode> headerAnnotation = annotationNodes.stream().filter(annot -> annot.toString().trim().equals("@http:Header")).findAny();
        in = payloadAnnotation.isPresent() ? Constants.ParameterIn.BODY.getValue() : (headerAnnotation.isPresent() ? Constants.ParameterIn.HEADER.getValue() : Constants.ParameterIn.QUERY.getValue());
        return in;
    }

    private List<String> getReturnTypes(FunctionDefinitionNode functionDefinitionNode) {
        Optional symbol;
        ArrayList<String> returnTypes = new ArrayList<String>();
        FunctionSignatureNode functionSignature = functionDefinitionNode.functionSignature();
        Optional returnTypeDescriptor = functionSignature.returnTypeDesc();
        if (returnTypeDescriptor.isPresent() && ((symbol = this.semanticModel.symbol((Node)functionDefinitionNode)).isPresent() && ((Symbol)symbol.get()).kind().equals((Object)SymbolKind.METHOD) || ((Symbol)symbol.get()).kind().equals((Object)SymbolKind.RESOURCE_METHOD))) {
            MethodSymbol resourceMethodSymbol = (MethodSymbol)symbol.get();
            Optional returnTypeSymbol = resourceMethodSymbol.typeDescriptor().returnTypeDescriptor();
            returnTypeSymbol.ifPresent(typeSymbol -> returnTypes.addAll(GeneratorUtils.getReferencedType(typeSymbol, this.currentPackage)));
        }
        return returnTypes;
    }

    public void visit(ObjectFieldNode objectFieldNode) {
        boolean isClientClass;
        ClassSymbol referredClassSymbol;
        Optional fieldTypeNameSymbol;
        if (this.hasInvocationReferences(objectFieldNode)) {
            return;
        }
        Node fieldTypeName = GeneratorUtils.getReferredNode(objectFieldNode.typeName());
        if (fieldTypeName != null && (fieldTypeNameSymbol = this.semanticModel.symbol(fieldTypeName)).isPresent() && (referredClassSymbol = GeneratorUtils.getReferredClassSymbol((TypeSymbol)fieldTypeNameSymbol.get())) != null && (isClientClass = referredClassSymbol.qualifiers().stream().anyMatch(qualifier -> qualifier.equals((Object)Qualifier.CLIENT)))) {
            String serviceId = Integer.toString(objectFieldNode.hashCode());
            if (objectFieldNode.metadata().isPresent()) {
                DisplayAnnotation displayAnnotation = GeneratorUtils.getServiceAnnotation((NodeList<AnnotationNode>)((MetadataNode)objectFieldNode.metadata().get()).annotations(), this.filePath);
                serviceId = displayAnnotation.getId() != null ? displayAnnotation.getId() : Integer.toString(objectFieldNode.hashCode());
            }
            Connection dependency = new Connection(serviceId, GeneratorUtils.getClientModuleName((TypeSymbol)referredClassSymbol), GeneratorUtils.getSourceLocation(this.filePath, objectFieldNode.lineRange()), Collections.emptyList());
            this.dependencies.add(dependency);
        }
    }

    public void visit(ConstantDeclarationNode constantDeclarationNode) {
    }

    private boolean hasInvocationReferences(ObjectFieldNode clientDeclarationNode) {
        Optional objFieldNodeSymbol = this.semanticModel.symbol((Node)clientDeclarationNode);
        if (objFieldNodeSymbol.isEmpty()) {
            return false;
        }
        List objFieldNodeRefs = this.semanticModel.references((Symbol)objFieldNodeSymbol.get()).stream().map(Location::lineRange).collect(Collectors.toList());
        for (LineRange lineRange : objFieldNodeRefs) {
            NonTerminalNode referredNode = GeneratorUtils.findNode(this.syntaxTree, lineRange);
            while (!referredNode.kind().equals((Object)SyntaxKind.SERVICE_DECLARATION) && !referredNode.kind().equals((Object)SyntaxKind.MODULE_PART)) {
                if (referredNode.kind().equals((Object)SyntaxKind.REMOTE_METHOD_CALL_ACTION) || referredNode.kind().equals((Object)SyntaxKind.CLIENT_RESOURCE_ACCESS_ACTION)) {
                    return true;
                }
                referredNode = referredNode.parent();
            }
        }
        return false;
    }
}

