/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.core.model;

public class SourceLocation {
    private final String filePath;
    private final LinePosition startPosition;
    private final LinePosition endPosition;

    private SourceLocation(String filePath, LinePosition startPosition, LinePosition endPosition) {
        this.filePath = filePath;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    public static SourceLocation from(String filePath, LinePosition startLine, LinePosition endLine) {
        return new SourceLocation(filePath, startLine, endLine);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public LinePosition getStartPosition() {
        return this.startPosition;
    }

    public LinePosition getEndPosition() {
        return this.endPosition;
    }

    public static class LinePosition {
        private final int line;
        private final int offset;

        private LinePosition(int line, int offset) {
            this.line = line;
            this.offset = offset;
        }

        public static LinePosition from(int line, int offset) {
            return new LinePosition(line, offset);
        }

        public int getLine() {
            return this.line;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

