/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.artifactsgenerator;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.designmodelgenerator.core.CommonUtils;
import io.ballerina.runtime.api.utils.IdentifierUtils;
import io.ballerina.tools.text.LineRange;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public record Artifact(String id, LineRange location, String type, String name, String accessor, String scope, String icon, String module, Map<String, Artifact> children) {
    private static final String CATEGORY_ENTRY_POINTS = "Entry Points";
    private static final String CATEGORY_RESOURCES = "Resources";
    private static final String CATEGORY_REMOTE_METHODS = "Remote Methods";
    private static final String CATEGORY_FUNCTIONS = "Functions";
    private static final String CATEGORY_NATURAL_FUNCTIONS = "Natural Functions";
    private static final String CATEGORY_DATA_MAPPERS = "Data Mappers";
    private static final String CATEGORY_LISTENERS = "Listeners";
    private static final String CATEGORY_CONFIGURATIONS = "Configurations";
    private static final String CATEGORY_TYPES = "Types";
    private static final String CATEGORY_CONNECTIONS = "Connections";
    private static final String CATEGORY_VARIABLES = "Variables";
    private static final String CATEGORY_DEFAULT = "Others";
    private static final Map<String, String> typeCategoryMap = Map.ofEntries(Map.entry(Type.SERVICE.name(), "Entry Points"), Map.entry(Type.AUTOMATION.name(), "Entry Points"), Map.entry(Type.RESOURCE.name(), "Resources"), Map.entry(Type.REMOTE.name(), "Remote Methods"), Map.entry(Type.FUNCTION.name(), "Functions"), Map.entry(Type.NP_FUNCTION.name(), "Natural Functions"), Map.entry(Type.DATA_MAPPER.name(), "Data Mappers"), Map.entry(Type.LISTENER.name(), "Listeners"), Map.entry(Type.CONFIGURABLE.name(), "Configurations"), Map.entry(Type.TYPE.name(), "Types"), Map.entry(Type.CONNECTION.name(), "Connections"), Map.entry(Type.VARIABLE.name(), "Variables"));
    private static final Map<String, String> entryPointMap = Map.ofEntries(Map.entry("http", "HTTP Service"), Map.entry("graphql", "GraphQL Service"), Map.entry("tcp", "TCP Service"), Map.entry("file", "Directory Service"), Map.entry("ftp", "FTP Service"), Map.entry("mqtt", "MQTT Event Handler"), Map.entry("asb", "Azure Service Bus Event Handler"), Map.entry("rabbitmq", "RabbitMQ Event Handler"), Map.entry("kafka", "Kafka Event Handler"), Map.entry("salesforce", "Salesforce Event Handler"), Map.entry("github", "GitHub Event Handler"), Map.entry("ai", "AI Agent Services"));

    public Artifact {
        children = children == null ? Collections.emptyMap() : Collections.unmodifiableMap(children);
    }

    public static String getCategory(String type) {
        return typeCategoryMap.getOrDefault(type, CATEGORY_DEFAULT);
    }

    public static Artifact emptyArtifact(String id) {
        return new Artifact(id, null, null, null, null, null, null, null, null);
    }

    public static enum Type {
        SERVICE,
        AUTOMATION,
        RESOURCE,
        REMOTE,
        FUNCTION,
        NP_FUNCTION,
        DATA_MAPPER,
        LISTENER,
        CONFIGURABLE,
        TYPE,
        CONNECTION,
        VARIABLE;

    }

    public static class Builder {
        private String id;
        private LineRange location;
        private Type type;
        private String name;
        private String accessor;
        private Scope scope = Scope.GLOBAL;
        private String icon;
        private String module;
        private final Map<String, Artifact> children = new HashMap<String, Artifact>();

        public Builder(Node node) {
            this.location = node.lineRange();
        }

        public Builder node(Node node) {
            this.location = node.lineRange();
            return this;
        }

        public Builder locationId() {
            if (this.location == null) {
                return this;
            }
            this.id = String.valueOf(Objects.hash(this.location.fileName(), this.location.startLine(), this.location.endLine()));
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder accessor(String accessor) {
            this.accessor = accessor;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder icon(Symbol symbol) {
            Optional moduleSymbol = symbol.getModule();
            if (moduleSymbol.isEmpty()) {
                return this;
            }
            ModuleID moduleId = ((ModuleSymbol)moduleSymbol.get()).id();
            this.icon = CommonUtils.generateIcon(moduleId);
            this.module = moduleId.moduleName();
            return this;
        }

        public Builder child(Artifact child) {
            if (child != null && child.id() != null) {
                this.children.put(child.id(), child);
            }
            return this;
        }

        public Builder serviceNameWithPath(String path) {
            this.name = this.module == null || !entryPointMap.containsKey(this.module) ? path : entryPointMap.get(this.module) + " - " + path;
            return this;
        }

        public Builder serviceName(String name) {
            this.name = this.module == null || !entryPointMap.containsKey(this.module) ? name : entryPointMap.get(this.module);
            return this;
        }

        public Artifact build() {
            if (this.accessor != null) {
                this.id = this.id == null ? this.accessor + "#" + this.name : this.id;
                this.accessor = IdentifierUtils.unescapeBallerina((String)this.accessor);
            } else {
                this.id = this.id == null ? this.name : this.id;
            }
            this.name = IdentifierUtils.unescapeBallerina((String)this.name);
            return new Artifact(this.id, this.location, this.type == null ? null : this.type.name(), this.name, this.accessor, this.scope.getValue(), this.icon, this.module, new HashMap<String, Artifact>(this.children));
        }
    }

    public static enum Scope {
        GLOBAL("Global"),
        LOCAL("Local"),
        OBJECT("Object");

        private final String value;

        private Scope(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

