/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.designmodelgenerator.core;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassFieldSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.designmodelgenerator.core.CommonUtils;
import io.ballerina.designmodelgenerator.core.IntermediateModel;
import io.ballerina.designmodelgenerator.core.model.Connection;
import io.ballerina.designmodelgenerator.core.model.Location;
import io.ballerina.tools.text.LineRange;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ConnectionFinder {
    private final SemanticModel semanticModel;
    private final Map<String, ModulePartNode> documentMap;
    private final Path rootPath;
    private final IntermediateModel intermediateModel;

    public ConnectionFinder(SemanticModel semanticModel, Path rootPath, Map<String, ModulePartNode> documentMap, IntermediateModel intermediateModel) {
        this.semanticModel = semanticModel;
        this.documentMap = documentMap;
        this.rootPath = rootPath;
        this.intermediateModel = intermediateModel;
    }

    public void findConnection(Symbol symbol, List<String> referenceLocations) {
        block18: {
            List references;
            String hashKey;
            block16: {
                ClassFieldSymbol classFieldSymbol;
                block17: {
                    ObjectFieldNode objectFieldNode;
                    block19: {
                        hashKey = String.valueOf(((io.ballerina.tools.diagnostics.Location)symbol.getLocation().get()).hashCode());
                        referenceLocations.add(hashKey);
                        if (this.intermediateModel.connectionMap.containsKey(hashKey)) {
                            Connection connection = this.intermediateModel.connectionMap.get(hashKey);
                            for (String refLocation : referenceLocations) {
                                this.intermediateModel.connectionMap.put(refLocation, connection);
                                this.intermediateModel.uuidToConnectionMap.put(connection.getUuid(), connection);
                            }
                        }
                        if (!(symbol instanceof ClassFieldSymbol)) break block16;
                        classFieldSymbol = (ClassFieldSymbol)symbol;
                        if (!classFieldSymbol.hasDefaultValue()) break block17;
                        io.ballerina.tools.diagnostics.Location location = (io.ballerina.tools.diagnostics.Location)classFieldSymbol.getLocation().get();
                        ModulePartNode modulePartNode = this.documentMap.get(location.lineRange().fileName());
                        NonTerminalNode node = modulePartNode.findNode(location.textRange());
                        if (!(node instanceof ObjectFieldNode)) break block18;
                        objectFieldNode = (ObjectFieldNode)node;
                        if (!this.isNewConnection(objectFieldNode.expression().orElse(null))) break block19;
                        LineRange lineRange = node.lineRange();
                        String sortText = lineRange.fileName() + lineRange.startLine().line();
                        String icon = CommonUtils.generateIcon(classFieldSymbol.typeDescriptor());
                        Connection connection = new Connection(objectFieldNode.fieldName().text(), sortText, this.getLocation(lineRange), Connection.Scope.LOCAL, icon);
                        for (String refLocation : referenceLocations) {
                            this.intermediateModel.connectionMap.put(String.valueOf(refLocation), connection);
                            this.intermediateModel.uuidToConnectionMap.put(connection.getUuid(), connection);
                        }
                        break block18;
                    }
                    Optional valueSymbol = this.semanticModel.symbol((Node)objectFieldNode.expression().get());
                    if (!valueSymbol.isPresent()) break block18;
                    this.findConnection((Symbol)valueSymbol.get(), referenceLocations);
                    break block18;
                }
                references = this.semanticModel.references((Symbol)classFieldSymbol);
                for (io.ballerina.tools.diagnostics.Location location : references) {
                    ModulePartNode modulePartNode = this.documentMap.get(location.lineRange().fileName());
                    NonTerminalNode node = modulePartNode.findNode(location.textRange()).parent();
                    if (!(node instanceof AssignmentStatementNode)) continue;
                    AssignmentStatementNode assignmentStatementNode = (AssignmentStatementNode)node;
                    if (this.isNewConnection(assignmentStatementNode.expression())) {
                        LineRange lineRange = node.lineRange();
                        String sortText = lineRange.fileName() + lineRange.startLine().line();
                        String icon = CommonUtils.generateIcon(classFieldSymbol.typeDescriptor());
                        Connection connection = new Connection((String)symbol.getName().get(), sortText, this.getLocation(lineRange), Connection.Scope.LOCAL, icon);
                        for (String string : referenceLocations) {
                            this.intermediateModel.connectionMap.put(String.valueOf(string), connection);
                            this.intermediateModel.uuidToConnectionMap.put(connection.getUuid(), connection);
                        }
                        continue;
                    }
                    Optional valueSymbol = this.semanticModel.symbol((Node)assignmentStatementNode.expression());
                    if (!valueSymbol.isPresent()) continue;
                    this.findConnection((Symbol)valueSymbol.get(), referenceLocations);
                }
                break block18;
            }
            if (symbol instanceof VariableSymbol) {
                VariableSymbol variableSymbol = (VariableSymbol)symbol;
                if (this.intermediateModel.connectionMap.containsKey(hashKey)) {
                    Connection connection = this.intermediateModel.connectionMap.get(hashKey);
                    for (String refLocation : referenceLocations) {
                        this.intermediateModel.connectionMap.put(refLocation, connection);
                        this.intermediateModel.uuidToConnectionMap.put(connection.getUuid(), connection);
                    }
                } else {
                    references = this.semanticModel.references((Symbol)variableSymbol);
                    for (io.ballerina.tools.diagnostics.Location location : references) {
                        Optional valueSymbol;
                        String sortText;
                        LineRange lineRange;
                        ModulePartNode modulePartNode = this.documentMap.get(location.lineRange().fileName());
                        NonTerminalNode node = modulePartNode.findNode(location.textRange()).parent();
                        if (node instanceof VariableDeclarationNode) {
                            VariableDeclarationNode variableDeclarationNode = (VariableDeclarationNode)node;
                            if (this.isNewConnection(variableDeclarationNode.initializer().orElse(null))) {
                                lineRange = node.lineRange();
                                sortText = lineRange.fileName() + lineRange.startLine().line();
                                String icon = CommonUtils.generateIcon(variableSymbol.typeDescriptor());
                                Connection connection = new Connection((String)symbol.getName().get(), sortText, this.getLocation(lineRange), Connection.Scope.LOCAL, icon, true);
                                for (String refLocation : referenceLocations) {
                                    this.intermediateModel.connectionMap.put(String.valueOf(refLocation), connection);
                                    this.intermediateModel.uuidToConnectionMap.put(connection.getUuid(), connection);
                                }
                                continue;
                            }
                            if (!variableDeclarationNode.initializer().isPresent() || !(valueSymbol = this.semanticModel.symbol((Node)variableDeclarationNode.initializer().get())).isPresent()) continue;
                            this.findConnection((Symbol)valueSymbol.get(), referenceLocations);
                            continue;
                        }
                        if (!(node instanceof AssignmentStatementNode)) continue;
                        AssignmentStatementNode assignmentStatementNode = (AssignmentStatementNode)node;
                        if (this.isNewConnection(assignmentStatementNode.expression())) {
                            lineRange = node.lineRange();
                            sortText = lineRange.fileName() + lineRange.startLine().line();
                            Connection connection = new Connection((String)symbol.getName().get(), sortText, this.getLocation(lineRange), Connection.Scope.LOCAL, "");
                            for (String string : referenceLocations) {
                                this.intermediateModel.connectionMap.put(String.valueOf(string), connection);
                                this.intermediateModel.uuidToConnectionMap.put(connection.getUuid(), connection);
                            }
                            continue;
                        }
                        valueSymbol = this.semanticModel.symbol((Node)assignmentStatementNode.expression());
                        if (!valueSymbol.isPresent()) continue;
                        this.findConnection((Symbol)valueSymbol.get(), referenceLocations);
                    }
                }
            }
        }
    }

    private boolean isNewConnection(ExpressionNode expressionNode) {
        ExpressionNode expressionNode2 = expressionNode;
        Objects.requireNonNull(expressionNode2);
        ExpressionNode expressionNode3 = expressionNode2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ImplicitNewExpressionNode.class, ExplicitNewExpressionNode.class, CheckExpressionNode.class}, (Object)expressionNode3, n)) {
            case 0 -> {
                ImplicitNewExpressionNode ignored = (ImplicitNewExpressionNode)expressionNode3;
                yield true;
            }
            case 1 -> {
                ExplicitNewExpressionNode ignored = (ExplicitNewExpressionNode)expressionNode3;
                yield true;
            }
            case 2 -> {
                CheckExpressionNode checkExpressionNode = (CheckExpressionNode)expressionNode3;
                yield this.isNewConnection(checkExpressionNode.expression());
            }
            default -> false;
        };
    }

    public Location getLocation(LineRange lineRange) {
        Path filePath = this.rootPath.resolve(lineRange.fileName());
        return new Location(filePath.toAbsolutePath().toString(), lineRange.startLine(), lineRange.endLine());
    }
}

