/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.designmodelgenerator.core.model;

import io.ballerina.designmodelgenerator.core.model.DesignGraphNode;
import io.ballerina.designmodelgenerator.core.model.Location;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Connection
extends DesignGraphNode {
    private final String symbol;
    private Location location;
    private final Scope scope;
    private final String icon;
    private final Set<String> dependentFunctions;
    private final Set<String> dependentConnection;

    public Connection(String symbol, String sortText, Location location, Scope scope, String icon) {
        super(sortText);
        this.symbol = symbol;
        this.location = location;
        this.scope = scope;
        this.icon = icon;
        this.dependentFunctions = new HashSet<String>();
        this.dependentConnection = new HashSet<String>();
    }

    public Connection(String symbol, String sortText, Location location, Scope scope, String icon, boolean enableFlow) {
        super(enableFlow, sortText);
        this.symbol = symbol;
        this.location = location;
        this.scope = scope;
        this.icon = icon;
        this.dependentFunctions = new HashSet<String>();
        this.dependentConnection = new HashSet<String>();
    }

    public String getIcon() {
        return this.icon;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Location getLocation() {
        return this.location;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Set<String> getDependentFunctions() {
        return this.dependentFunctions;
    }

    public void addDependentFunction(String dependentFunction) {
        this.dependentFunctions.add(dependentFunction);
    }

    public Set<String> getDependentConnection() {
        return this.dependentConnection;
    }

    public void addDependentConnection(String dependentConnection) {
        this.dependentConnection.add(dependentConnection);
    }

    public int hashCode() {
        return Objects.hash(this.symbol.hashCode(), this.location.hashCode(), this.scope.hashCode());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Connection)) {
            return false;
        }
        Connection connection = (Connection)obj;
        return Objects.equals(connection.getUuid(), this.getUuid());
    }

    public static enum Scope {
        LOCAL,
        GLOBAL;

    }
}

