/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.designmodelgenerator.core.model;

import io.ballerina.designmodelgenerator.core.model.DesignGraphNode;
import io.ballerina.designmodelgenerator.core.model.Function;
import io.ballerina.designmodelgenerator.core.model.Location;
import io.ballerina.designmodelgenerator.core.model.ResourceFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Service
extends DesignGraphNode {
    private final String displayName;
    private final Location location;
    private final List<String> attachedListeners;
    private final List<String> connections;
    private final List<Function> functions;
    private final List<Function> remoteFunctions;
    private final List<ResourceFunction> resourceFunctions;
    private final String absolutePath;
    private String type;
    private String icon;

    public Service(String name, String absolutePath, Location location, String sortText, List<String> connections, List<Function> functions, List<Function> remoteFunctions, List<ResourceFunction> resourceFunctions) {
        super(true, sortText);
        this.displayName = name;
        this.absolutePath = absolutePath;
        this.location = location;
        this.connections = connections;
        this.functions = functions;
        this.remoteFunctions = remoteFunctions;
        this.resourceFunctions = resourceFunctions;
        this.attachedListeners = new ArrayList<String>();
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addAttachedListener(String listener) {
        this.attachedListeners.add(listener);
    }

    public String getIcon() {
        return this.icon;
    }

    public String getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Location getLocation() {
        return this.location;
    }

    public List<String> getAttachedListeners() {
        return this.attachedListeners;
    }

    public List<String> getConnections() {
        return this.connections;
    }

    public List<Function> getFunctions() {
        return this.functions;
    }

    public List<Function> getRemoteFunctions() {
        return this.remoteFunctions;
    }

    public List<ResourceFunction> getResourceFunctions() {
        return this.resourceFunctions;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.type, this.absolutePath, this.attachedListeners.size(), this.connections.size(), this.functions.stream().map(Function::hashCode).reduce(0, Integer::sum), this.remoteFunctions.stream().map(Function::hashCode).reduce(0, Integer::sum), this.resourceFunctions.stream().map(ResourceFunction::hashCode).reduce(0, Integer::sum));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Service)) {
            return false;
        }
        Service service = (Service)obj;
        return service.displayName != null && service.displayName.equals(this.displayName) && Objects.equals(service.type, this.type) && service.absolutePath.equals(this.absolutePath) && service.attachedListeners.size() == this.attachedListeners.size() && service.connections.size() == this.connections.size() && service.functions.size() == this.functions.size() && service.remoteFunctions.size() == this.remoteFunctions.size() && service.resourceFunctions.size() == this.resourceFunctions.size();
    }
}

