/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.ldap;

import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncResultListener;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import io.ballerina.lib.ldap.Client;
import io.ballerina.lib.ldap.Utils;
import java.util.concurrent.CompletableFuture;

public class CustomAsyncResultListener
implements AsyncResultListener {
    private final CompletableFuture<Object> future;

    public CustomAsyncResultListener(CompletableFuture<Object> future) {
        this.future = future;
    }

    public void ldapResultReceived(AsyncRequestID requestID, LDAPResult ldapResult) {
        if (!ldapResult.getResultCode().equals((Object)ResultCode.SUCCESS)) {
            LDAPException ldapException = new LDAPException(ldapResult);
            this.future.complete(Utils.createError(ldapException.getMessage(), ldapException));
            return;
        }
        this.future.complete(Client.generateLdapResponse(ldapResult));
    }
}

