/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.tooling.codeaction.providers.kubernetes;

import io.ballerina.c2c.tooling.codeaction.providers.kubernetes.ProbeBasedDiagnosticAction;
import io.ballerina.c2c.tooling.toml.CommonUtil;
import io.ballerina.c2c.tooling.toml.Probe;
import io.ballerina.c2c.tooling.toml.TomlSyntaxTreeUtil;
import io.ballerina.c2c.util.ListenerInfo;
import io.ballerina.c2c.util.ProjectServiceInfo;
import io.ballerina.c2c.util.ServiceInfo;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.projects.Project;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public abstract class AbstractInvalidResourceCodeAction
extends ProbeBasedDiagnosticAction {
    public List<CodeAction> addResourceToService(Diagnostic diagnostic, CodeActionContext ctx, Probe probe) {
        Optional project = ctx.workspace().project(ctx.filePath());
        ProjectServiceInfo projectServiceInfo = new ProjectServiceInfo((Project)project.orElseThrow());
        List<ServiceInfo> serviceList = projectServiceInfo.getServiceList();
        ArrayList<CodeAction> codeActionList = new ArrayList<CodeAction>();
        block0: for (ServiceInfo service : serviceList) {
            String filePath = service.getNode().syntaxTree().filePath();
            for (ListenerInfo listener : service.getListeners()) {
                int port = listener.getPort();
                if (probe.getPort().getValue() != port) continue;
                Path balFilePath = ctx.workspace().projectRoot(ctx.filePath()).resolve(filePath);
                NodeList<Node> members = service.getNode().members();
                Node lastResource = members.get(members.size() - 1);
                Position position = new Position(lastResource.lineRange().endLine().line() + 1, 0);
                CodeAction action = new CodeAction();
                action.setKind("quickfix");
                String importText = this.generateProbeFunctionText(service, probe);
                List<TextEdit> edits = Collections.singletonList(new TextEdit(new Range(position, position), importText));
                action.setEdit(new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(balFilePath.toUri().toString(), null), edits)))));
                action.setTitle("Add Resource to Service");
                ArrayList<Diagnostic> cursorDiagnostics = new ArrayList<Diagnostic>();
                cursorDiagnostics.add(diagnostic);
                action.setDiagnostics(cursorDiagnostics);
                codeActionList.add(action);
                continue block0;
            }
        }
        return codeActionList;
    }

    private String generateProbeFunctionText(ServiceInfo service, Probe probe) {
        String serviceName;
        String tomlPath = TomlSyntaxTreeUtil.trimResourcePath(probe.getPath().getValue());
        String serviceResourcePath = tomlPath.equals(serviceName = TomlSyntaxTreeUtil.trimResourcePath(service.getServicePath())) ? "." : (serviceName.equals("") ? tomlPath : (tomlPath.startsWith(serviceName) ? tomlPath.substring(serviceName.length() + 1) : tomlPath));
        return String.format("    resource function get %s() returns boolean {%s        return true;%s    }%s", serviceResourcePath, CommonUtil.LINE_SEPARATOR, CommonUtil.LINE_SEPARATOR, CommonUtil.LINE_SEPARATOR);
    }
}

