/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.tooling.completion;

import io.ballerina.c2c.tooling.completion.CloudTomlCompletionContext;
import io.ballerina.c2c.tooling.completion.CloudTomlCompletionUtil;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.ballerinalang.langserver.commons.CompletionContext;
import org.ballerinalang.langserver.commons.CompletionExtension;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionParams;

public class CloudCompletionExtension
implements CompletionExtension {
    public boolean validate(CompletionParams inputParams) {
        String uri = inputParams.getTextDocument().getUri();
        Path fileNamePath = Paths.get(URI.create(uri)).getFileName();
        if (fileNamePath == null) {
            return false;
        }
        String fileName = fileNamePath.toString();
        return fileName.equals("Cloud.toml");
    }

    public List<CompletionItem> execute(CompletionParams inputParams, CompletionContext context, LanguageServerContext serverContext) throws Throwable {
        CloudTomlCompletionContext cloudContext = new CloudTomlCompletionContext(context, serverContext);
        return CloudTomlCompletionUtil.getCompletionItems(cloudContext, serverContext);
    }
}

