/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.util;

import io.ballerina.c2c.util.C2CDiagnosticCodes;
import io.ballerina.c2c.util.ListenerInfo;
import io.ballerina.c2c.util.ResourceInfo;
import io.ballerina.c2c.util.ScheduledTask;
import io.ballerina.c2c.util.ServiceInfo;
import io.ballerina.c2c.util.Task;
import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class C2CVisitor
extends NodeVisitor {
    private final List<ServiceInfo> services = new ArrayList<ServiceInfo>();
    private final Map<String, Node> moduleLevelVariables;
    private final SemanticModel semanticModel;
    private final List<Diagnostic> diagnostics;
    private Task task = null;

    public C2CVisitor(Map<String, Node> moduleLevelVariables, SemanticModel semanticModel, List<Diagnostic> diagnostics) {
        this.moduleLevelVariables = moduleLevelVariables;
        this.semanticModel = semanticModel;
        this.diagnostics = diagnostics;
    }

    @Override
    public void visit(FunctionDefinitionNode functionDefinitionNode) {
        Optional<MetadataNode> metadata = functionDefinitionNode.metadata();
        String funcName = functionDefinitionNode.functionName().text();
        if (!funcName.equals("main")) {
            return;
        }
        if (metadata.isEmpty()) {
            return;
        }
        this.processFunctionAnnotation(metadata.get());
    }

    private void processFunctionAnnotation(MetadataNode metadataNode) {
        NodeList<AnnotationNode> annotations = metadataNode.annotations();
        for (AnnotationNode annotationNode : annotations) {
            Node node = annotationNode.annotReference();
            if (node.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) continue;
            QualifiedNameReferenceNode node1 = (QualifiedNameReferenceNode)node;
            String modulePrefix = node1.modulePrefix().text();
            String name = node1.identifier().text();
            if (!modulePrefix.equals("cloud") || !name.equals("Task")) continue;
            this.task = new Task();
            this.processTaskAnnotationValue(annotationNode);
        }
    }

    private void processTaskAnnotationValue(AnnotationNode annotationNode) {
        if (annotationNode.annotValue().isEmpty()) {
            return;
        }
        MappingConstructorExpressionNode mappingConstructorExpressionNode = annotationNode.annotValue().get();
        SeparatedNodeList<MappingFieldNode> fields = mappingConstructorExpressionNode.fields();
        for (MappingFieldNode field : fields) {
            SpecificFieldNode specificField;
            if (field.kind() != SyntaxKind.SPECIFIC_FIELD || !"schedule".equals(this.getNameOfIdentifier((specificField = (SpecificFieldNode)field).fieldName()))) continue;
            Optional<ExpressionNode> expressionNode = specificField.valueExpr();
            expressionNode.ifPresent(this::processTaskScheduleBlock);
        }
    }

    private String getNameOfIdentifier(Node node) {
        if (node.kind() == SyntaxKind.IDENTIFIER_TOKEN) {
            return ((IdentifierToken)node).text();
        }
        return null;
    }

    private void processTaskScheduleBlock(ExpressionNode expressionNode) {
        if (expressionNode.kind() != SyntaxKind.MAPPING_CONSTRUCTOR) {
            return;
        }
        MappingConstructorExpressionNode expressionNode1 = (MappingConstructorExpressionNode)expressionNode;
        SeparatedNodeList<MappingFieldNode> scheduleFields = expressionNode1.fields();
        String minutes = null;
        String hours = null;
        String dayOfMonth = null;
        String monthOfYear = null;
        String daysOfWeek = null;
        for (MappingFieldNode timeField : scheduleFields) {
            if (timeField.kind() != SyntaxKind.SPECIFIC_FIELD) continue;
            SpecificFieldNode timeSpecificField = (SpecificFieldNode)timeField;
            String identifier = this.getNameOfIdentifier(timeSpecificField.fieldName());
            timeSpecificField.valueExpr();
            switch (Objects.requireNonNull(identifier)) {
                case "minutes": {
                    minutes = this.extractString(timeSpecificField.valueExpr().get());
                    break;
                }
                case "hours": {
                    hours = this.extractString(timeSpecificField.valueExpr().get());
                    break;
                }
                case "dayOfMonth": {
                    dayOfMonth = this.extractString(timeSpecificField.valueExpr().get());
                    break;
                }
                case "monthOfYear": {
                    monthOfYear = this.extractString(timeSpecificField.valueExpr().get());
                    break;
                }
                case "daysOfWeek": {
                    daysOfWeek = this.extractString(timeSpecificField.valueExpr().get());
                    break;
                }
            }
        }
        this.task = new ScheduledTask(minutes, hours, dayOfMonth, monthOfYear, daysOfWeek);
    }

    private String extractString(ExpressionNode expressionNode) {
        if (expressionNode.kind() == SyntaxKind.STRING_LITERAL) {
            String text = ((BasicLiteralNode)expressionNode).literalToken().text();
            return text.substring(1, text.length() - 1);
        }
        this.diagnostics.add(C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.VALUE_STRING_ONLY_SUPPORTED, expressionNode.location(), new Object[0]));
        return null;
    }

    @Override
    public void visit(ServiceDeclarationNode serviceDeclarationNode) {
        ServiceDeclarationSymbol symbol = (ServiceDeclarationSymbol)this.semanticModel.symbol((Node)serviceDeclarationNode).orElseThrow();
        List typeSymbols = symbol.listenerTypes();
        if (typeSymbols.isEmpty()) {
            return;
        }
        String servicePath = this.toAbsoluteServicePath(serviceDeclarationNode.absoluteResourcePath());
        if (!this.isC2CNativelySupportedListener(typeSymbols)) {
            this.processCustomExposedAnnotatedListeners(typeSymbols, servicePath, serviceDeclarationNode);
            return;
        }
        List<ListenerInfo> listenerInfos = this.extractListeners(serviceDeclarationNode, servicePath);
        if (listenerInfos.size() == 0) {
            return;
        }
        ServiceInfo serviceInfo = new ServiceInfo(listenerInfos, serviceDeclarationNode, servicePath);
        NodeList<Node> function = serviceDeclarationNode.members();
        for (Node node : function) {
            if (node.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) {
                FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)node;
                String httpMethod = functionDefinitionNode.functionName().text();
                String resourcePath = this.toAbsoluteServicePath(functionDefinitionNode.relativeResourcePath());
                serviceInfo.addResource(new ResourceInfo(functionDefinitionNode, httpMethod, resourcePath));
            }
            this.visitSyntaxNode(node);
        }
        this.services.add(serviceInfo);
    }

    private List<ListenerInfo> extractListeners(ServiceDeclarationNode serviceDeclarationNode, String servicePath) {
        SeparatedNodeList<ExpressionNode> expressions = serviceDeclarationNode.expressions();
        ArrayList<ListenerInfo> listeners = new ArrayList<ListenerInfo>();
        for (ExpressionNode expressionNode : expressions) {
            ListenerInfo listenerInfo = null;
            if (expressionNode.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
                SimpleNameReferenceNode referenceNode = (SimpleNameReferenceNode)expressionNode;
                String listenerName = referenceNode.name().text();
                Optional<ListenerInfo> httpsListener = this.getHttpListener(listenerName);
                if (httpsListener.isEmpty()) {
                    this.diagnostics.add(C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.FAILED_PORT_RETRIEVAL, expressionNode.location(), new Object[0]));
                    return Collections.emptyList();
                }
                listenerInfo = httpsListener.get();
            } else {
                if (expressionNode.kind() != SyntaxKind.EXPLICIT_NEW_EXPRESSION) {
                    return Collections.emptyList();
                }
                ExplicitNewExpressionNode refNode = (ExplicitNewExpressionNode)expressionNode;
                FunctionArgumentNode functionArgumentNode = refNode.parenthesizedArgList().arguments().get(0);
                if (functionArgumentNode.kind() == SyntaxKind.POSITIONAL_ARG) {
                    ExpressionNode expression = ((PositionalArgumentNode)functionArgumentNode).expression();
                    Optional<ListenerInfo> newListenerInfo = this.getListenerInfo(servicePath, expression);
                    if (newListenerInfo.isEmpty()) {
                        return Collections.emptyList();
                    }
                    listenerInfo = newListenerInfo.get();
                }
            }
            if (listenerInfo == null) continue;
            listeners.add(listenerInfo);
        }
        return listeners;
    }

    private Optional<ListenerInfo> extractListenerInitializer(String listenerName, ImplicitNewExpressionNode initializerNode, int paramNo) {
        ParenthesizedArgList parenthesizedArgList = initializerNode.parenthesizedArgList().get();
        SeparatedNodeList<FunctionArgumentNode> arguments = parenthesizedArgList.arguments();
        if (arguments.size() == 0) {
            return Optional.empty();
        }
        if (arguments.size() > paramNo) {
            NamedArgumentNode namedArgumentNode;
            FunctionArgumentNode functionArgumentNode = arguments.get(paramNo);
            if (functionArgumentNode.kind() == SyntaxKind.POSITIONAL_ARG) {
                ExpressionNode expression = ((PositionalArgumentNode)functionArgumentNode).expression();
                if (expression.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
                    return this.getListenerInfo(listenerName, expression);
                }
                if (expression instanceof BasicLiteralNode) {
                    BasicLiteralNode basicLiteralNode = (BasicLiteralNode)expression;
                    int port = Integer.parseInt(basicLiteralNode.literalToken().text());
                    return Optional.of(new ListenerInfo(listenerName, port));
                }
            } else if (functionArgumentNode.kind() == SyntaxKind.NAMED_ARG && (namedArgumentNode = (NamedArgumentNode)functionArgumentNode).argumentName().name().text().equals("port")) {
                ExpressionNode expression = namedArgumentNode.expression();
                if (expression.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
                    return this.getListenerInfo(listenerName, expression);
                }
                if (expression instanceof BasicLiteralNode) {
                    BasicLiteralNode basicLiteralNode = (BasicLiteralNode)expression;
                    int port = Integer.parseInt(basicLiteralNode.literalToken().text());
                    return Optional.of(new ListenerInfo(listenerName, port));
                }
            }
        }
        return Optional.empty();
    }

    private Optional<ListenerInfo> getListenerInfo(String path, ExpressionNode expression) {
        if (expression.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            SimpleNameReferenceNode referenceNode = (SimpleNameReferenceNode)expression;
            String variableName = referenceNode.name().text();
            Optional<Integer> port = this.getPortNumberFromVariable(variableName);
            if (port.isEmpty()) {
                Optional<ListenerInfo> httpsListener = this.getHttpListener(variableName);
                if (httpsListener.isEmpty()) {
                    this.diagnostics.add(C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.FAILED_PORT_RETRIEVAL, expression.location(), new Object[0]));
                    return Optional.empty();
                }
                return httpsListener;
            }
            int portNumber = port.get();
            if (portNumber == 0) {
                return Optional.empty();
            }
            return Optional.of(new ListenerInfo(path, portNumber));
        }
        int port = Integer.parseInt(((BasicLiteralNode)expression).literalToken().text());
        return Optional.of(new ListenerInfo(path, port));
    }

    private void processCustomExposedAnnotatedListeners(List<TypeSymbol> typeSymbols, String servicePath, ServiceDeclarationNode serviceDeclarationNode) {
        ArrayList<ListenerInfo> listenerInfos = new ArrayList<ListenerInfo>();
        for (int listenerIndex = 0; listenerIndex < typeSymbols.size(); ++listenerIndex) {
            MethodSymbol initSymbol;
            Optional paramsList;
            ClassSymbol classSymbol;
            Symbol typeDefinition;
            TypeSymbol typeSymbol = typeSymbols.get(listenerIndex);
            if (typeSymbol.typeKind() != TypeDescKind.TYPE_REFERENCE || (typeDefinition = ((TypeReferenceTypeSymbol)typeSymbol).definition()).kind() != SymbolKind.CLASS || (classSymbol = (ClassSymbol)typeDefinition).initMethod().isEmpty() || (paramsList = (initSymbol = (MethodSymbol)classSymbol.initMethod().get()).typeDescriptor().params()).isEmpty()) continue;
            List params = (List)paramsList.get();
            int getSize = params.size();
            for (int i = 0; i < getSize; ++i) {
                ParameterSymbol parameterSymbol = (ParameterSymbol)params.get(i);
                for (AnnotationSymbol annotation : parameterSymbol.annotations()) {
                    ModuleSymbol moduleSymbol;
                    ModuleID id;
                    Optional module = annotation.getModule();
                    if (module.isEmpty() || !(id = (moduleSymbol = (ModuleSymbol)module.get()).id()).moduleName().equals("cloud") || !id.orgName().equals("ballerina")) continue;
                    Optional<ListenerInfo> listenerInfo = this.getPortValueFromSTForCustomListener(servicePath, serviceDeclarationNode, i, listenerIndex);
                    if (listenerInfo.isEmpty()) {
                        if (parameterSymbol.paramKind() == ParameterKind.DEFAULTABLE) {
                            this.diagnostics.add(C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.FAILED_DEFAULTABLE_PORT_RETRIEVAL, parameterSymbol.location(), new Object[0]));
                            continue;
                        }
                        this.diagnostics.add(C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.FAILED_PORT_RETRIEVAL, parameterSymbol.location(), new Object[0]));
                        continue;
                    }
                    listenerInfos.add(listenerInfo.get());
                }
            }
        }
        if (!listenerInfos.isEmpty()) {
            this.services.add(new ServiceInfo(listenerInfos, serviceDeclarationNode, servicePath));
        }
    }

    private Optional<ListenerInfo> getPortValueFromSTForCustomListener(String path, ServiceDeclarationNode serviceNode, int paramNo, int listenerIndex) {
        FunctionArgumentNode functionArgumentNode;
        ExpressionNode expressionNode = serviceNode.expressions().get(listenerIndex);
        if (expressionNode.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            SimpleNameReferenceNode referenceNode = (SimpleNameReferenceNode)expressionNode;
            String listenerName = referenceNode.name().text();
            Node node = this.moduleLevelVariables.get(listenerName);
            if (node == null || node.kind() != SyntaxKind.IMPLICIT_NEW_EXPRESSION) {
                return Optional.empty();
            }
            ImplicitNewExpressionNode init = (ImplicitNewExpressionNode)node;
            return this.extractListenerInitializer(listenerName, init, paramNo);
        }
        ExplicitNewExpressionNode refNode = (ExplicitNewExpressionNode)expressionNode;
        SeparatedNodeList<FunctionArgumentNode> arguments = refNode.parenthesizedArgList().arguments();
        if (arguments.size() > paramNo && (functionArgumentNode = arguments.get(paramNo)).kind() == SyntaxKind.POSITIONAL_ARG) {
            ExpressionNode expression = ((PositionalArgumentNode)functionArgumentNode).expression();
            return this.getListenerInfo(path, expression);
        }
        return Optional.empty();
    }

    private boolean isC2CNativelySupportedListener(List<TypeSymbol> typeSymbols) {
        for (TypeSymbol typeSymbol : typeSymbols) {
            if (!this.isC2CNativelySupportedListener(typeSymbol)) continue;
            return true;
        }
        return false;
    }

    private boolean isC2CNativelySupportedListener(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.UNION) {
            UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol;
            List typeSymbols = unionTypeSymbol.memberTypeDescriptors();
            for (TypeSymbol symbol : typeSymbols) {
                if (symbol.typeKind() == TypeDescKind.ERROR) continue;
                return this.isC2CNativelySupportedListener(symbol);
            }
        }
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            Optional module = typeSymbol.getModule();
            if (module.isEmpty() || ((ModuleSymbol)module.get()).getName().isEmpty()) {
                return false;
            }
            String moduleName = (String)((ModuleSymbol)module.get()).getName().get();
            switch (moduleName) {
                case "http": 
                case "grpc": 
                case "graphql": 
                case "tcp": 
                case "udp": 
                case "websocket": 
                case "websub": 
                case "websubhub": {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private String toAbsoluteServicePath(NodeList<Node> servicePathNodes) {
        StringBuilder absoluteServicePath = new StringBuilder();
        for (Node serviceNode : servicePathNodes) {
            if (serviceNode.kind() == SyntaxKind.SLASH_TOKEN) {
                absoluteServicePath.append("/");
                continue;
            }
            if (serviceNode.kind() == SyntaxKind.DOT_TOKEN) {
                absoluteServicePath.append(".");
                continue;
            }
            if (serviceNode.kind() != SyntaxKind.IDENTIFIER_TOKEN) continue;
            IdentifierToken token = (IdentifierToken)serviceNode;
            absoluteServicePath.append(token.text());
        }
        return absoluteServicePath.toString();
    }

    private Optional<ListenerInfo> getHttpListener(String variableName) {
        Node node = this.moduleLevelVariables.get(variableName);
        if (node == null || node.kind() != SyntaxKind.IMPLICIT_NEW_EXPRESSION) {
            return Optional.empty();
        }
        ImplicitNewExpressionNode init = (ImplicitNewExpressionNode)node;
        Optional<ListenerInfo> listenerInfo = this.extractListenerInitializer(variableName, init, 0);
        if (listenerInfo.isEmpty() || init.parenthesizedArgList().isEmpty()) {
            return listenerInfo;
        }
        ListenerInfo listener = listenerInfo.get();
        return Optional.of(listener);
    }

    private Optional<Integer> getPortNumberFromVariable(String variableName) {
        Node node = this.moduleLevelVariables.get(variableName);
        if (node == null || node.kind() != SyntaxKind.MODULE_VAR_DECL) {
            return Optional.empty();
        }
        ModuleVariableDeclarationNode moduleVariableDeclarationNode = (ModuleVariableDeclarationNode)node;
        TypedBindingPatternNode typedBindingPatternNode = moduleVariableDeclarationNode.typedBindingPattern();
        TypeDescriptorNode typeDescriptorNode = typedBindingPatternNode.typeDescriptor();
        if (typeDescriptorNode.kind() != SyntaxKind.INT_TYPE_DESC) {
            return Optional.empty();
        }
        if (moduleVariableDeclarationNode.initializer().isEmpty()) {
            return Optional.empty();
        }
        ExpressionNode expressionNode = moduleVariableDeclarationNode.initializer().get();
        if (expressionNode.kind() == SyntaxKind.REQUIRED_EXPRESSION) {
            this.diagnostics.add(C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.CONFIGURABLE_NO_DEFAULT, moduleVariableDeclarationNode.location(), variableName));
            return Optional.of(0);
        }
        if (expressionNode.kind() != SyntaxKind.NUMERIC_LITERAL) {
            return Optional.empty();
        }
        for (Token qualifier : moduleVariableDeclarationNode.qualifiers()) {
            if (!"configurable".equals(qualifier.text())) continue;
            this.diagnostics.add(C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.CONFIGURABLE_OVERRIDE, moduleVariableDeclarationNode.location(), variableName));
        }
        BasicLiteralNode basicLiteralNode = (BasicLiteralNode)expressionNode;
        return Optional.of(Integer.parseInt(basicLiteralNode.literalToken().text()));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof C2CVisitor)) {
            return false;
        }
        C2CVisitor other = (C2CVisitor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<ServiceInfo> this$services = this.getServices();
        List<ServiceInfo> other$services = other.getServices();
        if (this$services == null ? other$services != null : !((Object)this$services).equals(other$services)) {
            return false;
        }
        Map<String, Node> this$moduleLevelVariables = this.getModuleLevelVariables();
        Map<String, Node> other$moduleLevelVariables = other.getModuleLevelVariables();
        if (this$moduleLevelVariables == null ? other$moduleLevelVariables != null : !((Object)this$moduleLevelVariables).equals(other$moduleLevelVariables)) {
            return false;
        }
        SemanticModel this$semanticModel = this.getSemanticModel();
        SemanticModel other$semanticModel = other.getSemanticModel();
        if (this$semanticModel == null ? other$semanticModel != null : !this$semanticModel.equals(other$semanticModel)) {
            return false;
        }
        List<Diagnostic> this$diagnostics = this.getDiagnostics();
        List<Diagnostic> other$diagnostics = other.getDiagnostics();
        if (this$diagnostics == null ? other$diagnostics != null : !((Object)this$diagnostics).equals(other$diagnostics)) {
            return false;
        }
        Task this$task = this.getTask();
        Task other$task = other.getTask();
        return !(this$task == null ? other$task != null : !this$task.equals(other$task));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof C2CVisitor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<ServiceInfo> $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        Map<String, Node> $moduleLevelVariables = this.getModuleLevelVariables();
        result = result * 59 + ($moduleLevelVariables == null ? 43 : ((Object)$moduleLevelVariables).hashCode());
        SemanticModel $semanticModel = this.getSemanticModel();
        result = result * 59 + ($semanticModel == null ? 43 : $semanticModel.hashCode());
        List<Diagnostic> $diagnostics = this.getDiagnostics();
        result = result * 59 + ($diagnostics == null ? 43 : ((Object)$diagnostics).hashCode());
        Task $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        return result;
    }

    @Generated
    public List<ServiceInfo> getServices() {
        return this.services;
    }

    @Generated
    public Map<String, Node> getModuleLevelVariables() {
        return this.moduleLevelVariables;
    }

    @Generated
    public SemanticModel getSemanticModel() {
        return this.semanticModel;
    }

    @Generated
    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @Generated
    public Task getTask() {
        return this.task;
    }

    @Generated
    public void setTask(Task task) {
        this.task = task;
    }

    @Generated
    public String toString() {
        return "C2CVisitor(services=" + String.valueOf(this.getServices()) + ", moduleLevelVariables=" + String.valueOf(this.getModuleLevelVariables()) + ", semanticModel=" + String.valueOf(this.getSemanticModel()) + ", diagnostics=" + String.valueOf(this.getDiagnostics()) + ", task=" + String.valueOf(this.getTask()) + ")";
    }
}

