/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.util;

import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import java.util.Map;
import java.util.Optional;

public class ModuleLevelVariableExtractor
extends NodeVisitor {
    private Map<String, Node> moduleLevelVariables;

    public ModuleLevelVariableExtractor(Map<String, Node> moduleLevelVariables) {
        this.moduleLevelVariables = moduleLevelVariables;
    }

    @Override
    public void visit(ModuleVariableDeclarationNode moduleVariableDeclarationNode) {
        Optional<ExpressionNode> initializer;
        TypedBindingPatternNode typedBindingPatternNode = moduleVariableDeclarationNode.typedBindingPattern();
        TypeDescriptorNode typeDescriptorNode = typedBindingPatternNode.typeDescriptor();
        BindingPatternNode variableNode = typedBindingPatternNode.bindingPattern();
        if (variableNode.kind() != SyntaxKind.CAPTURE_BINDING_PATTERN) {
            return;
        }
        CaptureBindingPatternNode captureVariableName = (CaptureBindingPatternNode)variableNode;
        String variableName = captureVariableName.variableName().text();
        if (typeDescriptorNode.kind() == SyntaxKind.INT_TYPE_DESC) {
            this.moduleLevelVariables.put(variableName, moduleVariableDeclarationNode);
            return;
        }
        if (typeDescriptorNode.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            return;
        }
        QualifiedNameReferenceNode qualified = (QualifiedNameReferenceNode)typeDescriptorNode;
        String identifier = qualified.identifier().text();
        if (moduleVariableDeclarationNode.initializer().isEmpty()) {
            return;
        }
        if ("ListenerConfiguration".equals(identifier) && (initializer = moduleVariableDeclarationNode.initializer()).isPresent()) {
            if (initializer.get().kind() != SyntaxKind.MAPPING_CONSTRUCTOR) {
                return;
            }
            this.moduleLevelVariables.put(variableName, initializer.get());
            return;
        }
        ExpressionNode initExpression = moduleVariableDeclarationNode.initializer().get();
        if (initExpression.kind() == SyntaxKind.CHECK_EXPRESSION) {
            CheckExpressionNode checkedInit = (CheckExpressionNode)initExpression;
            ExpressionNode expression = checkedInit.expression();
            this.moduleLevelVariables.put(variableName, expression);
            return;
        }
        if ("Listener".equals(identifier)) {
            Optional<ExpressionNode> initializer2 = moduleVariableDeclarationNode.initializer();
            initializer2.ifPresent(expressionNode -> this.moduleLevelVariables.put(variableName, (Node)expressionNode));
        }
    }

    @Override
    public void visit(ListenerDeclarationNode listenerDeclarationNode) {
        String listenerName = listenerDeclarationNode.variableName().text();
        Optional<TypeDescriptorNode> typeDescriptorNode = listenerDeclarationNode.typeDescriptor();
        if (typeDescriptorNode.isEmpty()) {
            return;
        }
        if (typeDescriptorNode.get().kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            return;
        }
        Node initializer = listenerDeclarationNode.initializer();
        this.moduleLevelVariables.put(listenerName, initializer);
    }
}

