/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

public enum OperatorPrecedence {
    MEMBER_ACCESS(0),
    UNARY(1),
    EXPRESSION_ACTION(1),
    MULTIPLICATIVE(2),
    ADDITIVE(3),
    SHIFT(4),
    RANGE(5),
    BINARY_COMPARE(6),
    EQUALITY(7),
    BITWISE_AND(8),
    BITWISE_XOR(9),
    BITWISE_OR(10),
    LOGICAL_AND(11),
    LOGICAL_OR(12),
    ELVIS_CONDITIONAL(13),
    CONDITIONAL(14),
    ANON_FUNC_OR_LET(16),
    REMOTE_CALL_ACTION(17),
    ACTION(18),
    TRAP(19),
    QUERY(20),
    DEFAULT(21);

    private final int level;

    private OperatorPrecedence(int level) {
        this.level = level;
    }

    public boolean isHigherThanOrEqual(OperatorPrecedence opPrecedence, boolean allowActions) {
        if (allowActions && this == EXPRESSION_ACTION && opPrecedence == REMOTE_CALL_ACTION) {
            return false;
        }
        return this.level <= opPrecedence.level;
    }
}

