/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.BreakStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STBreakStatementNode
extends STStatementNode {
    public final STNode breakToken;
    public final STNode semicolonToken;

    STBreakStatementNode(STNode breakToken, STNode semicolonToken) {
        this(breakToken, semicolonToken, Collections.emptyList());
    }

    STBreakStatementNode(STNode breakToken, STNode semicolonToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.BREAK_STATEMENT, diagnostics);
        this.breakToken = breakToken;
        this.semicolonToken = semicolonToken;
        this.addChildren(breakToken, semicolonToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STBreakStatementNode(this.breakToken, this.semicolonToken, diagnostics);
    }

    public STBreakStatementNode modify(STNode breakToken, STNode semicolonToken) {
        if (this.checkForReferenceEquality(breakToken, semicolonToken)) {
            return this;
        }
        return new STBreakStatementNode(breakToken, semicolonToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new BreakStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

