/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ElseBlockNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STElseBlockNode
extends STNode {
    public final STNode elseKeyword;
    public final STNode elseBody;

    STElseBlockNode(STNode elseKeyword, STNode elseBody) {
        this(elseKeyword, elseBody, Collections.emptyList());
    }

    STElseBlockNode(STNode elseKeyword, STNode elseBody, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ELSE_BLOCK, diagnostics);
        this.elseKeyword = elseKeyword;
        this.elseBody = elseBody;
        this.addChildren(elseKeyword, elseBody);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STElseBlockNode(this.elseKeyword, this.elseBody, diagnostics);
    }

    public STElseBlockNode modify(STNode elseKeyword, STNode elseBody) {
        if (this.checkForReferenceEquality(elseKeyword, elseBody)) {
            return this;
        }
        return new STElseBlockNode(elseKeyword, elseBody, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ElseBlockNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

