/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNewExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STExplicitNewExpressionNode
extends STNewExpressionNode {
    public final STNode newKeyword;
    public final STNode typeDescriptor;
    public final STNode parenthesizedArgList;

    STExplicitNewExpressionNode(STNode newKeyword, STNode typeDescriptor, STNode parenthesizedArgList) {
        this(newKeyword, typeDescriptor, parenthesizedArgList, Collections.emptyList());
    }

    STExplicitNewExpressionNode(STNode newKeyword, STNode typeDescriptor, STNode parenthesizedArgList, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.EXPLICIT_NEW_EXPRESSION, diagnostics);
        this.newKeyword = newKeyword;
        this.typeDescriptor = typeDescriptor;
        this.parenthesizedArgList = parenthesizedArgList;
        this.addChildren(newKeyword, typeDescriptor, parenthesizedArgList);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STExplicitNewExpressionNode(this.newKeyword, this.typeDescriptor, this.parenthesizedArgList, diagnostics);
    }

    public STExplicitNewExpressionNode modify(STNode newKeyword, STNode typeDescriptor, STNode parenthesizedArgList) {
        if (this.checkForReferenceEquality(newKeyword, typeDescriptor, parenthesizedArgList)) {
            return this;
        }
        return new STExplicitNewExpressionNode(newKeyword, typeDescriptor, parenthesizedArgList, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ExplicitNewExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

