/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STIntermediateClauseNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.GroupByClauseNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STGroupByClauseNode
extends STIntermediateClauseNode {
    public final STNode groupKeyword;
    public final STNode byKeyword;
    public final STNode groupingKey;

    STGroupByClauseNode(STNode groupKeyword, STNode byKeyword, STNode groupingKey) {
        this(groupKeyword, byKeyword, groupingKey, Collections.emptyList());
    }

    STGroupByClauseNode(STNode groupKeyword, STNode byKeyword, STNode groupingKey, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.GROUP_BY_CLAUSE, diagnostics);
        this.groupKeyword = groupKeyword;
        this.byKeyword = byKeyword;
        this.groupingKey = groupingKey;
        this.addChildren(groupKeyword, byKeyword, groupingKey);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STGroupByClauseNode(this.groupKeyword, this.byKeyword, this.groupingKey, diagnostics);
    }

    public STGroupByClauseNode modify(STNode groupKeyword, STNode byKeyword, STNode groupingKey) {
        if (this.checkForReferenceEquality(groupKeyword, byKeyword, groupingKey)) {
            return this;
        }
        return new STGroupByClauseNode(groupKeyword, byKeyword, groupingKey, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new GroupByClauseNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

