/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeFlags;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.internal.parser.tree.STTreeModifiers;
import io.ballerina.compiler.internal.syntax.NodeListUtils;
import io.ballerina.compiler.internal.syntax.SyntaxUtils;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class STNode {
    public final SyntaxKind kind;
    protected final Collection<STNodeDiagnostic> diagnostics;
    protected int width;
    protected int widthWithLeadingMinutiae;
    protected int widthWithTrailingMinutiae;
    protected int widthWithMinutiae;
    protected byte flags = 0;
    protected static final STNode[] EMPTY_BUCKET = new STNode[0];
    protected int bucketCount;
    protected STNode[] childBuckets = EMPTY_BUCKET;

    STNode(SyntaxKind kind) {
        this.kind = kind;
        this.diagnostics = Collections.emptyList();
    }

    STNode(SyntaxKind kind, Collection<STNodeDiagnostic> diagnostics, boolean isMissing) {
        this(kind, diagnostics);
        if (isMissing) {
            this.flags = STNodeFlags.withFlag(this.flags, (byte)4);
        }
    }

    STNode(SyntaxKind kind, Collection<STNodeDiagnostic> diagnostics) {
        this.kind = kind;
        this.diagnostics = diagnostics;
        if (!diagnostics.isEmpty()) {
            this.flags = STNodeFlags.withFlag(this.flags, (byte)2);
        }
    }

    public STNode childInBucket(int bucket) {
        return this.childBuckets[bucket];
    }

    public int widthWithMinutiae() {
        return this.widthWithMinutiae;
    }

    public int width() {
        return this.width;
    }

    public int widthWithLeadingMinutiae() {
        return this.widthWithLeadingMinutiae;
    }

    public int widthWithTrailingMinutiae() {
        return this.widthWithTrailingMinutiae;
    }

    public STNode leadingMinutiae() {
        throw new UnsupportedOperationException("The leadingMinutiae() method is only supported for STToken instances");
    }

    public STNode trailingMinutiae() {
        throw new UnsupportedOperationException("The trailingMinutiae() method is only supported for STToken instances");
    }

    public boolean hasDiagnostics() {
        return STNodeFlags.isFlagSet(this.flags, (byte)2);
    }

    public Collection<STNodeDiagnostic> diagnostics() {
        return Collections.unmodifiableCollection(this.diagnostics);
    }

    public int bucketCount() {
        return this.bucketCount;
    }

    public boolean isMissing() {
        return STNodeFlags.isFlagSet(this.flags, (byte)4);
    }

    public List<STToken> tokens() {
        ArrayList<STToken> tokens = new ArrayList<STToken>();
        this.tokensInternal(tokens);
        return Collections.unmodifiableList(tokens);
    }

    protected void tokensInternal(List<STToken> tokens) {
        for (STNode child : this.childBuckets) {
            if (!SyntaxUtils.isSTNodePresent(child)) continue;
            child.tokensInternal(tokens);
        }
    }

    public STToken firstToken() {
        return (STToken)this.firstTokenInternal();
    }

    protected STNode firstTokenInternal() {
        for (STNode child : this.childBuckets) {
            STNode firstToken;
            if (SyntaxUtils.isToken(child)) {
                return child;
            }
            if (!SyntaxUtils.isSTNodePresent(child) || NodeListUtils.isSTNodeList(child) && child.bucketCount == 0 || !SyntaxUtils.isSTNodePresent(firstToken = child.firstTokenInternal())) continue;
            return firstToken;
        }
        return null;
    }

    public STToken lastToken() {
        return (STToken)this.lastTokenInternal();
    }

    protected STNode lastTokenInternal() {
        for (int bucket = this.childBuckets.length - 1; bucket >= 0; --bucket) {
            STNode lastToken;
            STNode child = this.childInBucket(bucket);
            if (SyntaxUtils.isToken(child)) {
                return child;
            }
            if (!SyntaxUtils.isSTNodePresent(child) || NodeListUtils.isSTNodeList(child) && child.bucketCount == 0 || !SyntaxUtils.isSTNodePresent(lastToken = child.lastTokenInternal())) continue;
            return lastToken;
        }
        return null;
    }

    public abstract STNode modifyWith(Collection<STNodeDiagnostic> var1);

    public <T extends STNode> T replace(STNode target, STNode replacement) {
        return (T)STTreeModifiers.replace(this, target, replacement);
    }

    public <T extends Node> T createUnlinkedFacade() {
        return (T)this.createFacade(0, null);
    }

    public abstract Node createFacade(int var1, NonTerminalNode var2);

    public abstract void accept(STNodeVisitor var1);

    public abstract <T> T apply(STNodeTransformer<T> var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (STNode child : this.childBuckets) {
            sb.append(child != null ? child.toString() : "");
        }
        return sb.toString();
    }

    public void writeTo(StringBuilder builder) {
        for (STNode child : this.childBuckets) {
            if (!SyntaxUtils.isSTNodePresent(child)) continue;
            child.writeTo(builder);
        }
    }

    public String toSourceCode() {
        StringBuilder builder = new StringBuilder();
        this.writeTo(builder);
        return builder.toString();
    }

    protected void addChildren(STNode ... children) {
        this.bucketCount = children.length;
        this.childBuckets = children;
        if (this.bucketCount == 0) {
            return;
        }
        this.updateDiagnostics(children);
        this.updateWidth(children);
    }

    protected boolean checkForReferenceEquality(STNode ... children) {
        for (int index = 0; index < children.length; ++index) {
            if (this.childBuckets[index] == children[index]) continue;
            return false;
        }
        return true;
    }

    private void updateWidth(STNode[] children) {
        int firstChildIndex = this.getFirstChildIndex(children);
        if (firstChildIndex == -1) {
            return;
        }
        int lastChildIndex = this.getLastChildIndex(children);
        STNode firstChild = children[firstChildIndex];
        STNode lastChild = children[lastChildIndex];
        if (firstChildIndex == lastChildIndex) {
            this.width = firstChild.width;
            this.widthWithLeadingMinutiae = firstChild.widthWithLeadingMinutiae;
            this.widthWithTrailingMinutiae = firstChild.widthWithTrailingMinutiae;
            this.widthWithMinutiae = firstChild.widthWithMinutiae;
            return;
        }
        this.width = firstChild.widthWithTrailingMinutiae + lastChild.widthWithLeadingMinutiae;
        this.widthWithLeadingMinutiae = firstChild.widthWithMinutiae + lastChild.widthWithLeadingMinutiae;
        this.widthWithTrailingMinutiae = firstChild.widthWithTrailingMinutiae + lastChild.widthWithMinutiae;
        this.widthWithMinutiae = firstChild.widthWithMinutiae + lastChild.widthWithMinutiae;
        this.updateWidth(children, firstChildIndex, lastChildIndex);
    }

    private void updateWidth(STNode[] children, int firstChildIndex, int lastChildIndex) {
        for (int index = firstChildIndex + 1; index < lastChildIndex; ++index) {
            STNode child = children[index];
            if (!SyntaxUtils.isSTNodePresent(children[index])) continue;
            this.width += child.widthWithMinutiae;
            this.widthWithLeadingMinutiae += child.widthWithMinutiae;
            this.widthWithTrailingMinutiae += child.widthWithMinutiae;
            this.widthWithMinutiae += child.widthWithMinutiae;
        }
    }

    private int getFirstChildIndex(STNode ... children) {
        for (int index = 0; index < children.length; ++index) {
            STNode child = children[index];
            if (!SyntaxUtils.isSTNodePresent(child) || child.widthWithMinutiae == 0) continue;
            return index;
        }
        return -1;
    }

    private int getLastChildIndex(STNode ... children) {
        for (int index = children.length - 1; index >= 0; --index) {
            STNode child = children[index];
            if (!SyntaxUtils.isSTNodePresent(child) || child.widthWithMinutiae == 0) continue;
            return index;
        }
        return -1;
    }

    private void updateDiagnostics(STNode[] children) {
        for (STNode child : children) {
            if (!SyntaxUtils.isSTNodePresent(child) || !STNodeFlags.isFlagSet(child.flags, (byte)2)) continue;
            this.flags = STNodeFlags.withFlag(this.flags, (byte)2);
            return;
        }
    }
}

