/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STObjectTypeDescriptorNode
extends STTypeDescriptorNode {
    public final STNode objectTypeQualifiers;
    public final STNode objectKeyword;
    public final STNode openBrace;
    public final STNode members;
    public final STNode closeBrace;

    STObjectTypeDescriptorNode(STNode objectTypeQualifiers, STNode objectKeyword, STNode openBrace, STNode members, STNode closeBrace) {
        this(objectTypeQualifiers, objectKeyword, openBrace, members, closeBrace, Collections.emptyList());
    }

    STObjectTypeDescriptorNode(STNode objectTypeQualifiers, STNode objectKeyword, STNode openBrace, STNode members, STNode closeBrace, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.OBJECT_TYPE_DESC, diagnostics);
        this.objectTypeQualifiers = objectTypeQualifiers;
        this.objectKeyword = objectKeyword;
        this.openBrace = openBrace;
        this.members = members;
        this.closeBrace = closeBrace;
        this.addChildren(objectTypeQualifiers, objectKeyword, openBrace, members, closeBrace);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STObjectTypeDescriptorNode(this.objectTypeQualifiers, this.objectKeyword, this.openBrace, this.members, this.closeBrace, diagnostics);
    }

    public STObjectTypeDescriptorNode modify(STNode objectTypeQualifiers, STNode objectKeyword, STNode openBrace, STNode members, STNode closeBrace) {
        if (this.checkForReferenceEquality(objectTypeQualifiers, objectKeyword, openBrace, members, closeBrace)) {
            return this;
        }
        return new STObjectTypeDescriptorNode(objectTypeQualifiers, objectKeyword, openBrace, members, closeBrace, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ObjectTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

