/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STOptionalTypeDescriptorNode
extends STTypeDescriptorNode {
    public final STNode typeDescriptor;
    public final STNode questionMarkToken;

    STOptionalTypeDescriptorNode(STNode typeDescriptor, STNode questionMarkToken) {
        this(typeDescriptor, questionMarkToken, Collections.emptyList());
    }

    STOptionalTypeDescriptorNode(STNode typeDescriptor, STNode questionMarkToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.OPTIONAL_TYPE_DESC, diagnostics);
        this.typeDescriptor = typeDescriptor;
        this.questionMarkToken = questionMarkToken;
        this.addChildren(typeDescriptor, questionMarkToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STOptionalTypeDescriptorNode(this.typeDescriptor, this.questionMarkToken, diagnostics);
    }

    public STOptionalTypeDescriptorNode modify(STNode typeDescriptor, STNode questionMarkToken) {
        if (this.checkForReferenceEquality(typeDescriptor, questionMarkToken)) {
            return this;
        }
        return new STOptionalTypeDescriptorNode(typeDescriptor, questionMarkToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new OptionalTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

