/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QueryConstructTypeNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STQueryConstructTypeNode
extends STNode {
    public final STNode keyword;
    public final STNode keySpecifier;

    STQueryConstructTypeNode(STNode keyword, STNode keySpecifier) {
        this(keyword, keySpecifier, Collections.emptyList());
    }

    STQueryConstructTypeNode(STNode keyword, STNode keySpecifier, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.QUERY_CONSTRUCT_TYPE, diagnostics);
        this.keyword = keyword;
        this.keySpecifier = keySpecifier;
        this.addChildren(keyword, keySpecifier);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STQueryConstructTypeNode(this.keyword, this.keySpecifier, diagnostics);
    }

    public STQueryConstructTypeNode modify(STNode keyword, STNode keySpecifier) {
        if (this.checkForReferenceEquality(keyword, keySpecifier)) {
            return this;
        }
        return new STQueryConstructTypeNode(keyword, keySpecifier, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new QueryConstructTypeNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

