/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STFunctionArgumentNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RestArgumentNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STRestArgumentNode
extends STFunctionArgumentNode {
    public final STNode ellipsis;
    public final STNode expression;

    STRestArgumentNode(STNode ellipsis, STNode expression) {
        this(ellipsis, expression, Collections.emptyList());
    }

    STRestArgumentNode(STNode ellipsis, STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.REST_ARG, diagnostics);
        this.ellipsis = ellipsis;
        this.expression = expression;
        this.addChildren(ellipsis, expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STRestArgumentNode(this.ellipsis, this.expression, diagnostics);
    }

    public STRestArgumentNode modify(STNode ellipsis, STNode expression) {
        if (this.checkForReferenceEquality(ellipsis, expression)) {
            return this;
        }
        return new STRestArgumentNode(ellipsis, expression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new RestArgumentNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

