/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STReturnTypeDescriptorNode
extends STNode {
    public final STNode returnsKeyword;
    public final STNode annotations;
    public final STNode type;

    STReturnTypeDescriptorNode(STNode returnsKeyword, STNode annotations, STNode type) {
        this(returnsKeyword, annotations, type, Collections.emptyList());
    }

    STReturnTypeDescriptorNode(STNode returnsKeyword, STNode annotations, STNode type, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.RETURN_TYPE_DESCRIPTOR, diagnostics);
        this.returnsKeyword = returnsKeyword;
        this.annotations = annotations;
        this.type = type;
        this.addChildren(returnsKeyword, annotations, type);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STReturnTypeDescriptorNode(this.returnsKeyword, this.annotations, this.type, diagnostics);
    }

    public STReturnTypeDescriptorNode modify(STNode returnsKeyword, STNode annotations, STNode type) {
        if (this.checkForReferenceEquality(returnsKeyword, annotations, type)) {
            return this;
        }
        return new STReturnTypeDescriptorNode(returnsKeyword, annotations, type, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ReturnTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

