/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.WaitFieldsListNode;
import java.util.Collection;
import java.util.Collections;

public class STWaitFieldsListNode
extends STNode {
    public final STNode openBrace;
    public final STNode waitFields;
    public final STNode closeBrace;

    STWaitFieldsListNode(STNode openBrace, STNode waitFields, STNode closeBrace) {
        this(openBrace, waitFields, closeBrace, Collections.emptyList());
    }

    STWaitFieldsListNode(STNode openBrace, STNode waitFields, STNode closeBrace, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.WAIT_FIELDS_LIST, diagnostics);
        this.openBrace = openBrace;
        this.waitFields = waitFields;
        this.closeBrace = closeBrace;
        this.addChildren(openBrace, waitFields, closeBrace);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STWaitFieldsListNode(this.openBrace, this.waitFields, this.closeBrace, diagnostics);
    }

    public STWaitFieldsListNode modify(STNode openBrace, STNode waitFields, STNode closeBrace) {
        if (this.checkForReferenceEquality(openBrace, waitFields, closeBrace)) {
            return this;
        }
        return new STWaitFieldsListNode(openBrace, waitFields, closeBrace, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new WaitFieldsListNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

