/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STXMLNavigateExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XMLStepExpressionNode;
import java.util.Collection;
import java.util.Collections;

public class STXMLStepExpressionNode
extends STXMLNavigateExpressionNode {
    public final STNode expression;
    public final STNode xmlStepStart;
    public final STNode xmlStepExtend;

    STXMLStepExpressionNode(STNode expression, STNode xmlStepStart, STNode xmlStepExtend) {
        this(expression, xmlStepStart, xmlStepExtend, Collections.emptyList());
    }

    STXMLStepExpressionNode(STNode expression, STNode xmlStepStart, STNode xmlStepExtend, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.XML_STEP_EXPRESSION, diagnostics);
        this.expression = expression;
        this.xmlStepStart = xmlStepStart;
        this.xmlStepExtend = xmlStepExtend;
        this.addChildren(expression, xmlStepStart, xmlStepExtend);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STXMLStepExpressionNode(this.expression, this.xmlStepStart, this.xmlStepExtend, diagnostics);
    }

    public STXMLStepExpressionNode modify(STNode expression, STNode xmlStepStart, STNode xmlStepExtend) {
        if (this.checkForReferenceEquality(expression, xmlStepStart, xmlStepExtend)) {
            return this;
        }
        return new STXMLStepExpressionNode(expression, xmlStepStart, xmlStepExtend, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new XMLStepExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

